/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.editor;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class ProblemEditorPart
extends EditorPart {
    protected Diagnostic diagnostic;
    protected String editorToOpen;
    protected Label imageLabel;
    protected Text messageText;
    protected Button detailsButton;
    protected Composite detailsComposite;
    protected Control detailsControl;
    protected TreeViewer detailsTreeViewer;
    protected Text exceptionText;
    protected MarkerHelper markerUtil;

    public void dispose() {
        this.diagnostic = null;
        this.imageLabel = null;
        this.messageText = null;
        this.detailsButton = null;
        this.detailsComposite = null;
        this.detailsControl = null;
        this.detailsTreeViewer = null;
        this.exceptionText = null;
        this.markerUtil = null;
        super.dispose();
    }

    public void setMarkerHelper(MarkerHelper markerHelper) {
        this.markerUtil = markerHelper;
    }

    public MarkerHelper getMarkerHelper() {
        return this.markerUtil;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(CommonUIPlugin.getPlugin().getString("_UI_Problems_label"));
    }

    public void createPartControl(Composite parent) {
        int margins;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        int spacing = 8;
        layout.marginBottom = margins = 8;
        layout.marginTop = margins;
        layout.marginLeft = margins;
        layout.marginRight = margins;
        layout.horizontalSpacing = spacing;
        layout.verticalSpacing = spacing;
        parent.setLayout((Layout)layout);
        this.imageLabel = new Label(parent, 0);
        this.messageText = new Text(parent, 524362);
        this.messageText.setLayoutData((Object)new GridData(770));
        this.messageText.setBackground(this.messageText.getDisplay().getSystemColor(22));
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(130));
        buttonComposite.setLayout((Layout)new GridLayout());
        GridLayout layout2 = new GridLayout();
        int spacing2 = 3;
        layout2.marginTop = -5;
        layout2.marginRight = -5;
        layout2.horizontalSpacing = spacing2;
        layout2.verticalSpacing = spacing2;
        buttonComposite.setLayout((Layout)layout2);
        this.editorToOpen = this.computeEditorToOpen();
        if (this.editorToOpen != null) {
            Button openButton = new Button(buttonComposite, 8);
            openButton.setLayoutData((Object)new GridData(800));
            openButton.setText(CommonUIPlugin.getPlugin().getString("_UI_ErrorEditor_OpenEditor_label"));
            openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProblemEditorPart.this.openEditor();
                }
            });
        }
        if (this.markerUtil != null) {
            Button createMarkersButton = new Button(buttonComposite, 8);
            createMarkersButton.setLayoutData((Object)new GridData(800));
            createMarkersButton.setText(CommonUIPlugin.getPlugin().getString("_UI_ErrorEditor_CreateMarkers_label"));
            createMarkersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProblemEditorPart.this.createMarkers();
                }
            });
        }
        this.detailsButton = new Button(buttonComposite, 8);
        this.detailsButton.setLayoutData((Object)new GridData(800));
        this.detailsButton.setData((Object)Boolean.FALSE);
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProblemEditorPart.this.toggleDetails();
            }
        });
        this.updateDetails();
        this.detailsComposite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 2;
        this.detailsComposite.setLayoutData((Object)data);
        GridLayout layout3 = new GridLayout();
        int margin = -5;
        int spacing3 = 3;
        layout3.marginTop = margin;
        layout3.marginLeft = margin;
        layout3.marginRight = margin;
        layout3.marginBottom = margin;
        layout3.horizontalSpacing = spacing3;
        layout3.verticalSpacing = spacing3;
        this.detailsComposite.setLayout((Layout)layout3);
        this.refresh();
        parent.layout(true);
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public void setDiagnostic(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
        this.refresh();
    }

    protected void refresh() {
        if (this.diagnostic != null && this.messageText != null) {
            Image image = this.getImage();
            if (image != null) {
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                this.imageLabel.setLayoutData((Object)new GridData(66));
            }
            this.messageText.setText(this.getMessage());
            if (this.detailsTreeViewer != null && this.detailsTreeViewer.getInput() != this.diagnostic) {
                this.detailsTreeViewer.setInput((Object)this.diagnostic);
                this.exceptionText.setText("");
            }
        }
    }

    protected Image getImage() {
        Display display = Display.getCurrent();
        switch (this.diagnostic.getSeverity()) {
            case 4: {
                return display.getSystemImage(1);
            }
            case 2: {
                return display.getSystemImage(8);
            }
        }
        return display.getSystemImage(2);
    }

    protected String getMessage() {
        return this.diagnostic.getSeverity() == 0 ? CommonUIPlugin.getPlugin().getString("_UI_NoProblems_message") : (this.diagnostic.getMessage() != null ? this.diagnostic.getMessage() : CommonUIPlugin.getPlugin().getString("_UI_DefaultProblem_message"));
    }

    protected void updateDetails() {
        if (this.detailsButton.getData() == Boolean.TRUE) {
            if (this.detailsControl == null) {
                this.detailsControl = this.createDetailsControl(this.detailsComposite);
                this.detailsComposite.layout(true);
            } else {
                this.detailsControl.setVisible(true);
            }
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        } else {
            if (this.detailsControl != null) {
                this.detailsControl.setVisible(false);
            }
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        }
    }

    protected Control createDetailsControl(Composite parent) {
        SashForm detailsComposite = new SashForm(parent, 512);
        detailsComposite.setLayoutData((Object)new GridData(1808));
        this.detailsTreeViewer = new TreeViewer((Composite)detailsComposite, 2048);
        this.detailsTreeViewer.getTree().setLayoutData((Object)new GridData(1810));
        this.exceptionText = new Text((Composite)detailsComposite, 2826);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 20;
        gridData.grabExcessVerticalSpace = true;
        this.exceptionText.setLayoutData((Object)gridData);
        this.exceptionText.setBackground(this.exceptionText.getDisplay().getSystemColor(25));
        detailsComposite.setWeights(new int[]{70, 30});
        this.detailsTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){
            private boolean isRootElement = true;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (this.isRootElement) {
                    this.isRootElement = false;
                    Diagnostic diagnostic = (Diagnostic)inputElement;
                    if (diagnostic.getMessage() != null || diagnostic.getException() != null) {
                        return new Object[]{diagnostic};
                    }
                }
                return this.getChildren(inputElement);
            }

            public boolean hasChildren(Object element) {
                return !((Diagnostic)element).getChildren().isEmpty();
            }

            public Object[] getChildren(Object parentElement) {
                return ((Diagnostic)parentElement).getChildren().toArray();
            }
        });
        this.detailsTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Diagnostic diagnostic = (Diagnostic)element;
                String message = diagnostic.getMessage();
                if (message == null) {
                    switch (diagnostic.getSeverity()) {
                        case 4: {
                            message = CommonUIPlugin.getPlugin().getString("_UI_DiagnosticError_label");
                            break;
                        }
                        case 2: {
                            message = CommonUIPlugin.getPlugin().getString("_UI_DiagnosticWarning_label");
                            break;
                        }
                        default: {
                            message = CommonUIPlugin.getPlugin().getString("_UI_Diagnostic_label");
                        }
                    }
                }
                return message;
            }
        });
        this.detailsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Diagnostic diagnostic;
                Throwable throwable;
                if (!event.getSelection().isEmpty() && (throwable = (diagnostic = (Diagnostic)((IStructuredSelection)event.getSelection()).getFirstElement()).getException()) != null) {
                    StringWriter in = new StringWriter();
                    PrintWriter ps = new PrintWriter(in);
                    throwable.printStackTrace(ps);
                    String text = in.getBuffer().toString();
                    ProblemEditorPart.this.exceptionText.setText(text);
                    return;
                }
                ProblemEditorPart.this.exceptionText.setText("");
            }
        });
        this.detailsTreeViewer.setInput((Object)this.diagnostic);
        return detailsComposite;
    }

    protected void toggleDetails() {
        this.detailsButton.setData((Object)(this.detailsButton.getData() == Boolean.TRUE ? Boolean.FALSE : Boolean.TRUE));
        this.updateDetails();
    }

    protected String computeEditorToOpen() {
        IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("foo.txt");
        return editorDescriptor != null ? editorDescriptor.getId() : null;
    }

    protected void openEditor() {
        if (this.editorToOpen != null) {
            try {
                Diagnostic diagnostic;
                IEditorInput diagnosticEditorInput;
                IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorInput editorInput = this.getEditorInput();
                if (this.markerUtil != null && this.detailsTreeViewer != null && this.detailsControl.isVisible() && (diagnosticEditorInput = this.markerUtil.getEditorInput(diagnostic = (Diagnostic)((IStructuredSelection)this.detailsTreeViewer.getSelection()).getFirstElement())) != null) {
                    editorInput = diagnosticEditorInput;
                }
                workbenchPage.openEditor(editorInput, this.editorToOpen, true, 3);
            }
            catch (Exception exception) {
                this.openErrorDialog(CommonUIPlugin.getPlugin().getString("_UI_OpenEditorError_message"), exception);
            }
        }
    }

    protected void createMarkers() {
        if (this.markerUtil != null) {
            this.markerUtil.deleteMarkers(this.diagnostic);
            if (this.diagnostic.getSeverity() != 0) {
                try {
                    this.markerUtil.createMarkers(this.diagnostic);
                }
                catch (CoreException exception) {
                    this.openErrorDialog(CommonUIPlugin.getPlugin().getString("_UI_CreateMarkerError_message"), (Exception)((Object)exception));
                }
            }
        }
    }

    protected void openErrorDialog(String message, Exception exception) {
        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)CommonUIPlugin.getPlugin().getString("_UI_Error_label"), (String)message, (IStatus)(exception instanceof CoreException ? ((CoreException)((Object)exception)).getStatus() : BasicDiagnostic.toIStatus((Diagnostic)BasicDiagnostic.toDiagnostic((Throwable)exception))));
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }
}

