/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.ui.ProjectSelectionDialog;

public class ProjectBlock
extends AbstractLaunchConfigurationTab {
    private Text fProjText;
    private Button projectButton;

    public void createControl(Composite parent) {
        this.setControl((Control)parent);
        this.createProjectEditor(parent);
    }

    public String getSelectedProject() {
        return this.fProjText.getText();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ATTR_PROJECT_NAME", "");
    }

    public void initializeFrom(ILaunchConfiguration config) {
        String projectName = "";
        try {
            projectName = config.getAttribute("ATTR_PROJECT_NAME", "");
        }
        catch (CoreException ce) {
            PerlDebugPlugin.log(ce);
        }
        this.fProjText.setText(projectName);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ATTR_PROJECT_NAME", this.fProjText.getText());
    }

    public String getName() {
        return "Project";
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0) {
            if (!ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
                this.setErrorMessage("Project does not exist");
                return false;
            }
        } else {
            this.setErrorMessage("Specify Project");
            return false;
        }
        return true;
    }

    private void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("&Project:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fProjText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ProjectBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.projectButton = this.createPushButton((Composite)group, "&Browse...", null);
        this.projectButton.addSelectionListener((SelectionListener)new ButtonListener());
    }

    protected void newProjectSelected() {
    }

    private class ButtonListener
    extends SelectionAdapter {
        ButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ProjectSelectionDialog dialog = new ProjectSelectionDialog(ProjectBlock.this.getShell());
            if (dialog.open() == 0 && !ProjectBlock.this.fProjText.getText().equals((String)dialog.getFirstResult())) {
                ProjectBlock.this.fProjText.setText((String)dialog.getFirstResult());
                ProjectBlock.this.newProjectSelected();
            }
        }
    }
}

