/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.IScannableCodeBase;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.DelegatingCodeBaseEntry;
import edu.umd.cs.findbugs.classfile.impl.DelegatingCodeBaseIterator;
import edu.umd.cs.findbugs.classfile.impl.NestedZipFileCodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.ZipFileCodeBase;
import edu.umd.cs.findbugs.io.IO;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NestedZipFileCodeBase
extends AbstractScannableCodeBase
implements IScannableCodeBase {
    private ICodeBase parentCodeBase;
    private String resourceName;
    private File tempFile;
    private ZipFileCodeBase delegateCodeBase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NestedZipFileCodeBase(NestedZipFileCodeBaseLocator codeBaseLocator) throws ResourceNotFoundException, IOException {
        BufferedOutputStream outputStream;
        block5: {
            super(codeBaseLocator);
            this.parentCodeBase = codeBaseLocator.getParentCodeBase();
            this.resourceName = codeBaseLocator.getResourceName();
            InputStream inputStream = null;
            outputStream = null;
            try {
                this.tempFile = File.createTempFile("findbugs", ".zip");
                this.tempFile.deleteOnExit();
                inputStream = this.parentCodeBase.lookupResource(this.resourceName).openResource();
                outputStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
                IO.copy(inputStream, outputStream);
                ((OutputStream)outputStream).flush();
                this.delegateCodeBase = new ZipFileCodeBase(codeBaseLocator, this.tempFile);
                if (inputStream == null) break block5;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    IO.close(inputStream);
                }
                if (outputStream != null) {
                    IO.close(outputStream);
                }
                throw throwable;
            }
            IO.close(inputStream);
        }
        if (outputStream != null) {
            IO.close(outputStream);
        }
    }

    public ICodeBaseIterator iterator() throws InterruptedException {
        return new DelegatingCodeBaseIterator(this, this.delegateCodeBase);
    }

    public ICodeBaseEntry lookupResource(String resourceName) throws ResourceNotFoundException {
        ICodeBaseEntry delegateCodeBaseEntry = this.delegateCodeBase.lookupResource(resourceName);
        return new DelegatingCodeBaseEntry(this, delegateCodeBaseEntry);
    }

    public String getPathName() {
        return null;
    }

    public void close() {
        this.delegateCodeBase.close();
        this.tempFile.delete();
    }
}

