/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowValueChooser;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.NullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonCollector;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonFinder;
import edu.umd.cs.findbugs.ba.npe.NullValueUnconditionalDeref;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessProperty;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.PointerUsageRequiringNonNullValue;
import edu.umd.cs.findbugs.ba.npe.RedundantBranch;
import edu.umd.cs.findbugs.ba.npe.ReturnPathType;
import edu.umd.cs.findbugs.ba.npe.ReturnPathTypeDataflow;
import edu.umd.cs.findbugs.ba.npe.UsagesRequiringNonNullValues;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.detect.DoomedCodeWarningProperty;
import edu.umd.cs.findbugs.detect.NullArgumentWarningProperty;
import edu.umd.cs.findbugs.detect.NullDerefProperty;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import edu.umd.cs.findbugs.props.GeneralWarningProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.props.WarningPropertyUtil;
import edu.umd.cs.findbugs.visitclass.Util;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.ReturnInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNullDeref
implements Detector,
NullDerefAndRedundantComparisonCollector {
    public static final boolean DEBUG = SystemProperties.getBoolean((String)"fnd.debug");
    private static final boolean DEBUG_NULLARG = SystemProperties.getBoolean((String)"fnd.debug.nullarg");
    private static final boolean DEBUG_NULLRETURN = SystemProperties.getBoolean((String)"fnd.debug.nullreturn");
    private static final boolean MARK_DOOMED = SystemProperties.getBoolean((String)"fnd.markdoomed", (boolean)true);
    private static final boolean REPORT_SAFE_METHOD_TARGETS = true;
    private static final String METHOD = SystemProperties.getProperty((String)"fnd.method");
    private static final String CLASS = SystemProperties.getProperty((String)"fnd.class");
    private BugReporter bugReporter;
    private ParameterNullnessPropertyDatabase unconditionalDerefParamDatabase;
    private boolean checkedDatabases = false;
    private ClassContext classContext;
    private Method method;
    private IsNullValueDataflow invDataflow;
    private BitSet previouslyDeadBlocks;
    private NullnessAnnotation methodAnnotation;

    public FindNullDeref(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        this.classContext = classContext;
        String currentMethod = null;
        JavaClass jclass = classContext.getJavaClass();
        String className = jclass.getClassName();
        if (CLASS != null && !className.equals(CLASS)) {
            return;
        }
        for (Method method : methodList = jclass.getMethods()) {
            try {
                MethodGen mg;
                if (method.isAbstract() || method.isNative() || method.getCode() == null || (mg = classContext.getMethodGen(method)) == null) continue;
                currentMethod = SignatureConverter.convertMethodSignature((MethodGen)mg);
                if (METHOD != null && !method.getName().equals(METHOD)) continue;
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Checking for NP in ").append(currentMethod).toString());
                }
                this.analyzeMethod(classContext, method);
            }
            catch (MissingClassException e) {
                this.bugReporter.reportMissingClass(e.getClassNotFoundException());
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError(new StringBuffer().append("While analyzing ").append(currentMethod).append(": FindNullDeref caught dae exception").toString(), (Throwable)e);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError(new StringBuffer().append("While analyzing ").append(currentMethod).append(": FindNullDeref caught cfgb exception").toString(), (Throwable)e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        MethodGen methodGen;
        if (DEBUG || DEBUG_NULLARG) {
            System.out.println("Pre FND ");
        }
        if ((methodGen = classContext.getMethodGen(method)) == null) {
            return;
        }
        if (!this.checkedDatabases) {
            this.checkDatabases();
            this.checkedDatabases = true;
        }
        this.method = method;
        this.methodAnnotation = this.getMethodNullnessAnnotation();
        if (DEBUG || DEBUG_NULLARG) {
            System.out.println(new StringBuffer().append("FND: ").append(SignatureConverter.convertMethodSignature((MethodGen)methodGen)).toString());
        }
        this.previouslyDeadBlocks = this.findPreviouslyDeadBlocks();
        this.invDataflow = classContext.getIsNullValueDataflow(method);
        NullDerefAndRedundantComparisonFinder worker = new NullDerefAndRedundantComparisonFinder(classContext, method, (NullDerefAndRedundantComparisonCollector)this);
        worker.execute();
        this.checkCallSitesAndReturnInstructions();
    }

    private BitSet findPreviouslyDeadBlocks() throws DataflowAnalysisException, CFGBuilderException {
        BitSet deadBlocks = new BitSet();
        ValueNumberDataflow vnaDataflow = this.classContext.getValueNumberDataflow(this.method);
        Iterator i = vnaDataflow.getCFG().blockIterator();
        while (i.hasNext()) {
            BasicBlock block = (BasicBlock)i.next();
            ValueNumberFrame vnaFrame = (ValueNumberFrame)vnaDataflow.getStartFact(block);
            if (!vnaFrame.isTop()) continue;
            deadBlocks.set(block.getId());
        }
        return deadBlocks;
    }

    private void checkDatabases() {
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        this.unconditionalDerefParamDatabase = analysisContext.getUnconditionalDerefParamDatabase();
    }

    private <DatabaseType extends PropertyDatabase<?, ?>> boolean isDatabaseNonEmpty(DatabaseType database) {
        return database != null && !database.isEmpty();
    }

    private NullnessAnnotation getMethodNullnessAnnotation() {
        if (this.method.getSignature().indexOf(")L") >= 0 || this.method.getSignature().indexOf(")[") >= 0) {
            if (DEBUG_NULLRETURN) {
                System.out.println(new StringBuffer().append("Checking return annotation for ").append(SignatureConverter.convertMethodSignature((JavaClass)this.classContext.getJavaClass(), (Method)this.method)).toString());
            }
            XMethod m = XFactory.createXMethod((JavaClass)this.classContext.getJavaClass(), (Method)this.method);
            return AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation((Object)m, false);
        }
        return NullnessAnnotation.UNKNOWN_NULLNESS;
    }

    private void checkCallSitesAndReturnInstructions() {
        try {
            ConstantPoolGen cpg = this.classContext.getConstantPoolGen();
            TypeDataflow typeDataflow = this.classContext.getTypeDataflow(this.method);
            Iterator i = this.classContext.getCFG(this.method).locationIterator();
            while (i.hasNext()) {
                Location location = (Location)i.next();
                Instruction ins = location.getHandle().getInstruction();
                try {
                    ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
                    if (!vnaFrame.isValid()) continue;
                    if (ins instanceof InvokeInstruction) {
                        this.examineCallSite(location, cpg, typeDataflow);
                        continue;
                    }
                    if (this.methodAnnotation == NullnessAnnotation.NONNULL && ins.getOpcode() == 176) {
                        this.examineReturnInstruction(location);
                        continue;
                    }
                    if (!(ins instanceof PUTFIELD)) continue;
                    this.examinePutfieldInstruction(location, (PUTFIELD)ins, cpg);
                }
                catch (ClassNotFoundException e) {
                    this.bugReporter.reportMissingClass(e);
                }
            }
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError((String)"error:", (Exception)((Object)e));
        }
    }

    private void examineCallSite(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow) throws DataflowAnalysisException, CFGBuilderException, ClassNotFoundException {
        InvokeInstruction invokeInstruction = (InvokeInstruction)location.getHandle().getInstruction();
        String methodName = invokeInstruction.getName(cpg);
        String signature = invokeInstruction.getSignature(cpg);
        if (methodName.equals("equals") && signature.equals("(Ljava/lang/Object;)Z")) {
            return;
        }
        int returnTypeStart = signature.indexOf(41);
        if (returnTypeStart < 0) {
            return;
        }
        String paramList = signature.substring(0, returnTypeStart + 1);
        if (paramList.equals("()") || paramList.indexOf("L") < 0 && paramList.indexOf(91) < 0) {
            return;
        }
        IsNullValueFrame frame = this.classContext.getIsNullValueDataflow(this.method).getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        BitSet nullArgSet = frame.getArgumentSet(invokeInstruction, cpg, (DataflowValueChooser)new DataflowValueChooser<IsNullValue>(){

            public boolean choose(IsNullValue value) {
                return value.mightBeNull() && !value.isException() && !value.isReturnValue();
            }

            public /* synthetic */ boolean choose(Object x0) {
                return this.choose((IsNullValue)x0);
            }
        });
        BitSet definitelyNullArgSet = frame.getArgumentSet(invokeInstruction, cpg, (DataflowValueChooser)new DataflowValueChooser<IsNullValue>(){

            public boolean choose(IsNullValue value) {
                return value.isDefinitelyNull();
            }

            public /* synthetic */ boolean choose(Object x0) {
                return this.choose((IsNullValue)x0);
            }
        });
        nullArgSet.and(definitelyNullArgSet);
        if (nullArgSet.isEmpty()) {
            return;
        }
        if (DEBUG_NULLARG) {
            System.out.println(new StringBuffer().append("Null arguments passed: ").append(nullArgSet).toString());
            System.out.println(new StringBuffer().append("Frame is: ").append(frame).toString());
            System.out.println(new StringBuffer().append("# arguments: ").append(frame.getNumArguments(invokeInstruction, cpg)).toString());
            XMethod xm = XFactory.createXMethod((InvokeInstruction)invokeInstruction, (ConstantPoolGen)cpg);
            System.out.print(new StringBuffer().append("Signature: ").append(xm.getSignature()).toString());
        }
        if (this.unconditionalDerefParamDatabase != null) {
            this.checkUnconditionallyDereferencedParam(location, cpg, typeDataflow, invokeInstruction, nullArgSet, definitelyNullArgSet);
        }
        if (DEBUG_NULLARG) {
            System.out.println("Checking nonnull params");
        }
        this.checkNonNullParam(location, cpg, typeDataflow, invokeInstruction, nullArgSet, definitelyNullArgSet);
    }

    private void examinePutfieldInstruction(Location location, PUTFIELD ins, ConstantPoolGen cpg) throws DataflowAnalysisException, CFGBuilderException {
        IsNullValueDataflow invDataflow = this.classContext.getIsNullValueDataflow(this.method);
        IsNullValueFrame frame = invDataflow.getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        IsNullValue tos = (IsNullValue)frame.getTopValue();
        if (tos.isDefinitelyNull()) {
            XField field = XFactory.createXField((FieldInstruction)ins, (ConstantPoolGen)cpg);
            NullnessAnnotation annotation = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation((Object)field, false);
            if (annotation == NullnessAnnotation.NONNULL) {
                BugAnnotation variableAnnotation = null;
                try {
                    ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
                    ValueNumber valueNumber = (ValueNumber)vnaFrame.getTopValue();
                    variableAnnotation = NullDerefAndRedundantComparisonFinder.findAnnotationFromValueNumber((Method)this.method, (Location)location, (ValueNumber)valueNumber, (ValueNumberFrame)vnaFrame);
                }
                catch (DataflowAnalysisException e) {
                    AnalysisContext.logError((String)"error", (Exception)((Object)e));
                }
                catch (CFGBuilderException e) {
                    AnalysisContext.logError((String)"error", (Exception)((Object)e));
                }
                BugInstance warning = new BugInstance((Detector)this, "NP_STORE_INTO_NONNULL_FIELD", tos.isDefinitelyNull() ? 1 : 2).addClassAndMethod(this.classContext.getJavaClass(), this.method).addField(field).addOptionalAnnotation(variableAnnotation).addSourceLine(this.classContext, this.method, location);
                this.bugReporter.reportBug(warning);
            }
        }
    }

    private void examineReturnInstruction(Location location) throws DataflowAnalysisException, CFGBuilderException {
        if (DEBUG_NULLRETURN) {
            System.out.println(new StringBuffer().append("Checking null return at ").append(location).toString());
        }
        IsNullValueDataflow invDataflow = this.classContext.getIsNullValueDataflow(this.method);
        IsNullValueFrame frame = invDataflow.getFactAtLocation(location);
        ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
        if (!vnaFrame.isValid()) {
            return;
        }
        ValueNumber valueNumber = (ValueNumber)vnaFrame.getTopValue();
        if (!frame.isValid()) {
            return;
        }
        IsNullValue tos = (IsNullValue)frame.getTopValue();
        if (tos.isDefinitelyNull()) {
            String methodName;
            BugAnnotation variable = NullDerefAndRedundantComparisonFinder.findAnnotationFromValueNumber((Method)this.method, (Location)location, (ValueNumber)valueNumber, (ValueNumberFrame)vnaFrame);
            String bugPattern = "NP_NONNULL_RETURN_VIOLATION";
            int priority = 2;
            if (tos.isDefinitelyNull() && !tos.isException()) {
                priority = 1;
            }
            if ((methodName = this.method.getName()).equals("clone")) {
                bugPattern = "NP_CLONE_COULD_RETURN_NULL";
                priority = 2;
            } else if (methodName.equals("toString")) {
                bugPattern = "NP_TOSTRING_COULD_RETURN_NULL";
                priority = 2;
            }
            BugInstance warning = new BugInstance((Detector)this, bugPattern, priority).addClassAndMethod(this.classContext.getJavaClass(), this.method).addOptionalAnnotation(variable).addSourceLine(this.classContext, this.method, location);
            this.bugReporter.reportBug(warning);
        }
    }

    private void checkUnconditionallyDereferencedParam(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow, InvokeInstruction invokeInstruction, BitSet nullArgSet, BitSet definitelyNullArgSet) throws DataflowAnalysisException, ClassNotFoundException {
        int priority;
        String bugType;
        boolean privateCall;
        boolean caught = this.inCatchNullBlock(location);
        if (caught && this.skipIfInsideCatchNull()) {
            return;
        }
        TypeFrame typeFrame = typeDataflow.getFactAtLocation(location);
        Set targetMethodSet = Hierarchy.resolveMethodCallTargets((InvokeInstruction)invokeInstruction, (TypeFrame)typeFrame, (ConstantPoolGen)cpg);
        if (DEBUG_NULLARG) {
            System.out.println(new StringBuffer().append("Possibly called methods: ").append(targetMethodSet).toString());
        }
        BitSet unconditionallyDereferencedNullArgSet = new BitSet();
        LinkedList<JavaClassAndMethod> dangerousCallTargetList = new LinkedList<JavaClassAndMethod>();
        LinkedList<JavaClassAndMethod> veryDangerousCallTargetList = new LinkedList<JavaClassAndMethod>();
        for (JavaClassAndMethod targetMethod : targetMethodSet) {
            BitSet targetUnconditionallyDereferencedNullArgSet;
            ParameterNullnessProperty property;
            if (DEBUG_NULLARG) {
                System.out.println(new StringBuffer().append("For target method ").append(targetMethod).toString());
            }
            if ((property = (ParameterNullnessProperty)this.unconditionalDerefParamDatabase.getProperty((ClassMember)targetMethod.toXMethod())) == null) continue;
            if (DEBUG_NULLARG) {
                System.out.println(new StringBuffer().append("\tUnconditionally dereferenced params: ").append(property).toString());
            }
            if ((targetUnconditionallyDereferencedNullArgSet = property.getViolatedParamSet(nullArgSet)).isEmpty()) continue;
            dangerousCallTargetList.add(targetMethod);
            unconditionallyDereferencedNullArgSet.or(targetUnconditionallyDereferencedNullArgSet);
            if (property.getViolatedParamSet(definitelyNullArgSet).isEmpty()) continue;
            veryDangerousCallTargetList.add(targetMethod);
        }
        if (dangerousCallTargetList.isEmpty()) {
            return;
        }
        WarningPropertySet propertySet = new WarningPropertySet();
        HashSet safeCallTargetSet = new HashSet();
        safeCallTargetSet.addAll(targetMethodSet);
        safeCallTargetSet.removeAll(dangerousCallTargetList);
        if (safeCallTargetSet.isEmpty()) {
            propertySet.addProperty((WarningProperty)NullArgumentWarningProperty.ALL_DANGEROUS_TARGETS);
            if (dangerousCallTargetList.size() == 1) {
                propertySet.addProperty((WarningProperty)NullArgumentWarningProperty.MONOMORPHIC_CALL_SITE);
            }
        }
        boolean bl = privateCall = safeCallTargetSet.isEmpty() && dangerousCallTargetList.size() == 1 && ((JavaClassAndMethod)dangerousCallTargetList.get(0)).getMethod().isPrivate();
        if (privateCall || invokeInstruction.getOpcode() == 184 || invokeInstruction.getOpcode() == 183) {
            bugType = "NP_NULL_PARAM_DEREF_NONVIRTUAL";
            priority = 1;
        } else if (safeCallTargetSet.isEmpty()) {
            bugType = "NP_NULL_PARAM_DEREF_ALL_TARGETS_DANGEROUS";
            priority = 2;
        } else {
            return;
        }
        if (caught) {
            ++priority;
        }
        if (dangerousCallTargetList.size() > veryDangerousCallTargetList.size()) {
            ++priority;
        } else {
            propertySet.addProperty((WarningProperty)NullArgumentWarningProperty.ACTUAL_PARAMETER_GUARANTEED_NULL);
        }
        BugInstance warning = new BugInstance((Detector)this, bugType, priority).addClassAndMethod(this.classContext.getJavaClass(), this.method).addMethod(XFactory.createXMethod((InvokeInstruction)invokeInstruction, (ConstantPoolGen)cpg)).describe("METHOD_CALLED").addSourceLine(this.classContext, this.method, location);
        this.addParamAnnotations(location, definitelyNullArgSet, unconditionallyDereferencedNullArgSet, propertySet, warning);
        this.decorateWarning(location, propertySet, warning);
        this.bugReporter.reportBug(warning);
    }

    private void decorateWarning(Location location, WarningPropertySet propertySet, BugInstance warning) {
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)this.classContext, (Method)this.method, (Location)location);
        }
        propertySet.decorateBugInstance(warning);
    }

    private void addParamAnnotations(Location location, BitSet definitelyNullArgSet, BitSet violatedParamSet, WarningPropertySet propertySet, BugInstance warning) {
        ValueNumberFrame vnaFrame = null;
        try {
            vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError((String)"error", (Exception)((Object)e));
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError((String)"error", (Exception)((Object)e));
        }
        InvokeInstruction instruction = (InvokeInstruction)location.getHandle().getInstruction();
        SignatureParser sigParser = new SignatureParser(instruction.getSignature(this.classContext.getConstantPoolGen()));
        int i = violatedParamSet.nextSetBit(0);
        while (i >= 0) {
            boolean definitelyNull = definitelyNullArgSet.get(i);
            if (definitelyNull) {
                propertySet.addProperty((WarningProperty)NullArgumentWarningProperty.ARG_DEFINITELY_NULL);
            }
            ValueNumber valueNumber = null;
            if (vnaFrame != null) {
                try {
                    valueNumber = (ValueNumber)vnaFrame.getArgument(instruction, this.classContext.getConstantPoolGen(), i, sigParser);
                    BugAnnotation variableAnnotation = NullDerefAndRedundantComparisonFinder.findAnnotationFromValueNumber((Method)this.method, (Location)location, (ValueNumber)valueNumber, (ValueNumberFrame)vnaFrame);
                    warning.addOptionalAnnotation(variableAnnotation);
                }
                catch (DataflowAnalysisException e) {
                    AnalysisContext.logError((String)"error", (Exception)((Object)e));
                }
            }
            warning.addInt(i + 1).describe(definitelyNull ? "INT_NULL_ARG" : "INT_MAYBE_NULL_ARG");
            i = violatedParamSet.nextSetBit(i + 1);
        }
    }

    private void checkNonNullParam(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow, InvokeInstruction invokeInstruction, BitSet nullArgSet, BitSet definitelyNullArgSet) throws ClassNotFoundException {
        boolean caught = this.inCatchNullBlock(location);
        if (caught && this.skipIfInsideCatchNull()) {
            return;
        }
        XMethod m = XFactory.createXMethod((InvokeInstruction)invokeInstruction, (ConstantPoolGen)cpg);
        NullnessAnnotationDatabase db = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
        SignatureParser sigParser = new SignatureParser(invokeInstruction.getSignature(cpg));
        int i = nullArgSet.nextSetBit(0);
        while (i >= 0) {
            if (db.parameterMustBeNonNull(m, i)) {
                int priority;
                boolean definitelyNull = definitelyNullArgSet.get(i);
                if (DEBUG_NULLARG) {
                    System.out.println(new StringBuffer().append("QQQ2: ").append(i).append(" -- ").append(i).append(" is null").toString());
                    System.out.println(new StringBuffer().append("QQQ nullArgSet: ").append(nullArgSet).toString());
                    System.out.println(new StringBuffer().append("QQQ dnullArgSet: ").append(definitelyNullArgSet).toString());
                }
                BugAnnotation variableAnnotation = null;
                try {
                    ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
                    ValueNumber valueNumber = (ValueNumber)vnaFrame.getArgument(invokeInstruction, cpg, i, sigParser);
                    variableAnnotation = NullDerefAndRedundantComparisonFinder.findAnnotationFromValueNumber((Method)this.method, (Location)location, (ValueNumber)valueNumber, (ValueNumberFrame)vnaFrame);
                }
                catch (DataflowAnalysisException e) {
                    AnalysisContext.logError((String)"error", (Exception)((Object)e));
                }
                catch (CFGBuilderException e) {
                    AnalysisContext.logError((String)"error", (Exception)((Object)e));
                }
                int n = priority = definitelyNull ? 1 : 2;
                if (caught) {
                    ++priority;
                }
                String description = definitelyNull ? "INT_NULL_ARG" : "INT_MAYBE_NULL_ARG";
                BugInstance warning = new BugInstance((Detector)this, "NP_NONNULL_PARAM_VIOLATION", priority).addClassAndMethod(this.classContext.getJavaClass(), this.method).addMethod(m).describe("METHOD_CALLED").addInt(i + 1).describe(description).addOptionalAnnotation(variableAnnotation).addSourceLine(this.classContext, this.method, location);
                this.bugReporter.reportBug(warning);
            }
            i = nullArgSet.nextSetBit(i + 1);
        }
    }

    public void report() {
    }

    public boolean skipIfInsideCatchNull() {
        return this.classContext.getJavaClass().getClassName().indexOf("Test") >= 0 || this.method.getName().indexOf("test") >= 0 || this.method.getName().indexOf("Test") >= 0;
    }

    public void foundNullDeref(ClassContext classContext, Location location, ValueNumber valueNumber, IsNullValue refValue, ValueNumberFrame vnaFrame) {
        WarningPropertySet propertySet = new WarningPropertySet();
        if (valueNumber.hasFlag(4)) {
            return;
        }
        boolean onExceptionPath = refValue.isException();
        if (onExceptionPath) {
            propertySet.addProperty((WarningProperty)GeneralWarningProperty.ON_EXCEPTION_PATH);
        }
        int pc = location.getHandle().getPosition();
        BugAnnotation variable = NullDerefAndRedundantComparisonFinder.findAnnotationFromValueNumber((Method)this.method, (Location)location, (ValueNumber)valueNumber, (ValueNumberFrame)vnaFrame);
        boolean duplicated = false;
        try {
            CFG cfg = classContext.getCFG(this.method);
            duplicated = cfg.getLocationsContainingInstructionWithOffset(pc).size() > 1;
        }
        catch (CFGBuilderException e) {
            // empty catch block
        }
        boolean caught = this.inCatchNullBlock(location);
        if (caught && this.skipIfInsideCatchNull()) {
            return;
        }
        if (!duplicated && refValue.isDefinitelyNull()) {
            int priority;
            String type = onExceptionPath ? "NP_ALWAYS_NULL_EXCEPTION" : "NP_ALWAYS_NULL";
            int n = priority = onExceptionPath ? 2 : 1;
            if (caught) {
                ++priority;
            }
            this.reportNullDeref(propertySet, classContext, this.method, location, type, priority, variable);
        } else if (refValue.mightBeNull() && refValue.isParamValue()) {
            String type;
            int priority = 2;
            if (caught) {
                ++priority;
            }
            if (this.method.getName().equals("equals") && this.method.getSignature().equals("(Ljava/lang/Object;)Z")) {
                if (caught) {
                    return;
                }
                type = "NP_EQUALS_SHOULD_HANDLE_NULL_ARGUMENT";
            } else {
                type = "NP_ARGUMENT_MIGHT_BE_NULL";
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Reporting null on some path: value=").append(refValue).toString());
            }
            this.reportNullDeref(propertySet, classContext, this.method, location, type, priority, variable);
        }
    }

    private void reportNullDeref(WarningPropertySet propertySet, ClassContext classContext, Method method, Location location, String type, int priority, BugAnnotation variable) {
        BugInstance bugInstance = new BugInstance((Detector)this, type, priority).addClassAndMethod(classContext.getJavaClass(), method);
        if (variable != null) {
            bugInstance.add(variable);
        } else {
            bugInstance.add((BugAnnotation)new LocalVariableAnnotation("?", -1, -1));
        }
        bugInstance.addSourceLine(classContext, method, location).describe("SOURCE_LINE_DEREF");
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)classContext, (Method)method, (Location)location);
        }
        if (this.isDoomed(location)) {
            propertySet.addProperty((WarningProperty)DoomedCodeWarningProperty.DOOMED_CODE);
        }
        propertySet.decorateBugInstance(bugInstance);
        this.bugReporter.reportBug(bugInstance);
    }

    public static boolean isThrower(BasicBlock target) {
        int maxCount = 7;
        for (InstructionHandle ins = target.getFirstInstruction(); ins != null && maxCount-- > 0; ins = ins.getNext()) {
            Instruction i = ins.getInstruction();
            if (i instanceof ATHROW) {
                return true;
            }
            if (!(i instanceof InstructionTargeter) && !(i instanceof ReturnInstruction)) continue;
            return false;
        }
        return false;
    }

    public void foundRedundantNullCheck(Location location, RedundantBranch redundantBranch) {
        int priority;
        String warning;
        boolean isChecked = redundantBranch.firstValue.isChecked();
        boolean wouldHaveBeenAKaboom = redundantBranch.firstValue.wouldHaveBeenAKaboom();
        Location locationOfKaBoom = redundantBranch.firstValue.getLocationOfKaBoom();
        boolean createdDeadCode = false;
        boolean infeasibleEdgeSimplyThrowsException = false;
        Edge infeasibleEdge = redundantBranch.infeasibleEdge;
        if (infeasibleEdge != null) {
            boolean empty;
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Check if ").append(redundantBranch).append(" creates dead code").toString());
            }
            BasicBlock target = (BasicBlock)infeasibleEdge.getTarget();
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Target block is  ").append(target.isExceptionThrower() ? " exception thrower" : " not exception thrower").toString());
            }
            boolean bl = empty = !target.isExceptionThrower() && (target.isEmpty() || this.isGoto(target.getFirstInstruction().getInstruction()));
            if (!empty) {
                try {
                    if (this.classContext.getCFG(this.method).getNumIncomingEdges((AbstractVertex)target) > 1) {
                        if (DEBUG) {
                            System.out.println("Target of infeasible edge has multiple incoming edges");
                        }
                        empty = true;
                    }
                }
                catch (CFGBuilderException e) {
                    // empty catch block
                }
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Target block is  ").append(empty ? "empty" : "not empty").toString());
            }
            if (!empty && FindNullDeref.isThrower(target)) {
                infeasibleEdgeSimplyThrowsException = true;
            }
            if (!empty && !this.previouslyDeadBlocks.get(target.getId())) {
                if (DEBUG) {
                    System.out.println("target was alive previously");
                }
                IsNullValueFrame invFrame = (IsNullValueFrame)this.invDataflow.getStartFact(target);
                createdDeadCode = invFrame.isTop();
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("target is now ").append(createdDeadCode ? "dead" : "alive").toString());
                }
            }
        }
        boolean valueIsNull = true;
        if (redundantBranch.secondValue == null) {
            if (redundantBranch.firstValue.isDefinitelyNull()) {
                warning = "RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE";
                priority = 2;
            } else {
                warning = "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE";
                valueIsNull = false;
                priority = isChecked ? 2 : 3;
            }
        } else {
            boolean bothNull;
            boolean bl = bothNull = redundantBranch.firstValue.isDefinitelyNull() && redundantBranch.secondValue.isDefinitelyNull();
            if (redundantBranch.secondValue.isChecked()) {
                isChecked = true;
            }
            if (redundantBranch.secondValue.wouldHaveBeenAKaboom()) {
                wouldHaveBeenAKaboom = true;
                locationOfKaBoom = redundantBranch.secondValue.getLocationOfKaBoom();
            }
            if (bothNull) {
                warning = "RCN_REDUNDANT_COMPARISON_TWO_NULL_VALUES";
                priority = 2;
            } else {
                warning = "RCN_REDUNDANT_COMPARISON_OF_NULL_AND_NONNULL_VALUE";
                int n = priority = isChecked ? 2 : 3;
            }
        }
        if (wouldHaveBeenAKaboom) {
            priority = 1;
            warning = "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE";
            if (locationOfKaBoom == null) {
                throw new NullPointerException("location of KaBoom is null");
            }
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append(createdDeadCode).append(" ").append(infeasibleEdgeSimplyThrowsException).append(" ").append(valueIsNull).append(" ").append(priority).toString());
        }
        priority = createdDeadCode && !infeasibleEdgeSimplyThrowsException ? (priority += 0) : (createdDeadCode && infeasibleEdgeSimplyThrowsException ? (valueIsNull ? (priority += 0) : ++priority) : ++priority);
        if (DEBUG) {
            System.out.println(new StringBuffer().append("RCN").append(priority).append(" ").append(redundantBranch.firstValue).append(" =? ").append(redundantBranch.secondValue).append(" : ").append(warning).toString());
            if (isChecked) {
                System.out.println("isChecked");
            }
            if (wouldHaveBeenAKaboom) {
                System.out.println("wouldHaveBeenAKaboom");
            }
            if (createdDeadCode) {
                System.out.println("createdDeadCode");
            }
        }
        if (priority > 3) {
            return;
        }
        BugAnnotation variableAnnotation = null;
        try {
            ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
            if (vnaFrame.isValid()) {
                Instruction ins = location.getHandle().getInstruction();
                ValueNumber valueNumber = (ValueNumber)vnaFrame.getInstance(ins, this.classContext.getConstantPoolGen());
                if (valueNumber.hasFlag(4)) {
                    return;
                }
                variableAnnotation = NullDerefAndRedundantComparisonFinder.findAnnotationFromValueNumber((Method)this.method, (Location)location, (ValueNumber)valueNumber, (ValueNumberFrame)vnaFrame);
            }
        }
        catch (DataflowAnalysisException e) {
        }
        catch (CFGBuilderException e) {
            // empty catch block
        }
        BugInstance bugInstance = new BugInstance((Detector)this, warning, priority).addClassAndMethod(this.classContext.getJavaClass(), this.method);
        if (variableAnnotation != null) {
            bugInstance.add(variableAnnotation);
        } else {
            bugInstance.add((BugAnnotation)new LocalVariableAnnotation("?", -1, -1));
        }
        if (wouldHaveBeenAKaboom) {
            bugInstance.addSourceLine(this.classContext, this.method, locationOfKaBoom);
        }
        bugInstance.addSourceLine(this.classContext, this.method, location).describe("SOURCE_REDUNDANT_NULL_CHECK");
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertySet propertySet = new WarningPropertySet();
            WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)this.classContext, (Method)this.method, (Location)location);
            if (isChecked) {
                propertySet.addProperty((WarningProperty)NullDerefProperty.CHECKED_VALUE);
            }
            if (wouldHaveBeenAKaboom) {
                propertySet.addProperty((WarningProperty)NullDerefProperty.WOULD_HAVE_BEEN_A_KABOOM);
            }
            if (createdDeadCode) {
                propertySet.addProperty((WarningProperty)NullDerefProperty.CREATED_DEAD_CODE);
            }
            propertySet.decorateBugInstance(bugInstance);
            priority = propertySet.computePriority(2);
            bugInstance.setPriority(priority);
        }
        this.bugReporter.reportBug(bugInstance);
    }

    BugAnnotation getVariableAnnotation(Location location) {
        BugAnnotation variableAnnotation = null;
        try {
            ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
            if (vnaFrame.isValid()) {
                Instruction ins = location.getHandle().getInstruction();
                ValueNumber valueNumber = (ValueNumber)vnaFrame.getInstance(ins, this.classContext.getConstantPoolGen());
                if (valueNumber.hasFlag(4)) {
                    return null;
                }
                variableAnnotation = NullDerefAndRedundantComparisonFinder.findAnnotationFromValueNumber((Method)this.method, (Location)location, (ValueNumber)valueNumber, (ValueNumberFrame)vnaFrame);
            }
        }
        catch (DataflowAnalysisException e) {
        }
        catch (CFGBuilderException cFGBuilderException) {
            // empty catch block
        }
        return variableAnnotation;
    }

    private boolean isGoto(Instruction instruction) {
        return instruction.getOpcode() == 167 || instruction.getOpcode() == 200;
    }

    public void foundGuaranteedNullDeref(@NonNull Set<Location> assignedNullLocationSet, @NonNull Set<Location> derefLocationSet, SortedSet<Location> doomedLocations, ValueNumberDataflow vna, ValueNumber refValue, BugAnnotation variableAnnotation, NullValueUnconditionalDeref deref, boolean npeIfStatementCovered) {
        if (refValue.hasFlag(4)) {
            return;
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Found guaranteed null deref in ").append(this.method.getName()).toString());
            for (Location loc : doomedLocations) {
                System.out.println(new StringBuffer().append("Doomed at ").append(loc).toString());
            }
        }
        String bugType = "NP_GUARANTEED_DEREF";
        int priority = 2;
        if (deref.isMethodReturnValue()) {
            bugType = "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE";
        } else {
            if (deref.isAlwaysOnExceptionPath()) {
                bugType = new StringBuffer().append(bugType).append("_ON_EXCEPTION_PATH").toString();
            } else {
                priority = 1;
            }
            if (!npeIfStatementCovered) {
                ++priority;
            }
        }
        SortedSet<Location> sourceLocations = doomedLocations.isEmpty() || doomedLocations.size() > 3 && doomedLocations.size() > assignedNullLocationSet.size() ? new TreeSet<Location>(assignedNullLocationSet) : doomedLocations;
        if (doomedLocations.isEmpty() || derefLocationSet.isEmpty()) {
            return;
        }
        boolean derefOutsideCatchBlock = false;
        for (Location loc : derefLocationSet) {
            if (this.inCatchNullBlock(loc)) continue;
            derefOutsideCatchBlock = true;
            break;
        }
        boolean uniqueDereferenceLocations = false;
        LineNumberTable table = this.method.getLineNumberTable();
        if (table == null) {
            uniqueDereferenceLocations = true;
        } else {
            BitSet linesMentionedMultipleTimes = ClassContext.linesMentionedMultipleTimes((Method)this.method);
            for (Location loc : derefLocationSet) {
                int lineNumber = table.getSourceLine(loc.getHandle().getPosition());
                if (linesMentionedMultipleTimes.get(lineNumber)) continue;
                uniqueDereferenceLocations = true;
            }
        }
        if (!derefOutsideCatchBlock) {
            if (!uniqueDereferenceLocations || this.skipIfInsideCatchNull()) {
                return;
            }
            ++priority;
        }
        if (!uniqueDereferenceLocations) {
            ++priority;
        }
        BitSet knownNull = new BitSet();
        TreeSet<SourceLineAnnotation> knownNullLocations = new TreeSet<SourceLineAnnotation>();
        for (Location loc : sourceLocations) {
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)this.classContext, (Method)this.method, (Location)loc);
            if (sourceLineAnnotation == null) continue;
            int startLine = sourceLineAnnotation.getStartLine();
            if (startLine == -1) {
                knownNullLocations.add(sourceLineAnnotation);
                continue;
            }
            if (knownNull.get(startLine)) continue;
            knownNull.set(startLine);
            knownNullLocations.add(sourceLineAnnotation);
        }
        FieldAnnotation storedField = null;
        MethodAnnotation invokedMethod = null;
        int parameterNumber = -1;
        if (derefLocationSet.size() == 1) {
            Location loc = derefLocationSet.iterator().next();
            PointerUsageRequiringNonNullValue pu = null;
            try {
                UsagesRequiringNonNullValues usages = this.classContext.getUsagesRequiringNonNullValues(this.method);
                pu = usages.get(loc, refValue);
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError((String)new StringBuffer().append("Error getting UsagesRequiringNonNullValues for ").append(this.method).toString(), (Exception)((Object)e));
            }
            catch (CFGBuilderException e) {
                AnalysisContext.logError((String)new StringBuffer().append("Error getting UsagesRequiringNonNullValues for ").append(this.method).toString(), (Exception)((Object)e));
            }
            if (pu != null) {
                if (pu.getReturnFromNonNullMethod()) {
                    bugType = "NP_NONNULL_RETURN_VIOLATION";
                    String methodName = this.method.getName();
                    String methodSig = this.method.getSignature();
                    if (methodName.equals("clone") && methodSig.equals("()Ljava/lang/Object;")) {
                        bugType = "NP_CLONE_COULD_RETURN_NULL";
                        priority = 2;
                    } else if (methodName.equals("toString") && methodSig.equals("()Ljava/lang/String;")) {
                        bugType = "NP_TOSTRING_COULD_RETURN_NULL";
                        priority = 2;
                    }
                } else {
                    XField nonNullField = pu.getNonNullField();
                    if (nonNullField != null) {
                        storedField = FieldAnnotation.fromXField((XField)nonNullField);
                        bugType = "NP_STORE_INTO_NONNULL_FIELD";
                    } else {
                        XMethodParameter nonNullParameter = pu.getNonNullParameter();
                        if (nonNullParameter != null) {
                            XMethodParameter mp = nonNullParameter;
                            invokedMethod = MethodAnnotation.fromXMethod((XMethod)mp.getMethod());
                            parameterNumber = mp.getParameterNumber();
                            bugType = "NP_NULL_PARAM_DEREF";
                        }
                    }
                }
            } else {
                bugType = !deref.isAlwaysOnExceptionPath() ? "NP_NULL_ON_SOME_PATH" : "NP_NULL_ON_SOME_PATH_EXCEPTION";
            }
            if (deref.isMethodReturnValue()) {
                bugType = "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE";
            }
        }
        BugInstance bugInstance = new BugInstance((Detector)this, bugType, priority).addClassAndMethod(this.classContext.getJavaClass(), this.method);
        if (invokedMethod != null) {
            bugInstance.addMethod(invokedMethod).describe("METHOD_CALLED").addInt(parameterNumber + 1).describe("INT_MAYBE_NULL_ARG");
        }
        if (storedField != null) {
            bugInstance.addField(storedField).describe("FIELD_STORED");
        }
        bugInstance.add(variableAnnotation);
        if (variableAnnotation instanceof FieldAnnotation) {
            bugInstance.describe("FIELD_CONTAINS_VALUE");
        }
        for (Location loc : derefLocationSet) {
            bugInstance.addSourceLine(this.classContext, this.method, loc).describe(this.getDescription(loc, refValue));
        }
        for (SourceLineAnnotation sourceLineAnnotation : knownNullLocations) {
            bugInstance.add((BugAnnotation)sourceLineAnnotation).describe("SOURCE_LINE_KNOWN_NULL");
        }
        boolean allDerefsAtDoomedLocations = true;
        for (Location derefLoc : derefLocationSet) {
            if (this.isDoomed(derefLoc)) continue;
            allDerefsAtDoomedLocations = false;
            break;
        }
        if (allDerefsAtDoomedLocations) {
            WarningPropertySet propertySet = new WarningPropertySet();
            propertySet.addProperty((WarningProperty)DoomedCodeWarningProperty.DOOMED_CODE);
            propertySet.decorateBugInstance(bugInstance);
        }
        this.bugReporter.reportBug(bugInstance);
    }

    private boolean isDoomed(Location loc) {
        if (!MARK_DOOMED) {
            return false;
        }
        try {
            ReturnPathTypeDataflow rptDataflow = this.classContext.getReturnPathTypeDataflow(this.method);
            ReturnPathType rpt = rptDataflow.getFactAtLocation(loc);
            return !rpt.canReturnNormally();
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError((String)"Error getting return path type", (Exception)((Object)e));
            return false;
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError((String)"Error getting return path type", (Exception)((Object)e));
            return false;
        }
    }

    String getDescription(Location loc, ValueNumber refValue) {
        try {
            UsagesRequiringNonNullValues usages = this.classContext.getUsagesRequiringNonNullValues(this.method);
            PointerUsageRequiringNonNullValue pu = usages.get(loc, refValue);
            if (pu == null) {
                return "SOURCE_LINE_DEREF";
            }
            return pu.getDescription();
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError((String)new StringBuffer().append("Error getting UsagesRequiringNonNullValues for ").append(this.method).toString(), (Exception)((Object)e));
            return "SOURCE_LINE_DEREF";
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError((String)new StringBuffer().append("Error getting UsagesRequiringNonNullValues for ").append(this.method).toString(), (Exception)((Object)e));
            return "SOURCE_LINE_DEREF";
        }
    }

    boolean inCatchNullBlock(Location loc) {
        int pc = loc.getHandle().getPosition();
        int catchSize = Util.getSizeOfSurroundingTryBlock((ConstantPool)this.classContext.getConstantPoolGen().getConstantPool(), (Code)this.method.getCode(), (String)"java/lang/NullPointerException", (int)pc);
        if (catchSize < Integer.MAX_VALUE) {
            return true;
        }
        catchSize = Util.getSizeOfSurroundingTryBlock((ConstantPool)this.classContext.getConstantPoolGen().getConstantPool(), (Code)this.method.getCode(), (String)"java/lang/Exception", (int)pc);
        if (catchSize < 5) {
            return true;
        }
        catchSize = Util.getSizeOfSurroundingTryBlock((ConstantPool)this.classContext.getConstantPoolGen().getConstantPool(), (Code)this.method.getCode(), (String)"java/lang/RuntimeException", (int)pc);
        if (catchSize < 5) {
            return true;
        }
        catchSize = Util.getSizeOfSurroundingTryBlock((ConstantPool)this.classContext.getConstantPoolGen().getConstantPool(), (Code)this.method.getCode(), (String)"java/lang/Throwable", (int)pc);
        return catchSize < 5;
    }
}

