/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.launcher;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.launching.InterpreterRunnerConfiguration;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.util.RubyFileSelector;
import org.rubypeople.rdt.internal.ui.util.RubyProjectSelector;
import org.rubypeople.rdt.testunit.TestunitPlugin;
import org.rubypeople.rdt.testunit.launcher.RubyClassSelector;
import org.rubypeople.rdt.testunit.launcher.TestSearchEngine;
import org.rubypeople.rdt.testunit.views.TestUnitMessages;

public class TestUnitMainTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab {
    protected RubyProjectSelector projectSelector;
    protected RubyFileSelector fileSelector;
    private RubyClassSelector classSelector;
    protected ElementListSelectionDialog dialog;
    protected String lastProject = "";
    protected String lastFile = "";
    private Label classLabel;
    private Button allClassesCheckBox;
    private Button allMethodsCheckBox;
    private Label testLabel;
    private Text testMethodEditBox;

    public void createControl(Composite composite) {
        Composite composite2 = this.createPageRoot(composite);
        new Label(composite2, 0).setText(RdtDebugUiMessages.getString((String)"LaunchConfigurationTab.RubyEntryPoint.projectLabel"));
        this.projectSelector = new RubyProjectSelector(composite2);
        this.projectSelector.setBrowseDialogMessage(RdtDebugUiMessages.getString((String)"LaunchConfigurationTab.RubyEntryPoint.projectSelectorMessage"));
        this.projectSelector.setLayoutData((Object)new GridData(768));
        this.projectSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TestUnitMainTab.this.updateLaunchConfigurationDialog();
                String string = TestUnitMainTab.this.projectSelector.getSelectionText();
                if (!string.equals(TestUnitMainTab.this.lastProject)) {
                    TestUnitMainTab.this.fileSelector.setSelectionText("");
                    TestUnitMainTab.this.classSelector.setSelectionText("");
                }
                TestUnitMainTab.this.lastProject = string;
            }
        });
        new Label(composite2, 0).setText(RdtDebugUiMessages.getString((String)"LaunchConfigurationTab.RubyEntryPoint.fileLabel"));
        this.fileSelector = new RubyFileSelector(composite2, this.projectSelector);
        this.fileSelector.setBrowseDialogMessage(RdtDebugUiMessages.getString((String)"LaunchConfigurationTab.RubyEntryPoint.fileSelectorMessage"));
        this.fileSelector.setLayoutData((Object)new GridData(768));
        this.fileSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TestUnitMainTab.this.updateLaunchConfigurationDialog();
                String string = TestUnitMainTab.this.fileSelector.getSelectionText();
                if (!string.equals(TestUnitMainTab.this.lastFile)) {
                    TestUnitMainTab.this.classSelector.setSelectionText("");
                }
                TestUnitMainTab.this.lastFile = string;
            }
        });
        this.allClassesCheckBox = new Button(composite2, 32);
        this.allClassesCheckBox.setText(TestUnitMessages.getString("LaunchConfigurationTab.RubyEntryPoint.allTestCases"));
        this.allClassesCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TestUnitMainTab.this.updateLaunchConfigurationDialog();
                TestUnitMainTab.this.setControlState();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.classLabel = new Label(composite2, 0);
        this.classLabel.setText(TestUnitMessages.getString("LaunchConfigurationTab.RubyEntryPoint.classLabel"));
        this.classSelector = new RubyClassSelector(composite2, this.fileSelector, this.projectSelector);
        this.classSelector.setBrowseDialogMessage(TestUnitMessages.getString("LaunchConfigurationTab.RubyEntryPoint.classSelectorMessage"));
        this.classSelector.setLayoutData(new GridData(768));
        this.classSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TestUnitMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.allMethodsCheckBox = new Button(composite2, 32);
        this.allMethodsCheckBox.setText(TestUnitMessages.getString("LaunchConfigurationTab.RubyEntryPoint.allTestMethods"));
        this.allMethodsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TestUnitMainTab.this.updateLaunchConfigurationDialog();
                TestUnitMainTab.this.setControlState();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.testLabel = new Label(composite2, 0);
        this.testLabel.setText(TestUnitMessages.getString("LaunchConfigurationTab.RubyEntryPoint.methodLabel"));
        this.testMethodEditBox = new Text(composite2, 2048);
        this.testMethodEditBox.setLayoutData((Object)new GridData(768));
        this.testMethodEditBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TestUnitMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.setControlState();
    }

    private void setControlState() {
        boolean bl = this.allClassesCheckBox.getSelection();
        boolean bl2 = this.allMethodsCheckBox.getSelection();
        this.classLabel.setEnabled(!bl);
        this.classSelector.setEnabled(!bl);
        this.allMethodsCheckBox.setEnabled(!bl);
        this.testLabel.setEnabled(!bl && !bl2);
        this.testMethodEditBox.setEnabled(!bl && !bl2);
    }

    protected Composite createPageRoot(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 10;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.setControl((Control)composite2);
        return composite2;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IResource iResource = RubyPlugin.getDefault().getSelectedResource();
        String string = "";
        String string2 = "";
        String string3 = "";
        if (RubyPlugin.getDefault().isRubyFile(iResource)) {
            string = iResource.getProject().getName();
            string2 = iResource.getProjectRelativePath().toString();
            IRubyElement[] iRubyElementArray = TestSearchEngine.findTests((IFile)iResource);
            if (iRubyElementArray.length > 0) {
                string3 = iRubyElementArray[0].getElementName();
            }
        }
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.PROJECT_NAME", string);
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.testunit.CONTAINER", string2);
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.testunit.TESTTYPE", string3);
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.testunit.TESTNAME", "");
        iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "org.rubypeople.rdt.debug.ui.rubySourceLocator");
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            InterpreterRunnerConfiguration interpreterRunnerConfiguration = new InterpreterRunnerConfiguration(iLaunchConfiguration);
            String string = "";
            IProject iProject = interpreterRunnerConfiguration.getProject().getProject();
            if (iProject != null) {
                string = iProject.getName();
            }
            this.projectSelector.setSelectionText(string);
            this.fileSelector.setSelectionText(iLaunchConfiguration.getAttribute("org.rubypeople.rdt.testunit.CONTAINER", ""));
            String string2 = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.testunit.TESTTYPE", "");
            this.classSelector.setSelectionText(string2);
            if (string2.length() == 0) {
                this.allClassesCheckBox.setSelection(true);
            } else {
                String string3 = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.testunit.TESTNAME", "");
                this.testMethodEditBox.setText(string3);
                if (string3.length() == 0) {
                    this.allMethodsCheckBox.setSelection(true);
                }
            }
            this.setControlState();
        }
        catch (CoreException coreException) {
            TestunitPlugin.log(coreException);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = this.testMethodEditBox.getText();
        if (this.allMethodsCheckBox.getSelection()) {
            string = "";
        }
        String string2 = this.classSelector.getValidatedSelectionText();
        if (this.allClassesCheckBox.getSelection()) {
            string2 = "";
            string = "";
        }
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.testunit.TESTNAME", string);
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.testunit.TESTTYPE", string2);
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.testunit.CONTAINER", this.fileSelector.getValidatedSelectionText());
    }

    public String getName() {
        return TestUnitMessages.getString("JUnitMainTab.tab.label");
    }
}

