/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.internal.ui.util.ResourceSelector;

public class RubyProjectSelector
extends ResourceSelector {
    public RubyProjectSelector(Composite composite) {
        super(composite);
        this.browseDialogTitle = "Project Selection";
    }

    public IProject getSelection() {
        String string = this.getSelectionText();
        if (string != null && !string.equals("")) {
            return RubyPlugin.getWorkspace().getRoot().getProject(string);
        }
        return null;
    }

    protected void handleBrowseSelected() {
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
        elementListSelectionDialog.setTitle(this.browseDialogTitle);
        elementListSelectionDialog.setMessage(this.browseDialogMessage);
        elementListSelectionDialog.setElements(RubyCore.getRubyProjects());
        if (elementListSelectionDialog.open() == 0) {
            this.textField.setText(((IProject)elementListSelectionDialog.getFirstResult()).getName());
        }
    }

    protected String validateResourceSelection() {
        IProject iProject = this.getSelection();
        return iProject == null ? "" : iProject.getName();
    }
}

