/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.dialogs.RevertDialog;
import org.tigris.subversion.subclipse.ui.operations.RevertOperation;

public class RevertAction
extends WorkbenchWindowAction {
    private String url;
    private IResource[] resourcesToRevert;

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IResource[] resources = this.getSelectedResources();
        try {
            IResource[] modifiedResources = this.getModifiedResources(resources, (IProgressMonitor)new NullProgressMonitor());
            if (!this.confirmRevert(modifiedResources)) {
                return;
            }
            new RevertOperation(this.getTargetPart(), this.resourcesToRevert).run();
        }
        catch (SVNException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected IResource[] getModifiedResources(IResource[] resources, IProgressMonitor iProgressMonitor) throws SVNException {
        if (resources.length == 1) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[0]);
            this.url = svnResource.getStatus().getUrlString();
            if (this.url == null || resources[0].getType() == 1) {
                this.url = Util.getParentUrl((ISVNLocalResource)svnResource);
            }
        }
        return super.getModifiedResources(resources, iProgressMonitor);
    }

    protected boolean confirmRevert(IResource[] modifiedResources) {
        if (modifiedResources.length == 0) {
            return false;
        }
        RevertDialog dialog = new RevertDialog(this.getShell(), modifiedResources, this.url);
        boolean revert = dialog.open() == 0;
        this.url = null;
        this.resourcesToRevert = dialog.getSelectedResources();
        return revert;
    }

    protected String getErrorTitle() {
        return Policy.bind("RevertAction.error");
    }

    protected boolean isEnabledForManagedResources() {
        return true;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_remove_unadded_resources_on_replace");
    }

    protected boolean isEnabledForInaccessibleResources() {
        return true;
    }

    protected String getImageId() {
        return "Menu Revert";
    }
}

