/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.authentication;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.authentication.KeyFileHistoryContentHandler;
import org.tigris.subversion.subclipse.ui.internal.XMLWriter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KeyFilesManager {
    static String[] previousKeyFiles = new String[0];
    static final int MAX_FILES = 5;
    private static final String KEYFILE_HIST_FILE = "keyFileHistory.xml";
    static final String ELEMENT_KEYFILE = "KeyFile";
    static final String ELEMENT_KEYFILE_HISTORY = "KeyFiles";

    public String[] getPreviousKeyFiles() {
        return previousKeyFiles;
    }

    public void addKeyFile(String keyFile) {
        if (previousKeyFiles.length > 0 && previousKeyFiles[0].equals(keyFile)) {
            return;
        }
        String[] newKeyFiles = new String[Math.min(previousKeyFiles.length + 1, 5)];
        newKeyFiles[0] = keyFile;
        int i = 1;
        while (i < newKeyFiles.length) {
            newKeyFiles[i] = previousKeyFiles[i - 1];
            ++i;
        }
        previousKeyFiles = newKeyFiles;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadKeyFileHistory() {
        IPath pluginStateLocation = SVNUIPlugin.getPlugin().getStateLocation().append(KEYFILE_HIST_FILE);
        File file = pluginStateLocation.toFile();
        if (!file.exists()) {
            return;
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                try {
                    SAXParser parser = factory.newSAXParser();
                    parser.parse(new InputSource(is), (DefaultHandler)new KeyFileHistoryContentHandler());
                }
                catch (SAXException ex) {
                    throw new SVNException(Policy.bind("RepositoryManager.parsingProblem", KEYFILE_HIST_FILE), (Throwable)ex);
                }
                catch (ParserConfigurationException e) {
                    throw new SVNException(Policy.bind("RepositoryManager.parsingProblem", KEYFILE_HIST_FILE), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                is.close();
                throw throwable;
            }
            {
                Object var6_12 = null;
                is.close();
                return;
            }
        }
        catch (IOException e) {
            SVNUIPlugin.log((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, Policy.bind("RepositoryManager.ioException"), (Throwable)e));
            return;
        }
        catch (TeamException e) {
            SVNUIPlugin.log(e.getStatus());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveKeyFilesHistory() throws TeamException {
        IPath pluginStateLocation = SVNUIPlugin.getPlugin().getStateLocation();
        File tempFile = pluginStateLocation.append("keyFileHistory.xml.tmp").toFile();
        File histFile = pluginStateLocation.append(KEYFILE_HIST_FILE).toFile();
        try {
            boolean renamed;
            XMLWriter writer = new XMLWriter(new BufferedOutputStream(new FileOutputStream(tempFile)));
            try {
                writer.startTag(ELEMENT_KEYFILE_HISTORY, null, false);
                int i = 0;
                while (true) {
                    block7: {
                        if (i < previousKeyFiles.length && i < 5) break block7;
                        writer.endTag(ELEMENT_KEYFILE_HISTORY);
                        break;
                    }
                    writer.printSimpleTag(ELEMENT_KEYFILE, previousKeyFiles[i]);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                writer.close();
                throw throwable;
            }
            {
                Object var6_9 = null;
            }
            writer.close();
            if (histFile.exists()) {
                histFile.delete();
            }
            if (renamed = tempFile.renameTo(histFile)) return;
            throw new TeamException((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, Policy.bind("RepositoryManager.rename", tempFile.getAbsolutePath()), null));
        }
        catch (IOException e) {
            throw new TeamException((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, Policy.bind("RepositoryManager.save", histFile.getAbsolutePath()), (Throwable)e));
        }
    }
}

