/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.generatediff;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.GetStatusCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.DiffNewFilesDialog;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class GenerateDiffFileOperation
implements IRunnableWithProgress {
    private File outputFile;
    private IResource resource;
    private Shell shell;
    private boolean recursive;
    private boolean toClipboard;

    GenerateDiffFileOperation(IResource resource, File file, boolean toClipboard, boolean recursive, Shell shell) {
        this.resource = resource;
        this.outputFile = file;
        this.shell = shell;
        this.recursive = recursive;
        this.toClipboard = toClipboard;
    }

    protected Hashtable getProviderMapping(IResource[] resources) {
        Hashtable<RepositoryProvider, ArrayList<IResource>> result = new Hashtable<RepositoryProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resources[i].getProject());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                Object var12_19;
                monitor.beginTask("", 500);
                monitor.setTaskName(Policy.bind("GenerateSVNDiff.working"));
                OutputStream os = this.toClipboard ? new ByteArrayOutputStream() : new FileOutputStream(this.outputFile);
                File tmpFile = File.createTempFile("sub", "");
                tmpFile.deleteOnExit();
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
                GetStatusCommand command = new GetStatusCommand(svnResource, true, false);
                command.run(monitor);
                ISVNStatus[] statuses = command.getStatuses();
                final ArrayList<IResource> newFiles = new ArrayList<IResource>(statuses.length / 4);
                int j = 0;
                while (true) {
                    IResource currentResource;
                    if (j >= statuses.length) {
                        if (newFiles.size() <= 0) break;
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                boolean revert;
                                DiffNewFilesDialog dialog = new DiffNewFilesDialog(GenerateDiffFileOperation.this.shell, newFiles.toArray(new IResource[newFiles.size()]));
                                newFiles.clear();
                                boolean bl = revert = dialog.open() == 0;
                                if (revert) {
                                    newFiles.addAll(Arrays.asList(dialog.getSelectedResources()));
                                }
                            }
                        });
                        if (newFiles.size() <= 0) break;
                        try {
                            Hashtable table = this.getProviderMapping(newFiles.toArray(new IResource[newFiles.size()]));
                            Set keySet = table.keySet();
                            Iterator iterator = keySet.iterator();
                            while (iterator.hasNext()) {
                                IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 100);
                                SVNTeamProvider provider = (SVNTeamProvider)iterator.next();
                                List list = (List)table.get(provider);
                                IResource[] providerResources = list.toArray(new IResource[list.size()]);
                                provider.add(providerResources, 2, subMonitor);
                            }
                            break;
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    if (!SVNStatusUtils.isManaged((ISVNStatus)statuses[j]) && (currentResource = SVNWorkspaceRoot.getResourceFor((ISVNStatus)statuses[j])) != null) {
                        newFiles.add(currentResource);
                    }
                    ++j;
                }
                ISVNClientAdapter svnClient = svnResource.getRepository().getSVNClient();
                try {
                    int length;
                    monitor.worked(100);
                    svnClient.diff(svnResource.getFile(), tmpFile, this.recursive);
                    monitor.worked(300);
                    FileInputStream is = new FileInputStream(tmpFile);
                    byte[] buffer = new byte[30000];
                    while ((length = ((InputStream)is).read(buffer)) != -1) {
                        os.write(buffer, 0, length);
                    }
                }
                catch (Throwable throwable) {
                    var12_19 = null;
                    os.close();
                    throw throwable;
                }
                {
                    var12_19 = null;
                }
                os.close();
                if (newFiles.size() > 0) {
                    int i = 0;
                    while (i < newFiles.size()) {
                        IResource resource = (IResource)newFiles.get(i);
                        SVNWorkspaceRoot.getSVNResourceFor((IResource)resource).revert();
                        ++i;
                    }
                }
                boolean emptyDiff = false;
                if (this.toClipboard) {
                    final ByteArrayOutputStream baos = (ByteArrayOutputStream)os;
                    if (baos.size() == 0) {
                        emptyDiff = true;
                    } else {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                                Clipboard clipboard = new Clipboard(GenerateDiffFileOperation.this.shell.getDisplay());
                                clipboard.setContents((Object[])new String[]{baos.toString()}, new Transfer[]{plainTextTransfer});
                                clipboard.dispose();
                            }
                        });
                    }
                } else if (this.outputFile.length() == 0L) {
                    emptyDiff = true;
                    this.outputFile.delete();
                }
                if (emptyDiff) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openInformation((Shell)GenerateDiffFileOperation.this.shell, (String)Policy.bind("GenerateSVNDiff.noDiffsFoundTitle"), (String)Policy.bind("GenerateSVNDiff.noDiffsFoundMsg"));
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var15_24 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var15_25 = null;
        }
        monitor.done();
    }
}

