/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.format;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.format.HTMLFormatContraintsImpl;
import org.eclipse.wst.html.core.internal.format.HTMLFormatterFactory;
import org.eclipse.wst.html.core.internal.format.HTMLTextFormatter;
import org.eclipse.wst.html.core.internal.provisional.HTMLFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.IStructuredFormatPreferencesXML;
import org.eclipse.wst.xml.core.internal.provisional.format.StructuredFormatPreferencesXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLFormatter
implements IStructuredFormatter {
    private static final String HTML_NAME = "html";
    private static final String BODY_NAME = "BODY";
    protected IStructuredFormatPreferences fFormatPreferences = null;
    protected HTMLFormatContraints fFormatContraints = null;
    protected IProgressMonitor fProgressMonitor = null;

    protected void addWidth(HTMLFormatContraints contraints, int width) {
        if (contraints == null) {
            return;
        }
        if (!this.splitLines() || this.getLineWidth() < 0) {
            return;
        }
        int availableWidth = contraints.getAvailableLineWidth() - width;
        if (availableWidth < 0) {
            availableWidth = 0;
        }
        contraints.setAvailableLineWidth(availableWidth);
    }

    protected boolean canFormatChild(Node node) {
        while (node != null) {
            if (node.getNodeType() != 1) {
                return true;
            }
            CMElementDeclaration decl = this.getElementDeclaration((Element)node);
            if (decl != null) {
                boolean shouldKeepSpace;
                if (decl.getContentType() == 5) {
                    return false;
                }
                if (decl.supports("shouldKeepSpace") && (shouldKeepSpace = ((Boolean)decl.getProperty("shouldKeepSpace")).booleanValue())) {
                    return false;
                }
            }
            node = node.getParentNode();
        }
        return false;
    }

    protected boolean canInsertBreakAfter(CMElementDeclaration decl) {
        if (decl == null) {
            return false;
        }
        if (!decl.supports("lineBreakHint")) {
            return false;
        }
        String hint = (String)decl.getProperty("lineBreakHint");
        if (hint == null) {
            return false;
        }
        return hint.equals("breakBeforeStartAndAfterEnd") || hint.equals("breakAfterStart");
    }

    protected boolean canInsertBreakAfter(Node node) {
        CMElementDeclaration decl;
        CMElementDeclaration decl2;
        IDOMElement element;
        if (node == null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        Node next = node.getNextSibling();
        if (parent.getNodeType() == 9) {
            return node.getNodeType() != 1 || ((IDOMElement)node).isClosed();
        }
        if (parent.getNodeType() == 1) {
            element = (IDOMElement)parent;
            if (next == null && element.getEndStructuredDocumentRegion() == null) {
                return false;
            }
            if (element.getPrefix() != null) {
                return true;
            }
            decl2 = this.getElementDeclaration((Element)element);
            if (decl2 != null) {
                if (decl2.getContentType() == 2) {
                    return true;
                }
                String tagName = element.getTagName();
                if (tagName != null && tagName.equalsIgnoreCase(BODY_NAME)) {
                    return true;
                }
            }
        }
        if (node.getNodeType() == 1 && this.canInsertBreakAfter(decl2 = this.getElementDeclaration((Element)(element = (IDOMElement)node)))) {
            return this.canFormatChild(parent);
        }
        return next != null && next.getNodeType() == 1 && this.canInsertBreakBefore(decl = this.getElementDeclaration((Element)next));
    }

    protected boolean canInsertBreakBefore(CMElementDeclaration decl) {
        if (decl == null) {
            return false;
        }
        if (!decl.supports("lineBreakHint")) {
            return false;
        }
        String hint = (String)decl.getProperty("lineBreakHint");
        if (hint == null) {
            return false;
        }
        return hint.equals("breakBeforeStartAndAfterEnd");
    }

    protected boolean canInsertBreakBefore(Node node) {
        CMElementDeclaration decl;
        if (node == null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        Node prev = node.getPreviousSibling();
        if (parent.getNodeType() == 9) {
            return prev != null;
        }
        if (parent.getNodeType() == 1) {
            IDOMElement element = (IDOMElement)parent;
            if (prev == null && element.getStartStructuredDocumentRegion() == null) {
                return false;
            }
            if (element.getPrefix() != null) {
                return true;
            }
            CMElementDeclaration decl2 = this.getElementDeclaration((Element)element);
            if (decl2 != null) {
                if (decl2.getContentType() == 2) {
                    return true;
                }
                String tagName = element.getTagName();
                if (tagName != null && tagName.equalsIgnoreCase(BODY_NAME)) {
                    return true;
                }
            }
        }
        if (node.getNodeType() == 1 && this.canInsertBreakBefore(decl = this.getElementDeclaration((Element)node))) {
            return true;
        }
        if (prev != null && prev.getNodeType() == 1 && this.canInsertBreakAfter(decl = this.getElementDeclaration((Element)prev))) {
            return this.canFormatChild(parent);
        }
        return false;
    }

    public void format(Node node) {
        this.format(node, this.getFormatContraints());
    }

    public void format(Node node, IStructuredFormatContraints contraints) {
        if (node instanceof IDOMNode && contraints instanceof HTMLFormatContraints) {
            this.format((IDOMNode)node, (HTMLFormatContraints)contraints);
        }
    }

    public void format(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (node.getParentNode() == null) {
            return;
        }
        this.setWidth(contraints, (Node)node);
        if (this.canInsertBreakBefore((Node)node)) {
            this.insertBreakBefore(node, contraints);
        }
        this.formatNode(node, contraints);
        if (this.canInsertBreakAfter((Node)node)) {
            this.insertBreakAfter(node, contraints);
        }
    }

    protected void formatChildNodes(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (!node.hasChildNodes()) {
            return;
        }
        node.normalize();
        boolean indent = false;
        if (contraints != null) {
            indent = contraints.getFormatWithSiblingIndent();
            contraints.setFormatWithSiblingIndent(false);
        }
        boolean insertBreak = true;
        IDOMNode child = (IDOMNode)node.getFirstChild();
        while (child != null) {
            IStructuredFormatter formatter;
            if (child.getParentNode() != node) break;
            IDOMNode next = (IDOMNode)child.getNextSibling();
            if (insertBreak && this.canInsertBreakBefore((Node)child)) {
                this.insertBreakBefore(child, contraints);
            }
            if ((formatter = HTMLFormatterFactory.getInstance().createFormatter((Node)child, this.getFormatPreferences())) != null) {
                if (formatter instanceof HTMLFormatter) {
                    HTMLFormatter htmlFormatter = (HTMLFormatter)formatter;
                    htmlFormatter.formatNode(child, contraints);
                } else {
                    formatter.format((Node)child);
                }
            }
            if (this.canInsertBreakAfter((Node)child)) {
                this.insertBreakAfter(child, contraints);
                insertBreak = false;
            } else {
                insertBreak = true;
            }
            child = next;
        }
        if (contraints != null) {
            contraints.setFormatWithSiblingIndent(indent);
        }
    }

    protected void formatNode(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (node.hasChildNodes()) {
            this.formatChildNodes(node, contraints);
        } else {
            String source;
            IStructuredDocumentRegion flatNode = node.getStartStructuredDocumentRegion();
            if (flatNode != null && (source = flatNode.getText()) != null && source.length() > 0) {
                this.setWidth(contraints, source);
            }
        }
    }

    protected String getBreakSpaces(Node node) {
        String indent;
        if (node == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String delim = ((IDOMNode)node).getModel().getStructuredDocument().getLineDelimiter();
        if (delim != null && delim.length() > 0) {
            buffer.append(delim);
        }
        if ((indent = this.getIndent()) != null && indent.length() > 0) {
            Node parent = node.getParentNode();
            while (parent != null) {
                if (parent.getNodeType() != 1) break;
                if (((IDOMNode)parent).getStartStructuredDocumentRegion() != null) {
                    IDOMElement element = (IDOMElement)parent;
                    if (element.getPrefix() != null) {
                        String localName = element.getLocalName();
                        if (localName != null && !localName.equals(HTML_NAME)) {
                            buffer.append(indent);
                        }
                    } else {
                        boolean shouldIndent;
                        CMElementDeclaration decl = this.getElementDeclaration((Element)element);
                        if (decl != null && decl.supports("shouldIndentChildSource") && (shouldIndent = ((Boolean)decl.getProperty("shouldIndentChildSource")).booleanValue())) {
                            buffer.append(indent);
                        }
                    }
                }
                parent = parent.getParentNode();
            }
        }
        return buffer.toString();
    }

    protected String getIndent() {
        return this.getFormatPreferences().getIndent();
    }

    protected int getLineWidth() {
        return this.getFormatPreferences().getLineWidth();
    }

    protected CMElementDeclaration getElementDeclaration(Element element) {
        if (element == null) {
            return null;
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            return null;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
        if (modelQuery == null) {
            return null;
        }
        return modelQuery.getCMElementDeclaration(element);
    }

    protected void insertBreakAfter(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 3) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        Node next = node.getNextSibling();
        String spaces = null;
        if (next == null) {
            spaces = this.getBreakSpaces(parent);
        } else {
            if (next.getNodeType() == 3) {
                if (contraints != null && contraints.getFormatWithSiblingIndent()) {
                    IDOMNode text = (IDOMNode)next;
                    IStructuredFormatter formatter = HTMLFormatterFactory.getInstance().createFormatter((Node)text, this.getFormatPreferences());
                    if (formatter instanceof HTMLTextFormatter) {
                        HTMLTextFormatter textFormatter = (HTMLTextFormatter)formatter;
                        textFormatter.formatText(text, contraints, HTMLTextFormatter.FORMAT_HEAD);
                    }
                }
                return;
            }
            spaces = this.getBreakSpaces((Node)node);
        }
        if (spaces == null || spaces.length() == 0) {
            return;
        }
        this.replaceSource(node.getModel(), node.getEndOffset(), 0, spaces);
        this.setWidth(contraints, spaces);
    }

    protected void insertBreakBefore(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 3) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        Node prev = node.getPreviousSibling();
        String spaces = null;
        if (prev != null && prev.getNodeType() == 3) {
            if (contraints != null && contraints.getFormatWithSiblingIndent()) {
                IDOMNode text = (IDOMNode)prev;
                IStructuredFormatter formatter = HTMLFormatterFactory.getInstance().createFormatter((Node)text, this.getFormatPreferences());
                if (formatter instanceof HTMLTextFormatter) {
                    HTMLTextFormatter textFormatter = (HTMLTextFormatter)formatter;
                    textFormatter.formatText(text, contraints, HTMLTextFormatter.FORMAT_TAIL);
                }
            }
            return;
        }
        spaces = this.getBreakSpaces((Node)node);
        if (spaces == null || spaces.length() == 0) {
            return;
        }
        this.replaceSource(node.getModel(), node.getStartOffset(), 0, spaces);
        this.setWidth(contraints, spaces);
    }

    protected boolean isWidthAvailable(HTMLFormatContraints contraints, int width) {
        if (contraints == null) {
            return true;
        }
        if (!this.splitLines() || this.getLineWidth() < 0) {
            return true;
        }
        return contraints.getAvailableLineWidth() >= width;
    }

    protected boolean keepBlankLines(HTMLFormatContraints contraints) {
        if (contraints == null) {
            return true;
        }
        return !contraints.getClearAllBlankLines();
    }

    protected void replaceSource(IStructuredDocumentRegion flatNode, int offset, int length, String source) {
        int startOffset;
        if (flatNode == null) {
            return;
        }
        IStructuredDocument structuredDocument = flatNode.getParentDocument();
        if (structuredDocument == null) {
            return;
        }
        if (source == null) {
            source = new String();
        }
        if (structuredDocument.containsReadOnly((startOffset = flatNode.getStartOffset()) + offset, length)) {
            return;
        }
        structuredDocument.replaceText((Object)structuredDocument, startOffset + offset, length, source);
    }

    protected void replaceSource(IDOMModel model, int offset, int length, String source) {
        if (model == null) {
            return;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        if (source == null) {
            source = new String();
        }
        if (structuredDocument.containsReadOnly(offset, length)) {
            return;
        }
        structuredDocument.replaceText((Object)structuredDocument, offset, length, source);
    }

    protected void setWidth(HTMLFormatContraints contraints, String source) {
        if (contraints == null) {
            return;
        }
        if (source == null) {
            return;
        }
        int length = source.length();
        if (length == 0) {
            return;
        }
        if (!this.splitLines()) {
            return;
        }
        int lineWidth = this.getLineWidth();
        if (lineWidth < 0) {
            return;
        }
        int offset = source.lastIndexOf(10);
        int offset2 = source.lastIndexOf(13);
        if (offset2 > offset) {
            offset = offset2;
        }
        if (offset >= 0) {
            ++offset;
        }
        int availableWidth = 0;
        availableWidth = offset >= 0 ? lineWidth - (length - offset) : contraints.getAvailableLineWidth() - length;
        if (availableWidth < 0) {
            availableWidth = 0;
        }
        contraints.setAvailableLineWidth(availableWidth);
    }

    protected void setWidth(HTMLFormatContraints contraints, Node node) {
        if (contraints == null) {
            return;
        }
        if (node == null) {
            return;
        }
        IStructuredDocument structuredDocument = ((IDOMNode)node).getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        if (!this.splitLines()) {
            return;
        }
        int lineWidth = this.getLineWidth();
        if (lineWidth < 0) {
            return;
        }
        int offset = ((IDOMNode)node).getStartOffset();
        int line = structuredDocument.getLineOfOffset(offset);
        int lineOffset = 0;
        try {
            lineOffset = structuredDocument.getLineOffset(line);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        if (lineOffset > offset) {
            return;
        }
        int availableWidth = lineWidth - (offset - lineOffset);
        if (availableWidth < 0) {
            availableWidth = 0;
        }
        contraints.setAvailableLineWidth(availableWidth);
    }

    protected boolean splitLines() {
        return true;
    }

    public void setFormatPreferences(IStructuredFormatPreferences formatPreferences) {
        this.fFormatPreferences = formatPreferences;
    }

    public IStructuredFormatPreferences getFormatPreferences() {
        if (this.fFormatPreferences == null) {
            this.fFormatPreferences = new StructuredFormatPreferencesXML();
            Preferences preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
            if (preferences != null) {
                this.fFormatPreferences.setLineWidth(preferences.getInt("lineWidth"));
                ((IStructuredFormatPreferencesXML)this.fFormatPreferences).setSplitMultiAttrs(preferences.getBoolean("splitMultiAttrs"));
                this.fFormatPreferences.setClearAllBlankLines(preferences.getBoolean("clearAllBlankLines"));
                char indentChar = ' ';
                String indentCharPref = preferences.getString("indentationChar");
                if ("tab".equals(indentCharPref)) {
                    indentChar = '\t';
                }
                int indentationWidth = preferences.getInt("indentationSize");
                StringBuffer indent = new StringBuffer();
                int i = 0;
                while (i < indentationWidth) {
                    indent.append(indentChar);
                    ++i;
                }
                this.fFormatPreferences.setIndent(indent.toString());
            }
        }
        return this.fFormatPreferences;
    }

    public IStructuredFormatContraints getFormatContraints() {
        if (this.fFormatContraints == null) {
            this.fFormatContraints = new HTMLFormatContraintsImpl();
            this.fFormatContraints.setAvailableLineWidth(this.getFormatPreferences().getLineWidth());
            this.fFormatContraints.setClearAllBlankLines(this.getFormatPreferences().getClearAllBlankLines());
        }
        return this.fFormatContraints;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
    }
}

