/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceViewerSynchronization;
import org.eclipse.jst.j2ee.internal.webservice.plugin.WebServicePlugin;

public class NewProjectsListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private WebServiceViewerSynchronization synchronization;
    private boolean listening = false;
    private boolean synchronizing = false;

    public NewProjectsListener(WebServiceViewerSynchronization sync) {
        this.synchronization = sync;
        if (this.synchronization.webServiceProjectsExist((IProgressMonitor)new NullProgressMonitor())) {
            this.synchronizing = true;
        }
        this.startListening();
    }

    public void dispose() {
        if (this.listening) {
            this.stopListening();
        }
        if (this.synchronizing) {
            this.synchronization.stop();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            WebServicePlugin.logError((int)0, (String)e.getMessage(), (Throwable)e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                if (delta.getKind() != 1 || !WebServiceViewerSynchronization.isInteresting((IProject)resource)) break;
                this.stopListening();
                this.synchronizing = true;
                this.synchronization.start();
            }
        }
        return false;
    }

    private void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.listening = true;
    }

    private void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.listening = false;
    }
}

