/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.provisional;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;

public abstract class AbstractNotifier
implements INodeNotifier {
    private static final int growthConstant = 3;
    private int adapterCount = 0;
    private INodeAdapter[] fAdapters;

    public synchronized void addAdapter(INodeAdapter adapter) {
        if (adapter == null) {
            return;
        }
        this.ensureCapacity(this.adapterCount + 1);
        this.fAdapters[this.adapterCount++] = adapter;
    }

    private void ensureCapacity(int needed) {
        if (this.fAdapters == null) {
            this.fAdapters = new INodeAdapter[needed + 3];
            return;
        }
        int oldLength = this.fAdapters.length;
        if (oldLength < needed) {
            INodeAdapter[] oldAdapters = this.fAdapters;
            INodeAdapter[] newAdapters = new INodeAdapter[needed + 3];
            System.arraycopy(oldAdapters, 0, newAdapters, 0, this.adapterCount);
            this.fAdapters = newAdapters;
        }
    }

    public int getAdapterCount() {
        return this.adapterCount;
    }

    public INodeAdapter getAdapterFor(Object type) {
        INodeAdapterFactory factory;
        FactoryRegistry reg;
        INodeAdapter result = this.getExistingAdapter(type);
        if (result == null && (reg = this.getFactoryRegistry()) != null && (factory = reg.getFactoryFor(type)) != null) {
            result = factory.adapt(this);
        }
        return result;
    }

    public Collection getAdapters() {
        if (this.fAdapters != null) {
            if (this.adapterCount == 0) {
                this.fAdapters = null;
                return Collections.EMPTY_LIST;
            }
            INodeAdapter[] tempAdapters = new INodeAdapter[this.adapterCount];
            System.arraycopy(this.fAdapters, 0, tempAdapters, 0, this.adapterCount);
            return Collections.unmodifiableCollection(Arrays.asList(tempAdapters));
        }
        return Collections.EMPTY_LIST;
    }

    private long getAdapterTimeCriteria() {
        String criteriaStr = Platform.getDebugOption((String)"org.eclipse.wst.sse.core/dom/adapter/notification/time/criteria");
        long criteria = -1L;
        if (criteriaStr != null) {
            try {
                criteria = Long.parseLong(criteriaStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return criteria;
    }

    public INodeAdapter getExistingAdapter(Object type) {
        INodeAdapter result = null;
        int i = 0;
        while (i < this.adapterCount) {
            INodeAdapter a = this.fAdapters[i];
            if (a.isAdapterForType(type)) {
                result = a;
                break;
            }
            ++i;
        }
        return result;
    }

    public abstract FactoryRegistry getFactoryRegistry();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this.fAdapters != null) {
            int localAdapterCount = 0;
            INodeAdapter[] localAdapters = null;
            AbstractNotifier abstractNotifier = this;
            synchronized (abstractNotifier) {
                localAdapterCount = this.adapterCount;
                localAdapters = new INodeAdapter[localAdapterCount];
                System.arraycopy(this.fAdapters, 0, localAdapters, 0, localAdapterCount);
            }
            int i = 0;
            while (i < localAdapterCount) {
                INodeAdapter a = localAdapters[i];
                if (Logger.DEBUG_ADAPTERNOTIFICATIONTIME) {
                    long getAdapterTimeCriteria = this.getAdapterTimeCriteria();
                    long startTime = System.currentTimeMillis();
                    a.notifyChanged(this, eventType, changedFeature, oldValue, newValue, pos);
                    long notifyDuration = System.currentTimeMillis() - startTime;
                    if (getAdapterTimeCriteria >= 0L && notifyDuration > getAdapterTimeCriteria) {
                        System.out.println("adapter notifyDuration: " + notifyDuration + "  class: " + a.getClass());
                    }
                } else {
                    try {
                        a.notifyChanged(this, eventType, changedFeature, oldValue, newValue, pos);
                    }
                    catch (Exception e) {
                        Logger.logException("A structured model client, " + a + " threw following exception during adapter notification (" + INodeNotifier.EVENT_TYPE_STRINGS[eventType] + " )", e);
                    }
                }
                ++i;
            }
        }
    }

    public synchronized void removeAdapter(INodeAdapter a) {
        if (this.fAdapters == null || a == null) {
            return;
        }
        int newIndex = 0;
        INodeAdapter[] newAdapters = new INodeAdapter[this.fAdapters.length];
        int oldAdapterCount = this.adapterCount;
        boolean found = false;
        int oldIndex = 0;
        while (oldIndex < oldAdapterCount) {
            INodeAdapter candidate = this.fAdapters[oldIndex];
            if (a == candidate) {
                --this.adapterCount;
                found = true;
            } else {
                newAdapters[newIndex++] = this.fAdapters[oldIndex];
            }
            ++oldIndex;
        }
        if (found) {
            this.fAdapters = newAdapters;
        }
    }
}

