/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.tasks;

import java.io.InputStream;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionParser;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.tasks.IFileTaskScanner;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public abstract class StructuredFileTaskScanner
implements IFileTaskScanner {
    protected List fNewMarkerAttributeMaps = new ArrayList();
    List oldMarkers = null;
    private long time0;

    public StructuredFileTaskScanner() {
        if (Logger.DEBUG_TASKS) {
            System.out.println(String.valueOf(this.getClass().getName()) + " instance created");
        }
    }

    protected Map createInitialMarkerAttributes(String text, int documentLine, int startOffset, int length, int priority) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(6);
        attributes.put("lineNumber", new Integer(documentLine + 1));
        attributes.put("org.eclipse.core.resources.taskmarker", "org.eclipse.wst.sse.core.task");
        attributes.put("charStart", new Integer(startOffset));
        attributes.put("charEnd", new Integer(startOffset + length));
        attributes.put("message", text);
        attributes.put("userEditable", Boolean.TRUE);
        attributes.put("org.eclipse.ui.part.IShowInTarget", new String[]{""});
        switch (priority) {
            case 2: {
                attributes.put("priority", new Integer(2));
                break;
            }
            case 0: {
                attributes.put("priority", new Integer(0));
                break;
            }
            default: {
                attributes.put("priority", new Integer(1));
            }
        }
        return attributes;
    }

    /*
     * Exception decompiling
     */
    private String detectCharset(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 140->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void findTasks(IDocument document, TaskTag[] taskTags, IStructuredDocumentRegion documentRegion, ITextRegion comment) {
        if (this.isCommentRegion(documentRegion, comment)) {
            int startOffset = documentRegion.getStartOffset(comment);
            int endOffset = documentRegion.getTextEndOffset(comment);
            try {
                int startLine = document.getLineOfOffset(startOffset);
                int endLine = document.getLineOfOffset(endOffset);
                int lineNumber = startLine;
                while (lineNumber <= endLine) {
                    IRegion line = document.getLineInformation(lineNumber);
                    int begin = Math.max(startOffset, line.getOffset());
                    int end = Math.min(endOffset, line.getOffset() + line.getLength());
                    int length = end - begin;
                    String commentedText = this.getCommentedText(document, begin, length);
                    String comparisonText = commentedText.toLowerCase(Locale.ENGLISH);
                    int i = 0;
                    while (i < taskTags.length) {
                        int tagIndex = comparisonText.indexOf(taskTags[i].getTag().toLowerCase(Locale.ENGLISH));
                        if (tagIndex >= 0) {
                            String markerDescription = commentedText.substring(tagIndex);
                            int markerOffset = begin + tagIndex;
                            int markerLength = end - markerOffset;
                            this.fNewMarkerAttributeMaps.add(this.createInitialMarkerAttributes(markerDescription, lineNumber, markerOffset, markerLength, taskTags[i].getPriority()));
                        }
                        ++i;
                    }
                    ++lineNumber;
                }
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
    }

    private void findTasks(IFile file, TaskTag[] taskTags, IProgressMonitor monitor) {
        try {
            IEncodedDocument document;
            RegionParser parser;
            IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerFor(file);
            boolean didStreamParse = false;
            IProgressMonitor progressMonitor = monitor;
            IEncodedDocument defaultDocument = handler.getDocumentLoader().createNewStructuredDocument();
            if (defaultDocument instanceof IStructuredDocument && (parser = ((IStructuredDocument)defaultDocument).getParser()) instanceof StructuredDocumentRegionParser) {
                didStreamParse = true;
                String charset = this.detectCharset(file);
                StructuredDocumentRegionParser documentParser = (StructuredDocumentRegionParser)parser;
                Document textDocument = new Document();
                this.setDocumentContent((IDocument)textDocument, file.getContents(true), charset);
                documentParser.reset(new DocumentReader((IDocument)textDocument));
                documentParser.addStructuredDocumentRegionHandler(new StructuredDocumentRegionHandler((IDocument)textDocument, taskTags, progressMonitor){
                    private final /* synthetic */ IDocument val$textDocument;
                    private final /* synthetic */ TaskTag[] val$taskTags;
                    private final /* synthetic */ IProgressMonitor val$progressMonitor;
                    {
                        this.val$textDocument = iDocument;
                        this.val$taskTags = taskTagArray;
                        this.val$progressMonitor = iProgressMonitor;
                    }

                    public void nodeParsed(IStructuredDocumentRegion documentRegion) {
                        ITextRegionList regions = documentRegion.getRegions();
                        int j = 0;
                        while (j < regions.size()) {
                            ITextRegion comment = regions.get(j);
                            StructuredFileTaskScanner.this.findTasks(this.val$textDocument, this.val$taskTags, documentRegion, comment);
                            ++j;
                        }
                        if (documentRegion.getPrevious() != null) {
                            documentRegion.getPrevious().setPrevious(null);
                            documentRegion.getPrevious().setNext(null);
                        }
                        if (this.val$progressMonitor.isCanceled()) {
                            this.val$textDocument.set("");
                        }
                    }

                    public void resetNodes() {
                    }
                });
                documentParser.getDocumentRegions();
            }
            if (!didStreamParse && (document = handler.getDocumentLoader().createNewStructuredDocument(file)) instanceof IStructuredDocument) {
                IStructuredDocumentRegion documentRegion = ((IStructuredDocument)document).getFirstStructuredDocumentRegion();
                while (documentRegion != null) {
                    ITextRegionList regions = documentRegion.getRegions();
                    int j = 0;
                    while (j < regions.size()) {
                        ITextRegion comment = regions.get(j);
                        this.findTasks(document, taskTags, documentRegion, comment);
                        ++j;
                    }
                    documentRegion = documentRegion.getNext();
                }
            }
        }
        catch (CoreException e) {
            Logger.logException("Exception with " + file.getFullPath().toString(), e);
        }
        catch (CharacterCodingException characterCodingException) {
            Logger.log(1, "StructuredFileTaskScanner encountered CharacterCodingException reading " + file.getLocation());
        }
        catch (Exception e) {
            Logger.logException("Exception with " + file.getFullPath().toString(), e);
        }
    }

    protected String getCommentedText(IDocument document, int begin, int length) throws BadLocationException {
        return document.get(begin, length);
    }

    protected abstract boolean isCommentRegion(IStructuredDocumentRegion var1, ITextRegion var2);

    public synchronized Map[] scan(IFile file, TaskTag[] taskTags, IProgressMonitor monitor) {
        this.fNewMarkerAttributeMaps.clear();
        if (monitor.isCanceled() || !this.shouldScan((IResource)file)) {
            return new Map[0];
        }
        if (Logger.DEBUG_TASKSPERF) {
            this.time0 = System.currentTimeMillis();
        }
        if (taskTags.length > 0) {
            this.findTasks(file, taskTags, monitor);
        }
        if (Logger.DEBUG_TASKSPERF) {
            System.out.println(System.currentTimeMillis() - this.time0 + "ms for " + file.getLocation());
        }
        return this.fNewMarkerAttributeMaps.toArray(new Map[this.fNewMarkerAttributeMaps.size()]);
    }

    /*
     * Exception decompiling
     */
    protected void setDocumentContent(IDocument document, InputStream contentStream, String charset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 124->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean shouldScan(IResource r) {
        String s = r.getName();
        return s.length() == 0 || s.charAt(0) != '.';
    }

    public void shutdown(IProject project) {
        if (Logger.DEBUG_TASKS) {
            System.out.println(this + " shutdown for " + project.getName());
        }
    }

    public void startup(IProject project) {
        if (Logger.DEBUG_TASKS) {
            System.out.println(this + " startup for " + project.getName());
        }
        if (Logger.DEBUG_TASKSPERF) {
            this.time0 = System.currentTimeMillis();
        }
        if (Logger.DEBUG_TASKSPERF) {
            System.out.println(System.currentTimeMillis() - this.time0 + "ms loading prefs for " + project.getName());
        }
    }
}

