/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.io.OutputStream;
import javax.wsdl.Definition;
import org.eclipse.wst.ws.internal.explorer.platform.actions.ImportToFileSystemAction;
import org.eclipse.wst.ws.internal.explorer.platform.actions.WSDLFileNameHelper;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceInterfaceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.util.Uddi4jHelper;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;

public class UDDIImportWSDLToFileSystemAction
extends ImportToFileSystemAction {
    private NodeManager nodeManager_;
    private Definition def_;
    private String defaultWSDLFileName_;

    public UDDIImportWSDLToFileSystemAction(Controller controller) {
        super(controller);
        this.nodeManager_ = controller.getUDDIPerspective().getNavigatorManager();
        this.def_ = null;
        this.defaultWSDLFileName_ = "temp.wsdl";
    }

    public static final String getActionLink(int nodeId, int toolId, int viewId, int viewToolId) {
        return ImportToFileSystemAction.getActionLink(nodeId, toolId, viewId, viewToolId, "uddi/actions/UDDIImportWSDLToFileSystemActionJSP.jsp");
    }

    public final boolean write(OutputStream os) {
        return this.writeWSDLDefinition(os, this.def_);
    }

    public final String getDefaultFileName() {
        return this.defaultWSDLFileName_;
    }

    public final boolean run() {
        MessageQueue messageQueue = this.controller_.getUDDIPerspective().getMessageQueue();
        int nodeId = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        Node node = this.nodeManager_.getNode(nodeId);
        Uddi4jHelper uddi4jHelper = new Uddi4jHelper();
        String wsdlUrl = null;
        if (node != null) {
            TreeElement element = node.getTreeElement();
            if (element instanceof ServiceElement) {
                ServiceElement serviceElement = (ServiceElement)element;
                BusinessService bs = serviceElement.getBusinessService();
                wsdlUrl = uddi4jHelper.getWSDL(bs, serviceElement.getRegistryElement().getProxy());
            } else if (element instanceof ServiceInterfaceElement) {
                TModel tModel = ((ServiceInterfaceElement)element).getTModel();
                wsdlUrl = uddi4jHelper.getWSDL(tModel);
            }
        }
        if (wsdlUrl != null) {
            try {
                this.def_ = uddi4jHelper.getWSDLDefinition(wsdlUrl);
                if (this.def_ != null) {
                    int index = wsdlUrl.indexOf(47);
                    String wsdlPathname = index != -1 ? wsdlUrl.substring(index + 1, wsdlUrl.length()) : wsdlUrl;
                    this.defaultWSDLFileName_ = WSDLFileNameHelper.getWSDLFileName(wsdlPathname);
                }
                return true;
            }
            catch (Throwable throwable) {
                messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_RETRIEVING_WSDL_DOC"));
            }
        }
        return false;
    }

    public final String getStatusContentVar() {
        return this.controller_.getUDDIPerspective().getStatusContentVar();
    }

    public final String getStatusContentPage() {
        return this.controller_.getUDDIPerspective().getStatusContentPage();
    }
}

