/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.rdb.connection.internal.ui.factories.RSCCoreUIWidgetFactory;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;


/**
 * Panel for the user ID and password.
 */
public class NewCWUidPwd implements Listener
{
    /** Options for configuring the content of this panel. */
    protected int contentOptions;

 //    protected Button currentCheck;
    protected Label userIdLabel;
    protected Label passwordLabel;
    protected Combo userIdCombo;
    protected Text passwordText;

    protected RDBWizardPage parentPage;
    protected Composite contents;

    /**
     * @param parent
     *            Parent composite.
     * @param style
     *            SWT style flags.
     */
    public NewCWUidPwd(RDBWizardPage parentPage, int options)
    {
        this.parentPage = parentPage;
        contentOptions = options;
    }

    /**
     * @param parent
     *            The parent for the Composite returned.
     * @return A composite containing the components to be displayed.
     */
    public Composite getComposite(Composite parent, RSCCoreUIWidgetFactory factory)
    {
        if (contents == null)
        {
            contents = factory.createGroup(parent, parentPage.getString("CUI_NEWCW_SPECIFY_USER_INFO_UI_"), SWT.NONE); //$NON-NLS-1$
            createLayout(contents);
            createGUI(contents, factory);
        }
        return contents;
    }

    public void createLayout(Composite contents)
    {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        contents.setLayout(layout);
    }

    /**
     * Adds this as listener to various components.
     */
    public void addListeners()
    {
//        currentCheck.addListener(SWT.Selection, this);
        userIdCombo.addListener(SWT.Modify, this);
        passwordText.addListener(SWT.Modify, this);
    }

    /**
     * Adds this as listener to various components.
     */
    public void removeListeners()
    {
 //       currentCheck.removeListener(SWT.Selection, this);
        userIdCombo.removeListener(SWT.Modify, this);
        passwordText.removeListener(SWT.Modify, this);
    }

    /**
     * Creates UI portions to collect user ID and password.
     */
    protected void createGUI(Composite parent, RSCCoreUIWidgetFactory factory)
    {
        GridData gd;

//        currentCheck = factory.createButton(parent, SWT.CHECK);
//        currentCheck.setText(parentPage.getString("CUI_NEWCW_USE_CURRENT_USERID_UI_"));
//        currentCheck.setEnabled((contentOptions & NewConnectionWizard.DISABLE_CURRENT_USERID_PWD) == 0);
//        gd = new GridData();
//        gd.verticalAlignment = GridData.BEGINNING;
//        gd.horizontalSpan = 2;
//        currentCheck.setLayoutData(gd);

        userIdLabel = factory.createLabel(parent, SWT.NONE);
        userIdLabel.setText(parentPage.getString("CUI_NEWCW_USERID_LBL_UI_")); //$NON-NLS-1$
 //       userIdLabel.setEnabled((contentOptions & NewConnectionWizard.DISABLE_CURRENT_USERID_PWD) > 0);
        gd = new GridData();
        gd.verticalAlignment = GridData.BEGINNING;
        userIdLabel.setLayoutData(gd);

        userIdCombo = factory.createCombo(parent, SWT.SINGLE | SWT.BORDER);
 //       userIdCombo .setEnabled((contentOptions & NewConnectionWizard.DISABLE_CURRENT_USERID_PWD) > 0);
        gd = new GridData();
        gd.widthHint = 100;
        gd.verticalAlignment = GridData.BEGINNING;
        gd.horizontalAlignment = GridData.FILL;
        userIdCombo.setLayoutData(gd);

        passwordLabel = factory.createLabel(parent, SWT.NONE);
        passwordLabel.setText(parentPage.getString("CUI_NEWCW_PASSWORD_LBL_UI_")); //$NON-NLS-1$
 //       passwordLabel.setEnabled((contentOptions & NewConnectionWizard.DISABLE_CURRENT_USERID_PWD) > 0);
        gd = new GridData();
        gd.verticalAlignment = GridData.BEGINNING;
        passwordLabel.setLayoutData(gd);

        passwordText = factory.createText(parent, SWT.BORDER);
        passwordText.setEchoChar('*');
 //       passwordText.setEnabled((contentOptions & NewConnectionWizard.DISABLE_CURRENT_USERID_PWD) > 0);
        gd = new GridData();
        gd.widthHint = 100;
        gd.verticalAlignment = GridData.BEGINNING;
        gd.horizontalAlignment = GridData.FILL;
        passwordText.setLayoutData(gd);

//        enableCurrentUidPwd(true);
    }

//    /**
//     * Enabled the use current checkbox for App drivers and disables it for net
//     * drivers.
//     * 
//     * @param enable
//     *            True to enable the checkbox.
//     */
//    protected void enableCurrentUidPwd(boolean enable)
//    {
//        currentCheck.setEnabled(true);
//        currentCheck.setSelection(enable);
//        boolean ena = enable
//                && (contentOptions & NewConnectionWizard.DISABLE_CURRENT_USERID_PWD) == 0;
//        currentCheck.setEnabled(ena);
//        enableUidPwd(!ena);
//    }

//    /**
//     * Use to check/uncheck the Use Current User ID checkbox.
//     * 
//     * @param checked
//     *            True to check the checkbox.
//     */
//    protected void selectCurrentUidPwdCheckbox(boolean checked){
//    	currentCheck.setSelection(checked);
//    	enableUidPwd(!checked);
//    }
    
    /**
     * Sets the text value of the user ID combo.
     */
    public void setUserId(String id)
    {
        userIdCombo.setText(id);
    }

    /**
     * Sets the text value of the password field.
     */
    public void setPassword(String pwd)
    {
        passwordText.setText(pwd);
    }

    public String getUserId()
    {
        return userIdCombo.getText();
    }

    public String getPassword()
    {
        return passwordText.getText();
    }

    /** Implements the Listener interface. */
    public void handleEvent(Event e)
    {
//        Widget source = e.widget;
//        if (source == currentCheck)
//        {
//            boolean selected = currentCheck.getSelection();
//            enableUidPwd(!selected);
//        }
        parentPage.setPageComplete(parentPage.determinePageCompletion());
    }

    /**
     * Enables the user ID and password controls.
     * 
     * @param enable
     *            True to enable these controls.
     */
    protected void enableUidPwd(boolean enable)
    {
        userIdLabel.setEnabled(enable);
        passwordLabel.setEnabled(enable);
        userIdCombo.setEnabled(enable);
        passwordText.setEnabled(enable);
    }

    /**
     * Fills all the entry fields with information from the passed connection.
     */
    public void fillFromConnection(ConnectionInfo connection)
    {
        if (connection.getUserName() != null)
        {
            userIdCombo.setText(connection.getUserName());
        }
        else
        {
            userIdCombo.setText(""); //$NON-NLS-1$
        }
        
        if (connection.getPassword() != null)
        {
            passwordText.setText(connection.getPassword());
        }
        else
        {
            passwordText.setText(""); //$NON-NLS-1$
        }
        
//        if (currentCheck != null && currentCheck.getEnabled())
//        {
//            if (userIdCombo.getText().length() == 0)
//            {
//                currentCheck.setSelection(true);
//                enableUidPwd(false);
//            }
//            else
//            {
//                currentCheck.setSelection(false);
//                enableUidPwd(false);
//            }
//        }
        parentPage.setPageComplete(parentPage.determinePageCompletion());
    }

    /**
     * Sets the connection details. Used for populating new connections.
     * 
     * @param connection
     *            An RDBConnection object to reflect the choices in this panel.
     */
    public void setConnectionDetails(ConnectionInfo connection)
    {
//        if (currentCheck != null && currentCheck.getEnabled() && currentCheck.getSelection())
//        {
//            connection.setUserName(System.getProperty("user.name"));
//            connection.setPassword("");
//        }
//        else
//        {
            connection.setUserName(getUserId());
            connection.setPassword(getPassword());
//        }
    }

    public boolean determinePageCompletion()
    {
        return validateUserID();
    }

    protected boolean requiresUIDPwd()
    {
       return true;
    }

    protected boolean validateUserID()
    {
        if (userIdCombo != null && userIdCombo.getEnabled() && userIdCombo.getText().length() <= 0)
        {
            parentPage.setErrorMessage(parentPage.getString("CUI_NEWCW_VALIDATE_USERID_REQ_MSG_UI_")); //$NON-NLS-1$
            return false;
        }
        else
        {
            return true;
        }
    }

    protected boolean validatePassword()
    {
        if (requiresUIDPwd() && passwordText != null && passwordText.getEnabled()
                && passwordText.getText().length() <= 0)
        {
            parentPage.setErrorMessage(parentPage.getString("CUI_NEWCW_VALIDATE_PASSWORD_REQ_MSG_UI_")); //$NON-NLS-1$
            return false;
        }
        else
        {
            return true;
        }
    }

    /**
     * Loads widget values from values saved by the previous instance of this
     * class.
     */
    public void internalLoadWidgetValues()
    {
        // set default values
        IDialogSettings dialogSettings = parentPage.getWizard().getDialogSettings();
        if (dialogSettings != null)
        {
            // userid value
            String[] values = dialogSettings.getArray(NewConnectionWizard.STORE_USERIDS);
            if (values != null)
            {
                parentPage.loadComboSettings(userIdCombo, values, true);
            }
            else
            {
                userIdCombo.setText(System.getProperty("user.name")); //$NON-NLS-1$
            }
//            // checkbox and enabling
//            if (currentCheck.getEnabled())
//            {
//                boolean current;
//                String v = dialogSettings.get(NewConnectionWizard.STORE_USE_OS_UID_PWD);
//                if (v == null || v.length() == 0)
//                    current = true;
//                else
//                    current = dialogSettings.getBoolean(NewConnectionWizard.STORE_USE_OS_UID_PWD);
//                currentCheck.setSelection(current);
//                enableUidPwd(!current);
//                enableCurrentUidPwd(current);
//            }
        }
    }

    /**
     * Saves widget values for the next instance of this class.
     */
    public void internalSaveWidgetValues()
    {
        IDialogSettings dialogSettings = parentPage.getWizard().getDialogSettings();
        if (dialogSettings != null)
        {
            // user ID and password
            boolean useCurrent = false;  //currentCheck.getSelection();
            // Use current
            dialogSettings.put(NewConnectionWizard.STORE_USE_OS_UID_PWD, useCurrent);
            if (!useCurrent)
            {
                // update userid names history
                String[] userids = dialogSettings.getArray(NewConnectionWizard.STORE_USERIDS);
                userids = parentPage.addToHistory(userids, userIdCombo.getText().trim());
                dialogSettings.put(NewConnectionWizard.STORE_USERIDS, userids);
            }
        }
    }

}
