/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.sqleditor.internal.actions;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorResources;

/**
 * This class implements a dialog that prompts the user to specify a statement
 * terminator (separator) string.  The statement terminator is a string (typically
 * a single character) that separates SQL statements in the SQL source text.
 */
public class SQLSetStatementTerminatorDialog extends InputDialog {

    private Composite   fDialogArea;
    protected Composite fDialogAreaParent;
    
    /**
     * Constructs an instance of this class with the given parent shell.
     * 
     * @param parentShell the parent for this dialog
     * @param statementTerminator the initial statement terminator
     */
    public SQLSetStatementTerminatorDialog( Shell parentShell, String statementTerminator ) {
        super( parentShell,
               SQLEditorResources.getString( "SQLEditor.setStatementTerminatorDialog.title" ), //$NON-NLS-1$
               SQLEditorResources.getString( "SQLEditor.setStatementTerminatorDialog.prompt" ), //$NON-NLS-1$
               statementTerminator,
               null
              );
        
        fDialogArea = null;
        fDialogAreaParent = null;
    }

    /**
     * Configures the given shell in preparation for opening this window in it.
     * 
     * @param shell the shell to configure
     * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
     */
//    protected void configureShell( Shell shell ) {
//        super.configureShell( shell );
//
//        // Give this dialog a title.
//        shell.setText( SQLEditorResources.getString( "SQLEditor.setStatementTerminatorDialog.title" ));
//    }

    /**
     * Creates and returns the contents of the upper part of this dialog (above
     * the button bar).
     * 
     * @param parent the parent composite
     * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
     */
    protected Control createDialogArea( Composite parent ) {
        fDialogAreaParent = parent;
        fDialogArea = (Composite) super.createDialogArea( parent );
//        fDialogArea = new SQLSetStatementTerminatorComposite( fDialogAreaParent, SWT.NONE );
//        GridLayout layout = new GridLayout();
//        layout.marginHeight = 25;
//        layout.marginWidth = 5;
//        fDialogArea.setLayout( layout );

        return fDialogArea;
    }

    /**
     * Gets the control that comprises the upper part ("dialog area") of this dialog.
     * (That is, the area above the button bar.)
     * 
     * @return the dialog area control
     */
    public Control getDialogArea() {
        return fDialogArea;
    }
}
