/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.internal.about.AboutData;
import org.eclipse.ui.internal.dialogs.ProductInfoDialog;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;

public class AboutPluginsDialog
extends ProductInfoDialog {
    private static final int TABLE_HEIGHT = 200;
    private static final IPath baseNLPath = new Path("$nl$");
    private static final String PLUGININFO = "about.html";
    private static final int MORE_ID = 1025;
    private Table vendorInfo;
    private Button moreInfo;
    private String title;
    private String message;
    private String helpContextId;
    private String[] columnTitles = new String[]{WorkbenchMessages.AboutPluginsDialog_provider, WorkbenchMessages.AboutPluginsDialog_pluginName, WorkbenchMessages.AboutPluginsDialog_version, WorkbenchMessages.AboutPluginsDialog_pluginId};
    private String productName;
    private AboutBundleData[] bundleInfos;
    private int lastColumnChosen = 0;
    private boolean reverseSort = false;
    private AboutBundleData lastSelection = null;

    public AboutPluginsDialog(Shell parentShell, String productName) {
        this(parentShell, productName, WorkbenchPlugin.getDefault().getBundles(), null, null, "org.eclipse.ui.about_plugins_dialog_context");
    }

    public AboutPluginsDialog(Shell parentShell, String productName, Bundle[] bundles, String title, String message, String helpContextId) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.title = title;
        this.message = message;
        this.helpContextId = helpContextId;
        this.productName = productName;
        HashMap<String, AboutBundleData> map = new HashMap<String, AboutBundleData>();
        int i = 0;
        while (i < bundles.length) {
            AboutBundleData data = new AboutBundleData(bundles[i]);
            if (BundleUtility.isReady(data.getState()) && !map.containsKey(data.getVersionedId())) {
                map.put(data.getVersionedId(), data);
            }
            ++i;
        }
        this.bundleInfos = map.values().toArray(new AboutBundleData[0]);
        AboutData.sortByProvider(this.reverseSort, this.bundleInfos);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.handleMoreInfoPressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title == null && this.productName != null) {
            this.title = NLS.bind((String)WorkbenchMessages.AboutPluginsDialog_shellTitle, (Object)this.productName);
        }
        if (this.title != null) {
            newShell.setText(this.title);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, this.helpContextId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.moreInfo = this.createButton(parent, 1025, WorkbenchMessages.AboutPluginsDialog_moreInfo, false);
        this.moreInfo.setEnabled(this.tableHasSelection() && this.selectionHasInfo());
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(outer, 0);
            label.setLayoutData((Object)new GridData(768));
            label.setFont(parent.getFont());
            label.setText(this.message);
        }
        this.createTable(outer);
        return outer;
    }

    protected void createTable(Composite parent) {
        this.vendorInfo = new Table(parent, 68356);
        this.vendorInfo.setHeaderVisible(true);
        this.vendorInfo.setLinesVisible(true);
        this.vendorInfo.setFont(parent.getFont());
        this.vendorInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AboutPluginsDialog.this.moreInfo.setEnabled(e.item != null && AboutPluginsDialog.this.selectionHasInfo());
            }
        });
        int[] columnWidths = new int[]{this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(70), this.convertHorizontalDLUsToPixels(130)};
        int i = 0;
        while (i < this.columnTitles.length) {
            TableColumn column = new TableColumn(this.vendorInfo, 0);
            column.setWidth(columnWidths[i]);
            column.setText(this.columnTitles[i]);
            final int columnIndex = i++;
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AboutPluginsDialog.this.sort(columnIndex);
                }
            });
        }
        i = 0;
        while (i < this.bundleInfos.length) {
            TableItem item = new TableItem(this.vendorInfo, 0);
            item.setText(AboutPluginsDialog.createRow(this.bundleInfos[i]));
            item.setData((Object)this.bundleInfos[i]);
            ++i;
        }
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertVerticalDLUsToPixels(200);
        this.vendorInfo.setLayoutData((Object)gridData);
    }

    private boolean selectionHasInfo() {
        TableItem[] items = this.vendorInfo.getSelection();
        if (items.length <= 0) {
            return false;
        }
        AboutBundleData bundleInfo = this.bundleInfos[this.vendorInfo.getSelectionIndex()];
        URL infoURL = this.getMoreInfoURL(bundleInfo, false);
        if (infoURL == null && WorkbenchPlugin.DEBUG) {
            WorkbenchPlugin.log("Problem reading plugin info for: " + bundleInfo.getName());
        }
        return infoURL != null;
    }

    private boolean tableHasSelection() {
        return this.vendorInfo == null ? false : this.vendorInfo.getSelectionCount() > 0;
    }

    protected void handleMoreInfoPressed() {
        if (this.vendorInfo == null) {
            return;
        }
        TableItem[] items = this.vendorInfo.getSelection();
        if (items.length <= 0) {
            return;
        }
        AboutBundleData bundleInfo = (AboutBundleData)items[0].getData();
        if (bundleInfo == null) {
            return;
        }
        if (!this.openBrowser(this.getMoreInfoURL(bundleInfo, true))) {
            MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.AboutPluginsDialog_errorTitle, (String)NLS.bind((String)WorkbenchMessages.AboutPluginsDialog_unableToOpenFile, (Object)PLUGININFO, (Object)bundleInfo.getId()));
        }
    }

    private void sort(int column) {
        if (this.lastColumnChosen == column) {
            this.reverseSort = !this.reverseSort;
        } else {
            this.reverseSort = false;
            this.lastColumnChosen = column;
        }
        if (this.vendorInfo.getItemCount() <= 1) {
            return;
        }
        int sel = this.vendorInfo.getSelectionIndex();
        if (sel != -1) {
            this.lastSelection = this.bundleInfos[sel];
        }
        switch (column) {
            case 0: {
                AboutData.sortByProvider(this.reverseSort, this.bundleInfos);
                break;
            }
            case 1: {
                AboutData.sortByName(this.reverseSort, this.bundleInfos);
                break;
            }
            case 2: {
                AboutData.sortByVersion(this.reverseSort, this.bundleInfos);
                break;
            }
            case 3: {
                AboutData.sortById(this.reverseSort, this.bundleInfos);
            }
        }
        this.refreshTable(column);
    }

    private void refreshTable(int col) {
        TableItem[] items = this.vendorInfo.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setText(AboutPluginsDialog.createRow(this.bundleInfos[i]));
            items[i].setData((Object)this.bundleInfos[i]);
            ++i;
        }
        int sel = -1;
        if (this.lastSelection != null) {
            String oldId = this.lastSelection.getId();
            int k = 0;
            while (k < this.bundleInfos.length) {
                if (oldId.equalsIgnoreCase(this.bundleInfos[k].getId())) {
                    sel = k;
                }
                ++k;
            }
            this.vendorInfo.setSelection(sel);
            this.vendorInfo.showSelection();
        }
        this.moreInfo.setEnabled(this.tableHasSelection() && this.selectionHasInfo());
    }

    private static String[] createRow(AboutBundleData info) {
        return new String[]{info.getProviderName(), info.getName(), info.getVersion(), info.getId()};
    }

    private URL getMoreInfoURL(AboutBundleData bundleInfo, boolean makeLocal) {
        Bundle bundle = Platform.getBundle((String)bundleInfo.getId());
        if (bundle == null) {
            return null;
        }
        URL aboutUrl = Platform.find((Bundle)bundle, (IPath)baseNLPath.append(PLUGININFO), null);
        if (!makeLocal) {
            return aboutUrl;
        }
        if (aboutUrl != null) {
            try {
                URL result = Platform.asLocalURL((URL)aboutUrl);
                try {
                    URL about = new URL(aboutUrl, "about_files");
                    if (about != null) {
                        Platform.asLocalURL((URL)about);
                    }
                }
                catch (IOException iOException) {}
                return result;
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

