/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.actions.NewWizardAction;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public abstract class WizardHandler
extends AbstractHandler {
    protected abstract IAction createWizardChooserDialogAction(IWorkbenchWindow var1);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String wizardId = event.getParameter(this.getWizardIdParameterId());
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            throw new ExecutionException("no active workbench window");
        }
        if (wizardId == null) {
            IAction wizardAction = this.createWizardChooserDialogAction(activeWindow);
            wizardAction.run();
        } else {
            IWizardRegistry wizardRegistry = this.getWizardRegistry();
            IWizardDescriptor wizardDescriptor = wizardRegistry.findWizard(wizardId);
            if (wizardDescriptor == null) {
                throw new ExecutionException("unknown wizard: " + wizardId);
            }
            try {
                IWorkbenchWizard wizard = wizardDescriptor.createWizard();
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                Shell parent = activeWindow.getShell();
                WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
            catch (CoreException ex) {
                throw new ExecutionException("error creating wizard", (Throwable)ex);
            }
        }
        return null;
    }

    protected abstract String getWizardIdParameterId();

    protected abstract IWizardRegistry getWizardRegistry();

    public static final class Export
    extends WizardHandler {
        protected IAction createWizardChooserDialogAction(IWorkbenchWindow window) {
            return new ExportResourcesAction(window);
        }

        protected String getWizardIdParameterId() {
            return "exportWizardId";
        }

        protected IWizardRegistry getWizardRegistry() {
            return PlatformUI.getWorkbench().getExportWizardRegistry();
        }
    }

    public static final class Import
    extends WizardHandler {
        protected IAction createWizardChooserDialogAction(IWorkbenchWindow window) {
            return new ImportResourcesAction(window);
        }

        protected String getWizardIdParameterId() {
            return "importWizardId";
        }

        protected IWizardRegistry getWizardRegistry() {
            return PlatformUI.getWorkbench().getImportWizardRegistry();
        }
    }

    public static final class New
    extends WizardHandler {
        protected IAction createWizardChooserDialogAction(IWorkbenchWindow window) {
            return new NewWizardAction(window);
        }

        protected String getWizardIdParameterId() {
            return "newWizardId";
        }

        protected IWizardRegistry getWizardRegistry() {
            return PlatformUI.getWorkbench().getNewWizardRegistry();
        }
    }
}

