/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;

public final class URLEncoder {
    private URLEncoder() {
    }

    public static String encode(String file, String query, String ref) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(file, "/", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("/")) {
                buf.append(token);
                continue;
            }
            buf.append(URLEncoder.encodeSegment(token));
        }
        if (query != null) {
            buf.append('?');
            buf.append(query);
        }
        if (ref != null) {
            buf.append('#');
            buf.append(URLEncoder.encodeSegment(ref));
        }
        return buf.toString();
    }

    public static URL encode(URL url) throws MalformedURLException {
        String file = url.getPath();
        String query = url.getQuery();
        String ref = url.getRef();
        String auth = url.getAuthority();
        String host = url.getHost();
        int port = url.getPort();
        URL result = url;
        if (auth == null || auth.equals("") || auth.equals(String.valueOf(host) + ":" + port)) {
            result = new URL(url.getProtocol(), host, port, URLEncoder.encode(file, query, ref));
        }
        return result;
    }

    private static String encodeSegment(String segment) {
        if (segment.indexOf(37) != -1) {
            return segment;
        }
        StringBuffer result = new StringBuffer(segment.length());
        int i = 0;
        while (i < segment.length()) {
            char c = segment.charAt(i);
            if (URLEncoder.mustEncode(c)) {
                byte[] bytes = null;
                try {
                    bytes = new Character(c).toString().getBytes("UTF8");
                }
                catch (UnsupportedEncodingException e) {
                    Assert.isTrue((boolean)false, (String)e.getMessage());
                }
                int j = 0;
                while (j < bytes.length) {
                    result.append('%');
                    result.append(Integer.toHexString(bytes[j] >> 4 & 0xF));
                    result.append(Integer.toHexString(bytes[j] & 0xF));
                    ++j;
                }
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private static boolean mustEncode(char c) {
        if (c >= 'a' && c <= 'z') {
            return false;
        }
        if (c >= 'A' && c <= 'Z') {
            return false;
        }
        if (c >= '0' && c <= '9') {
            return false;
        }
        if (c >= '\'' && c <= '.') {
            return false;
        }
        if (c == '!' || c == '$' || c == '_') {
            return false;
        }
        return c != ':';
    }
}

