/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.ResourceVariantTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSRevisionNumberCompareCriteria;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSResourceVariantFileRevision;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.core.mapping.ResourceVariantFileRevision;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;

public abstract class CVSSyncTreeSubscriber
extends ResourceVariantTreeSubscriber
implements IAdaptable {
    public static final String SYNC_KEY_QUALIFIER = "org.eclipse.team.cvs";
    private IResourceVariantComparator comparisonCriteria;
    private QualifiedName id;
    private String name;
    private SyncInfoToDiffConverter converter = new CVSSyncInfoToDiffConverter();

    CVSSyncTreeSubscriber(QualifiedName id, String name) {
        this.id = id;
        this.name = name;
        this.comparisonCriteria = new CVSRevisionNumberCompareCriteria(this.isThreeWay());
    }

    public QualifiedName getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        if (!this.isSupervised(resource)) {
            return null;
        }
        if (resource.getType() == 1 || !this.isThreeWay()) {
            return super.getSyncInfo(resource);
        }
        IResourceVariant remoteResource = this.getRemoteTree().getResourceVariant(resource);
        return this.getSyncInfo(resource, remoteResource, remoteResource);
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        block5: {
            try {
                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId());
                if (provider != null) break block5;
                return false;
            }
            catch (TeamException e) {
                if (e.getStatus().getCode() == 368 || !resource.getProject().isAccessible()) {
                    return false;
                }
                throw e;
            }
        }
        ICVSResource cvsThing = CVSWorkspaceRoot.getCVSResourceFor(resource);
        if (cvsThing.isIgnored()) {
            return this.getRemoteTree().hasResourceVariant(resource);
        }
        return true;
    }

    public IResourceVariantComparator getResourceComparator() {
        return this.comparisonCriteria;
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        CVSSyncInfo info = new CVSSyncInfo(local, base, remote, (Subscriber)this);
        info.init();
        return info;
    }

    protected boolean getCacheFileContentsHint() {
        return false;
    }

    protected boolean isThreeWay() {
        return true;
    }

    protected boolean rootsEqual(Subscriber other) {
        HashSet roots1 = new HashSet(Arrays.asList(other.roots()));
        HashSet roots2 = new HashSet(Arrays.asList(this.roots()));
        if (roots1.size() != roots2.size()) {
            return false;
        }
        return roots2.containsAll(roots1);
    }

    public IDiff getDiff(IResource resource) throws CoreException {
        SyncInfo info = this.getSyncInfo(resource);
        if (info == null || info.getKind() == 0) {
            return null;
        }
        return this.converter.getDeltaFor(info);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SyncInfoToDiffConverter.class) {
            return this.converter;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public class CVSSyncInfoToDiffConverter
    extends SyncInfoToDiffConverter {
        protected ResourceVariantFileRevision asFileRevision(IResourceVariant variant) {
            return new CVSResourceVariantFileRevision(variant);
        }
    }
}

