/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.InputPatchPage;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchWizard;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class PatchTargetPage
extends WizardPage {
    private boolean fShowError = false;
    private CheckboxTreeViewer fPatchTargets;
    private PatchWizard fPatchWizard;
    protected static final String PATCHTARGETPAGE_NAME = "PatchTargetPage";

    PatchTargetPage(PatchWizard pw) {
        super(PATCHTARGETPAGE_NAME, PatchMessages.PatchTargetPage_title, null);
        this.fPatchWizard = pw;
        this.setMessage(PatchMessages.PatchTargetPage_message);
    }

    protected IPath getPathFromText(Text textField) {
        return new Path(textField.getText()).makeAbsolute();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        Label l = new Label(composite, 0);
        l.setText(PatchMessages.InputPatchPage_SelectInput);
        this.buildInputGroup(composite);
        this.updateWidgetEnablements();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.compare.patch_input_wizard_page_context");
    }

    public IWizardPage getNextPage() {
        WorkspacePatcher patcher = ((PatchWizard)this.getWizard()).getPatcher();
        IResource target = this.fPatchWizard.getTarget();
        if (target instanceof IFile && patcher.getDiffs().length > 1) {
            InputPatchPage inputPage = (InputPatchPage)this.fPatchWizard.getPage("InputPatchPage");
            String source = "";
            switch (inputPage.getInputMethod()) {
                case 1: {
                    source = PatchMessages.InputPatchPage_Clipboard_title;
                    break;
                }
                case 2: {
                    source = PatchMessages.InputPatchPage_PatchFile_title;
                    break;
                }
                case 3: {
                    source = PatchMessages.InputPatchPage_WorkspacePatch_title;
                }
            }
            String format = PatchMessages.InputPatchPage_SingleFileError_format;
            String message = MessageFormat.format((String)format, (Object[])new String[]{source});
            MessageDialog.openInformation(null, (String)PatchMessages.InputPatchPage_PatchErrorDialog_title, (String)message);
            return this;
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void buildInputGroup(Composite parent) {
        Tree tree = new Tree(parent, 2048);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        tree.setLayoutData((Object)gd);
        this.fPatchTargets = new CheckboxTreeViewer(tree);
        this.fPatchTargets.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fPatchTargets.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fPatchTargets.setSorter((ViewerSorter)new ResourceSorter(1));
        this.fPatchTargets.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        PatchWizard pw = (PatchWizard)this.getWizard();
        IResource target = pw.getTarget();
        if (target != null) {
            this.fPatchTargets.expandToLevel((Object)target, 0);
            this.fPatchTargets.setSelection((ISelection)new StructuredSelection((Object)target));
        }
        this.fPatchTargets.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PatchTargetPage.this.fPatchWizard.setTarget(Utilities.getFirstResource(event.getSelection()));
                PatchTargetPage.this.updateWidgetEnablements();
            }
        });
        this.fPatchTargets.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PatchTargetPage.this.fPatchWizard.showPage(PatchTargetPage.this.getNextPage());
            }
        });
    }

    private void updateWidgetEnablements() {
        boolean anySelected;
        String error = null;
        ISelection selection = this.fPatchTargets.getSelection();
        boolean bl = anySelected = selection != null && !selection.isEmpty();
        if (!anySelected) {
            error = PatchMessages.InputPatchPage_NothingSelected_message;
        }
        this.setPageComplete(anySelected);
        if (this.fShowError) {
            this.setErrorMessage(error);
        }
    }

    public boolean finish() {
        return true;
    }
}

