/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.validation;

import java.math.BigDecimal;
import org.eclipse.jface.internal.databinding.internal.BindingMessages;
import org.eclipse.jface.internal.databinding.provisional.validation.IValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;

public class String2BigDecimalValidator
implements IValidator {
    public ValidationError isPartiallyValid(Object fragment) {
        if (((String)fragment).matches("\\-?[0-9]*\\.?[0-9]*([0-9]+[e|E]\\-?([0-9]+\\.)?[0-9]*)?")) {
            return null;
        }
        return ValidationError.error(this.getHint());
    }

    public ValidationError isValid(Object value) {
        try {
            new BigDecimal((String)value);
            return null;
        }
        catch (Throwable throwable) {
            return ValidationError.error(this.getHint());
        }
    }

    private String getHint() {
        return String.valueOf(BindingMessages.getString("Validate_Like")) + BindingMessages.getString("Validate_Number_Examples");
    }
}

