/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryActionImpl;
import org.eclipse.jdt.internal.ui.compare.JavaNode;
import org.eclipse.jdt.internal.ui.compare.JavaTextBufferNode;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

class JavaAddElementFromHistoryImpl
extends JavaHistoryActionImpl {
    private static final String BUNDLE_NAME = "org.eclipse.jdt.internal.ui.compare.AddFromHistoryAction";

    JavaAddElementFromHistoryImpl() {
        super(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(ISelection selection) {
        EditionSelectionDialog d;
        IDocument document;
        ITextFileBuffer textFileBuffer;
        ITextFileBufferManager bufferManager;
        IPath path;
        boolean inEditor;
        IMember parent;
        ICompilationUnit cu;
        Shell shell;
        String errorMessage;
        String errorTitle;
        block44: {
            errorTitle = CompareMessages.AddFromHistory_title;
            errorMessage = CompareMessages.AddFromHistory_internalErrorMessage;
            shell = this.getShell();
            cu = null;
            parent = null;
            IMember input = null;
            if (selection.isEmpty()) {
                JavaEditor editor = this.getEditor();
                if (editor != null) {
                    IEditorInput editorInput = editor.getEditorInput();
                    WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
                    if (manager != null) {
                        cu = manager.getWorkingCopy(editorInput);
                        parent = cu;
                    }
                }
            } else {
                Object o;
                input = this.getEditionElement(selection);
                if (input != null) {
                    cu = input.getCompilationUnit();
                    if (input != null) {
                        parent = input;
                        input = null;
                    }
                } else if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ICompilationUnit) {
                    cu = (ICompilationUnit)o;
                    parent = cu;
                }
            }
            if (parent == null || cu == null) {
                String invalidSelectionMessage = CompareMessages.AddFromHistory_invalidSelectionMessage;
                MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)invalidSelectionMessage);
                return;
            }
            IFile file = this.getFile(parent);
            if (file == null) {
                MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                return;
            }
            inEditor = this.beingEdited(file);
            IStatus status = Resources.makeCommittable((IResource)file, (Object)shell);
            if (!status.isOK()) {
                return;
            }
            path = file.getFullPath();
            bufferManager = FileBuffers.getTextFileBufferManager();
            textFileBuffer = null;
            bufferManager.connect(path, null);
            textFileBuffer = bufferManager.getTextFileBuffer(path);
            document = textFileBuffer.getDocument();
            JavaTextBufferNode target = new JavaTextBufferNode(file, document, inEditor);
            ITypedElement[] editions = this.buildEditions(target, file);
            ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            d = new EditionSelectionDialog(shell, bundle);
            d.setAddMode(true);
            d.setHelpContextId("org.eclipse.jdt.ui.add_element_from_history_dialog_context");
            ITypedElement selected = d.selectEdition((ITypedElement)target, editions, (Object)parent);
            if (selected != null) break block44;
            return;
        }
        try {
            try {
                ICompilationUnit cu2 = cu;
                if (parent instanceof IMember) {
                    cu2 = parent.getCompilationUnit();
                }
                CompilationUnit root = JavaAddElementFromHistoryImpl.parsePartialCompilationUnit(cu2);
                ASTRewrite rewriter = ASTRewrite.create((AST)root.getAST());
                ITypedElement[] results = d.getSelection();
                int i = 0;
                while (i < results.length) {
                    ListRewrite lw;
                    ASTNode newNode = this.createASTNode(rewriter, results[i], TextUtilities.getDefaultLineDelimiter((IDocument)document), cu.getJavaProject());
                    if (newNode == null) {
                        MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                        return;
                    }
                    if (newNode instanceof PackageDeclaration) {
                        rewriter.set((ASTNode)root, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)newNode, null);
                    } else if (newNode instanceof ImportDeclaration) {
                        lw = rewriter.getListRewrite((ASTNode)root, CompilationUnit.IMPORTS_PROPERTY);
                        lw.insertFirst(newNode, null);
                    } else if (parent instanceof ICompilationUnit) {
                        lw = rewriter.getListRewrite((ASTNode)root, CompilationUnit.TYPES_PROPERTY);
                        int index = ASTNodes.getInsertionIndex((BodyDeclaration)newNode, root.types());
                        lw.insertAt(newNode, index, null);
                    } else if (parent instanceof IType) {
                        ListRewrite lw2;
                        int index;
                        ASTNode declaration = this.getBodyContainer(root, (IMember)((IType)parent));
                        if (declaration instanceof TypeDeclaration || declaration instanceof AnnotationTypeDeclaration) {
                            List container = ASTNodes.getBodyDeclarations(declaration);
                            index = ASTNodes.getInsertionIndex((BodyDeclaration)newNode, container);
                            lw2 = rewriter.getListRewrite(declaration, ASTNodes.getBodyDeclarationsProperty(declaration));
                            lw2.insertAt(newNode, index, null);
                        } else if (declaration instanceof EnumDeclaration) {
                            List container = ((EnumDeclaration)declaration).enumConstants();
                            index = ASTNodes.getInsertionIndex((BodyDeclaration)((FieldDeclaration)newNode), container);
                            lw2 = rewriter.getListRewrite(declaration, EnumDeclaration.ENUM_CONSTANTS_PROPERTY);
                            lw2.insertAt(newNode, index, null);
                        }
                    } else {
                        JavaPlugin.logErrorMessage("JavaAddElementFromHistoryImpl: unknown container " + parent);
                    }
                    ++i;
                }
                Map options = null;
                IJavaProject javaProject = cu2.getJavaProject();
                if (javaProject != null) {
                    options = javaProject.getOptions(true);
                }
                this.applyChanges(rewriter, document, textFileBuffer, shell, inEditor, options);
                return;
            }
            catch (InvocationTargetException ex) {
                ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                return;
            }
            catch (InterruptedException interruptedException) {
                Assert.isTrue((boolean)false);
                return;
            }
            catch (CoreException ex) {
                ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
            }
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                if (textFileBuffer != null) {
                    bufferManager.disconnect(path, null);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private ASTNode createASTNode(ASTRewrite rewriter, ITypedElement element, String delimiter, IJavaProject project) throws CoreException {
        int type;
        String content;
        if (element instanceof IStreamContentAccessor && (content = JavaCompareUtilities.readString((IStreamContentAccessor)element)) != null && (content = JavaAddElementFromHistoryImpl.trimTextBlock(content, delimiter, project)) != null && (type = this.getPlaceHolderType(element)) != -1) {
            return rewriter.createStringPlaceholder(content, type);
        }
        return null;
    }

    private int getPlaceHolderType(ITypedElement element) {
        if (element instanceof DocumentRangeNode) {
            JavaNode jn = (JavaNode)element;
            switch (jn.getTypeCode()) {
                case 1: {
                    return 35;
                }
                case 4: 
                case 5: {
                    return 55;
                }
                case 6: {
                    return 71;
                }
                case 7: {
                    return 81;
                }
                case 10: 
                case 11: {
                    return 31;
                }
                case 8: {
                    return 23;
                }
                case 9: {
                    return 28;
                }
                case 2: 
                case 3: {
                    return 26;
                }
                case 0: {
                    return 15;
                }
            }
        }
        return -1;
    }

    protected boolean isEnabled(ISelection selection) {
        Object o;
        if (selection.isEmpty()) {
            JavaEditor editor = this.getEditor();
            if (editor != null) {
                IEditorInput editorInput = editor.getEditorInput();
                WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
                return manager.getWorkingCopy(editorInput) != null;
            }
            return false;
        }
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ICompilationUnit) {
            return true;
        }
        return super.isEnabled(selection);
    }
}

