/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.ClassFileInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRange;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.TypeParameterElementInfo;

public class TypeParameter
extends SourceRefElement
implements ITypeParameter {
    static final ITypeParameter[] NO_TYPE_PARAMETERS = new ITypeParameter[0];
    protected String name;

    public TypeParameter(JavaElement parent, String name) {
        super(parent);
        this.name = name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeParameter)) {
            return false;
        }
        return super.equals(o);
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws JavaModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent == null) {
            return;
        }
        JavaElementInfo openableParentInfo = (JavaElementInfo)JavaModelManager.getJavaModelManager().getInfo(openableParent);
        if (openableParentInfo == null) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
        if (openableParent.getElementType() == 6) {
            ClassFileInfo classFileInfo = (ClassFileInfo)(openableParentInfo == null ? newElements.get(openableParent) : openableParentInfo);
            if (classFileInfo == null) {
                return;
            }
            classFileInfo.getBinaryChildren(newElements);
        }
    }

    public String[] getBounds() throws JavaModelException {
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        return CharOperation.toStrings(info.bounds);
    }

    public IMember getDeclaringMember() {
        return (IMember)this.getParent();
    }

    public String getElementName() {
        return this.name;
    }

    public int getElementType() {
        return 15;
    }

    protected char getHandleMementoDelimiter() {
        return ']';
    }

    public ISourceRange getNameRange() throws JavaModelException {
        ClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = (ClassFile)this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getNameRange(this);
        }
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        return new SourceRange(info.nameStart, info.nameEnd - info.nameStart + 1);
    }

    public ISourceRange getSourceRange() throws JavaModelException {
        ClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = (ClassFile)this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getSourceRange(this);
        }
        return super.getSourceRange();
    }

    public IClassFile getClassFile() {
        return ((JavaElement)this.getParent()).getClassFile();
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append('<');
        buffer.append(this.getElementName());
        buffer.append('>');
    }
}

