/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.InstructionPointerManager;
import org.eclipse.debug.internal.ui.contexts.provisional.ISourceDisplayAdapter;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.internal.ui.views.launch.DecorationManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;

public class StackFrameSourceDisplayAdapter
implements ISourceDisplayAdapter {
    private IStackFrame fPrevFrame;
    private SourceLookupResult fPrevResult;
    private SourceLookupJob fSourceLookupJob = new SourceLookupJob();
    private SourceDisplayJob fSourceDisplayJob = new SourceDisplayJob();

    public StackFrameSourceDisplayAdapter() {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    switch (event.getKind()) {
                        case 8: {
                            StackFrameSourceDisplayAdapter.this.clearCachedModel(event.getSource());
                        }
                        case 1: {
                            if (event.isEvaluation()) break;
                            StackFrameSourceDisplayAdapter.this.clearSourceSelection(event.getSource());
                        }
                    }
                    ++i;
                }
            }
        });
    }

    public synchronized void displaySource(Object context, IWorkbenchPage page, boolean force) {
        IStackFrame frame = (IStackFrame)context;
        if (!force && frame.equals(this.fPrevFrame)) {
            this.fPrevResult.updateArtifact(context);
            this.fSourceDisplayJob.setDisplayInfo(this.fPrevResult, page);
            this.fSourceDisplayJob.schedule();
        } else {
            this.fSourceLookupJob.setLookupInfo(frame, frame.getLaunch().getSourceLocator(), page);
            this.fSourceLookupJob.schedule();
        }
    }

    private void clearSourceSelection(Object source) {
        if (source instanceof IThread) {
            IThread thread = (IThread)source;
            DecorationManager.removeDecorations(thread);
            InstructionPointerManager.getDefault().removeAnnotations(thread);
        } else if (source instanceof IDebugTarget) {
            IDebugTarget target = (IDebugTarget)source;
            DecorationManager.removeDecorations(target);
            InstructionPointerManager.getDefault().removeAnnotations(target);
        }
    }

    private synchronized void clearCachedModel(Object source) {
        if (this.fPrevFrame != null) {
            IDebugTarget target = null;
            if (source instanceof IDebugElement) {
                target = ((IDebugElement)source).getDebugTarget();
            }
            if (this.fPrevFrame.getDebugTarget().equals(target)) {
                this.fPrevFrame = null;
                this.fPrevResult = null;
                this.fSourceDisplayJob.cancel();
            }
        }
    }

    class SourceLookupJob
    extends Job {
        private IStackFrame fTarget;
        private ISourceLocator fLocator;
        private IWorkbenchPage fPage;

        public SourceLookupJob() {
            super("Debug Source Lookup");
            this.setPriority(10);
            this.setSystem(true);
        }

        public void setLookupInfo(IStackFrame frame, ISourceLocator locator, IWorkbenchPage page) {
            this.fTarget = frame;
            this.fLocator = locator;
            this.fPage = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                IStackFrame lookupFrame = this.fTarget;
                ISourceLocator lookupLocator = this.fLocator;
                if (lookupFrame != null && lookupLocator != null && !lookupFrame.isTerminated()) {
                    ISourceLookupResult result = null;
                    result = DebugUITools.lookupSource(lookupFrame, lookupLocator);
                    StackFrameSourceDisplayAdapter stackFrameSourceDisplayAdapter = StackFrameSourceDisplayAdapter.this;
                    synchronized (stackFrameSourceDisplayAdapter) {
                        StackFrameSourceDisplayAdapter.this.fPrevResult = (SourceLookupResult)result;
                        StackFrameSourceDisplayAdapter.this.fPrevFrame = lookupFrame;
                    }
                    if (!monitor.isCanceled() && this.fPage != null && !lookupFrame.isTerminated()) {
                        StackFrameSourceDisplayAdapter.this.fSourceDisplayJob.setDisplayInfo(result, this.fPage);
                        StackFrameSourceDisplayAdapter.this.fSourceDisplayJob.schedule();
                    }
                }
                this.setLookupInfo(null, null, null);
            }
            return Status.OK_STATUS;
        }
    }

    class SourceDisplayJob
    extends UIJob {
        private ISourceLookupResult fResult;
        private IWorkbenchPage fPage;

        public SourceDisplayJob() {
            super("Debug Source Display");
            this.setSystem(true);
            this.setPriority(10);
        }

        public synchronized void setDisplayInfo(ISourceLookupResult result, IWorkbenchPage page) {
            this.fResult = result;
            this.fPage = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            ISourceLookupResult result = null;
            IWorkbenchPage page = null;
            SourceDisplayJob sourceDisplayJob = this;
            synchronized (sourceDisplayJob) {
                result = this.fResult;
                page = this.fPage;
                this.setDisplayInfo(null, null);
            }
            if (!monitor.isCanceled() && result != null && page != null) {
                Object artifact;
                DebugUITools.displaySource(result, page);
                if (monitor.isCanceled() && (artifact = result.getArtifact()) instanceof IStackFrame) {
                    StackFrameSourceDisplayAdapter.this.clearSourceSelection(((IStackFrame)artifact).getThread());
                }
            }
            return Status.OK_STATUS;
        }
    }
}

