/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.viewers.provisional.AsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.ui.IWorkbenchPart;

public class VariableContentAdapter
extends AsynchronousContentAdapter {
    protected Object[] getChildren(Object parent, IPresentationContext context) throws CoreException {
        IVariable variable = (IVariable)parent;
        IValue value = variable.getValue();
        if (value != null) {
            return this.getValueChildren((IDebugElement)variable, value, context);
        }
        return EMPTY;
    }

    protected boolean hasChildren(Object element, IPresentationContext context) throws CoreException {
        IValue value = ((IVariable)element).getValue();
        return value.hasVariables();
    }

    protected Object[] getValueChildren(IDebugElement parent, IValue value, IPresentationContext context) throws CoreException {
        IIndexedValue indexedValue;
        int partitionSize;
        if (value == null) {
            return EMPTY;
        }
        IValue logicalValue = this.getLogicalValue(value, context);
        if (logicalValue instanceof IIndexedValue && (partitionSize = this.computeParitionSize(indexedValue = (IIndexedValue)logicalValue)) > 1) {
            int offset = indexedValue.getInitialOffset();
            int length = indexedValue.getSize();
            int numPartitions = length / partitionSize;
            int remainder = length % partitionSize;
            if (remainder > 0) {
                ++numPartitions;
            }
            Object[] partitions = new IVariable[numPartitions];
            int i = 0;
            while (i < numPartitions - 1) {
                partitions[i] = new IndexedVariablePartition(parent, indexedValue, offset, partitionSize);
                offset += partitionSize;
                ++i;
            }
            if (remainder == 0) {
                remainder = partitionSize;
            }
            partitions[numPartitions - 1] = new IndexedVariablePartition(parent, indexedValue, offset, remainder);
            return partitions;
        }
        if (logicalValue == null) {
            logicalValue = value;
        }
        return logicalValue.getVariables();
    }

    protected int computeParitionSize(IIndexedValue value) {
        int partitionSize = 1;
        try {
            int length = value.getSize();
            int partitionDepth = 0;
            int preferredSize = this.getArrayPartitionSize();
            int remainder = length % preferredSize;
            length /= preferredSize;
            while (length > 0) {
                if (remainder == 0 && length == 1) break;
                ++partitionDepth;
                remainder = length % preferredSize;
                length /= preferredSize;
            }
            int i = 0;
            while (i < partitionDepth) {
                partitionSize *= preferredSize;
                ++i;
            }
        }
        catch (DebugException debugException) {}
        return partitionSize;
    }

    protected IValue getLogicalValue(IValue value, IPresentationContext context) {
        return this.getLogicalValue(value, new ArrayList(), context);
    }

    protected IValue getLogicalValue(IValue value, List previousStructureIds, IPresentationContext context) {
        ILogicalStructureType type;
        ILogicalStructureType[] types;
        if (this.isShowLogicalStructure(context) && (types = DebugPlugin.getLogicalStructureTypes((IValue)value)).length > 0 && (type = DebugPlugin.getDefaultStructureType((ILogicalStructureType[])types)) != null && !previousStructureIds.contains(type.getId())) {
            try {
                value = type.getLogicalStructure(value);
                previousStructureIds.add(type.getId());
                return this.getLogicalValue(value, previousStructureIds, context);
            }
            catch (CoreException coreException) {}
        }
        return value;
    }

    protected boolean isShowLogicalStructure(IPresentationContext context) {
        IWorkbenchPart part = context.getPart();
        if (part instanceof VariablesView) {
            return ((VariablesView)part).isShowLogicalStructure();
        }
        return false;
    }

    protected int getArrayPartitionSize() {
        return 100;
    }

    protected boolean supportsPartId(String id) {
        return id.equals("org.eclipse.debug.ui.ExpressionView") || id.equals("org.eclipse.debug.ui.VariableView") || id.equals("org.eclipse.debug.ui.RegisterView");
    }
}

