/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.util.List;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.LaunchShortcutAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class LaunchAsAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    private Menu fCreatedMenu;
    private String fLaunchGroupIdentifier;
    private IAction fAction;

    public LaunchAsAction(String launchGroupIdentifier) {
        this.fLaunchGroupIdentifier = launchGroupIdentifier;
        ILaunchMode launchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.getMode());
        this.setText(launchMode.getLaunchAsLabel());
        this.setMenuCreator(this);
    }

    private LaunchGroupExtension getLaunchGroup() {
        return this.getLaunchConfigurationManager().getLaunchGroup(this.fLaunchGroupIdentifier);
    }

    public void run() {
    }

    private void createAction(Menu parent, IAction action, int count) {
        StringBuffer label = new StringBuffer();
        if (count < 10) {
            label.append('&');
            label.append(count);
            label.append(' ');
        }
        label.append(action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(parent, -1);
    }

    public void dispose() {
        if (this.getCreatedMenu() != null) {
            this.getCreatedMenu().dispose();
        }
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        if (this.getCreatedMenu() != null) {
            this.getCreatedMenu().dispose();
        }
        this.setCreatedMenu(new Menu(parent));
        this.fillMenu();
        this.initMenu();
        return this.getCreatedMenu();
    }

    private void fillMenu() {
        List shortcuts = null;
        String activePerspID = this.getActivePerspectiveID();
        if (activePerspID != null) {
            shortcuts = this.getLaunchConfigurationManager().getLaunchShortcuts(activePerspID, this.getCategory());
        }
        if (shortcuts == null || shortcuts.isEmpty()) {
            shortcuts = this.getLaunchConfigurationManager().getLaunchShortcuts(this.getCategory());
        }
        int menuCount = 1;
        for (LaunchShortcutExtension ext : shortcuts) {
            if (!ext.getModes().contains(this.getMode()) || WorkbenchActivityHelper.filterItem((Object)ext)) continue;
            this.populateMenu(ext, this.getCreatedMenu(), menuCount);
            ++menuCount;
        }
    }

    private void initMenu() {
        this.fCreatedMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                LaunchAsAction.this.fillMenu();
            }
        });
    }

    private void populateMenu(LaunchShortcutExtension ext, Menu menu, int menuCount) {
        LaunchShortcutAction action = new LaunchShortcutAction(this.getMode(), ext);
        action.setActionDefinitionId(String.valueOf(ext.getId()) + "." + this.getMode());
        String helpContextId = ext.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, helpContextId);
        }
        this.createAction(menu, (IAction)action, menuCount);
    }

    private String getActivePerspectiveID() {
        IPerspectiveDescriptor persp;
        IWorkbenchPage page;
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (persp = page.getPerspective()) != null) {
            return persp.getId();
        }
        return null;
    }

    private String getMode() {
        return this.getLaunchGroup().getMode();
    }

    private String getCategory() {
        return this.getLaunchGroup().getCategory();
    }

    private Menu getCreatedMenu() {
        return this.fCreatedMenu;
    }

    private void setCreatedMenu(Menu createdMenu) {
        this.fCreatedMenu = createdMenu;
    }

    private LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fAction == null) {
            this.initialize(action);
        }
    }

    private void initialize(IAction action) {
        this.fAction = action;
        action.setEnabled(this.existsShortcutsForMode());
    }

    private boolean existsShortcutsForMode() {
        List shortcuts = this.getLaunchConfigurationManager().getLaunchShortcuts(this.getCategory());
        for (LaunchShortcutExtension ext : shortcuts) {
            if (!ext.getModes().contains(this.getMode())) continue;
            return true;
        }
        return false;
    }
}

