/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Opcodes;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationMethodFactory
extends MethodFactory
implements Opcodes {
    private static final boolean DEBUG = false;
    private static final String COMPILED_SUPER_CLASS = CodegenUtils.p(CompiledMethod.class);
    private static final String COMPILED_CALL_SIG = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class));
    private static final String COMPILED_CALL_SIG_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class));
    private static final String COMPILED_CALL_SIG_ONE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_ONE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_TWO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_TWO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_THREE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_THREE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
    private static final String JAVA_SUPER_SIG = CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, Visibility.class));
    private static final String JAVA_INDEXED_SUPER_SIG = CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, Visibility.class, Integer.TYPE));
    public static final int THIS_INDEX = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int RECEIVER_INDEX = 2;
    public static final int CLASS_INDEX = 3;
    public static final int NAME_INDEX = 4;
    public static final int ARGS_INDEX = 5;
    public static final int BLOCK_INDEX = 6;
    protected JRubyClassLoader classLoader;
    private boolean seenUndefinedClasses = false;

    public InvocationMethodFactory(ClassLoader classLoader) {
        this.classLoader = classLoader instanceof JRubyClassLoader ? (JRubyClassLoader)classLoader : new JRubyClassLoader(classLoader);
    }

    @Override
    public DynamicMethod getCompiledMethodLazily(RubyModule implementationClass, String method, Arity arity, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        return new CompiledMethod.LazyCompiledMethod(implementationClass, method, arity, visibility, scope, scriptObject, callConfig, new InvocationMethodFactory(this.classLoader));
    }

    @Override
    public DynamicMethod getCompiledMethod(RubyModule implementationClass, String method, Arity arity, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        String sup = COMPILED_SUPER_CLASS;
        Class<?> scriptClass = scriptObject.getClass();
        String mname = scriptClass.getName() + "Invoker" + method + arity;
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class generatedClass = this.tryClass(mname);
            try {
                if (generatedClass == null) {
                    String typePath = CodegenUtils.p(scriptClass);
                    String mnamePath = typePath + "Invoker" + method + arity;
                    ClassWriter cw = this.createCompiledCtor(mnamePath, sup);
                    SkinnyMethodAdapter mv = null;
                    String signature = null;
                    boolean specificArity = false;
                    if (scope.getRestArg() >= 0 || scope.getOptionalArgs() > 0 || scope.getRequiredArgs() > 3) {
                        signature = COMPILED_CALL_SIG_BLOCK;
                        mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", signature, null, null));
                    } else {
                        specificArity = true;
                        mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", COMPILED_CALL_SIG_BLOCK, null, null));
                        mv.start();
                        mv.aload(1);
                        mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                        mv.aload(5);
                        mv.pushInt(scope.getRequiredArgs());
                        mv.pushInt(scope.getRequiredArgs());
                        mv.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
                        mv.pop();
                        mv.aload(0);
                        mv.aload(1);
                        mv.aload(2);
                        mv.aload(3);
                        mv.aload(4);
                        for (int i = 0; i < scope.getRequiredArgs(); ++i) {
                            mv.aload(5);
                            mv.ldc(i);
                            mv.arrayload();
                        }
                        mv.aload(6);
                        switch (scope.getRequiredArgs()) {
                            case 0: {
                                signature = COMPILED_CALL_SIG_ZERO_BLOCK;
                                break;
                            }
                            case 1: {
                                signature = COMPILED_CALL_SIG_ONE_BLOCK;
                                break;
                            }
                            case 2: {
                                signature = COMPILED_CALL_SIG_TWO_BLOCK;
                                break;
                            }
                            case 3: {
                                signature = COMPILED_CALL_SIG_THREE_BLOCK;
                            }
                        }
                        mv.invokevirtual(mnamePath, "call", signature);
                        mv.areturn();
                        mv.end();
                        mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", signature, null, null));
                    }
                    mv.visitCode();
                    Label line = new Label();
                    mv.visitLineNumber(0, line);
                    if (!callConfig.isNoop()) {
                        if (specificArity) {
                            this.invokeCallConfigPre(mv, COMPILED_SUPER_CLASS, scope.getRequiredArgs(), true, callConfig);
                        } else {
                            this.invokeCallConfigPre(mv, COMPILED_SUPER_CLASS, -1, true, callConfig);
                        }
                    }
                    Label tryBegin = new Label();
                    Label tryEnd = new Label();
                    Label doFinally = new Label();
                    Label doReturnFinally = new Label();
                    Label doRedoFinally = new Label();
                    Label catchReturnJump = new Label();
                    Label catchRedoJump = new Label();
                    if (callConfig != CallConfiguration.FRAME_ONLY) {
                        mv.trycatch(tryBegin, tryEnd, catchReturnJump, CodegenUtils.p(JumpException.ReturnJump.class));
                    }
                    mv.trycatch(tryBegin, tryEnd, catchRedoJump, CodegenUtils.p(JumpException.RedoJump.class));
                    mv.trycatch(tryBegin, tryEnd, doFinally, null);
                    if (callConfig != CallConfiguration.FRAME_ONLY) {
                        mv.trycatch(catchReturnJump, doReturnFinally, doFinally, null);
                    }
                    mv.trycatch(catchRedoJump, doRedoFinally, doFinally, null);
                    mv.label(tryBegin);
                    mv.aload(0);
                    mv.getfield(mnamePath, "$scriptObject", CodegenUtils.ci(Object.class));
                    mv.checkcast(typePath);
                    mv.aload(1);
                    mv.aload(2);
                    if (specificArity) {
                        for (int i = 0; i < scope.getRequiredArgs(); ++i) {
                            mv.aload(5 + i);
                        }
                        mv.aload(5 + scope.getRequiredArgs());
                        mv.invokevirtual(typePath, method, StandardASMCompiler.METHOD_SIGNATURES[scope.getRequiredArgs()]);
                    } else {
                        mv.aload(5);
                        mv.aload(6);
                        mv.invokevirtual(typePath, method, StandardASMCompiler.METHOD_SIGNATURES[4]);
                    }
                    mv.label(tryEnd);
                    if (!callConfig.isNoop()) {
                        this.invokeCallConfigPost(mv, COMPILED_SUPER_CLASS, callConfig);
                    }
                    mv.visitInsn(176);
                    if (callConfig != CallConfiguration.FRAME_ONLY) {
                        mv.label(catchReturnJump);
                        mv.aload(0);
                        mv.swap();
                        mv.aload(1);
                        mv.swap();
                        mv.invokevirtual(COMPILED_SUPER_CLASS, "handleReturn", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, JumpException.ReturnJump.class));
                        mv.label(doReturnFinally);
                        if (!callConfig.isNoop()) {
                            this.invokeCallConfigPost(mv, COMPILED_SUPER_CLASS, callConfig);
                        }
                        mv.areturn();
                    }
                    mv.label(catchRedoJump);
                    mv.pop();
                    mv.aload(1);
                    mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                    mv.invokevirtual(CodegenUtils.p(Ruby.class), "newRedoLocalJumpError", CodegenUtils.sig(RaiseException.class, new Class[0]));
                    mv.label(doRedoFinally);
                    if (!callConfig.isNoop()) {
                        this.invokeCallConfigPost(mv, COMPILED_SUPER_CLASS, callConfig);
                    }
                    mv.athrow();
                    mv.label(doFinally);
                    if (!callConfig.isNoop()) {
                        this.invokeCallConfigPost(mv, COMPILED_SUPER_CLASS, callConfig);
                    }
                    mv.athrow();
                    generatedClass = this.endCall(cw, mv, mname);
                }
                CompiledMethod compiledMethod = (CompiledMethod)generatedClass.newInstance();
                compiledMethod.init(implementationClass, arity, visibility, scope, scriptObject, callConfig);
                return compiledMethod;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw implementationClass.getRuntime().newLoadError(e.getMessage());
            }
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, List<JavaMethodDescriptor> descs) {
        JavaMethodDescriptor desc1 = descs.get(0);
        String javaMethodName = desc1.name;
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            try {
                Class c = this.getAnnotatedMethodClass(descs);
                int min = Integer.MAX_VALUE;
                int max = 0;
                boolean frame = false;
                boolean scope = false;
                boolean backtrace = false;
                for (JavaMethodDescriptor desc : descs) {
                    int specificArity = -1;
                    if (desc.optional == 0 && !desc.rest) {
                        if (desc.required == 0) {
                            specificArity = desc.actualRequired <= 3 ? desc.actualRequired : -1;
                        } else if (desc.required >= 0 && desc.required <= 3) {
                            specificArity = desc.required;
                        }
                    }
                    if (specificArity < min) {
                        min = specificArity;
                    }
                    if (specificArity > max) {
                        max = specificArity;
                    }
                    frame |= desc.anno.frame();
                    scope |= desc.anno.scope();
                    backtrace |= desc.anno.backtrace();
                }
                JavaMethod ic = (JavaMethod)c.getConstructor(RubyModule.class, Visibility.class).newInstance(new Object[]{implementationClass, desc1.anno.visibility()});
                ic.setArity(Arity.OPTIONAL);
                ic.setJavaName(javaMethodName);
                ic.setSingleton(desc1.isStatic);
                ic.setCallConfig(CallConfiguration.getCallConfig(frame, scope, backtrace));
                return ic;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw implementationClass.getRuntime().newLoadError(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getAnnotatedMethodClass(List<JavaMethodDescriptor> descs) throws Exception {
        if (descs.size() == 1) {
            return this.getAnnotatedMethodClass(descs.get(0));
        }
        JavaMethodDescriptor desc1 = descs.get(0);
        String javaMethodName = desc1.name;
        String generatedClassName = CodegenUtils.getAnnotatedBindingClassName(javaMethodName, desc1.declaringClassName, desc1.isStatic, desc1.actualRequired, desc1.optional, true);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            generatedClassName = generatedClassName + "_DBG";
        }
        String generatedClassPath = generatedClassName.replace('.', '/');
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(generatedClassName);
            int min = Integer.MAX_VALUE;
            int max = 0;
            boolean block = false;
            for (JavaMethodDescriptor desc : descs) {
                int specificArity = -1;
                if (desc.optional == 0 && !desc.rest) {
                    if (desc.required == 0) {
                        specificArity = desc.actualRequired <= 3 ? desc.actualRequired : -1;
                    } else if (desc.required >= 0 && desc.required <= 3) {
                        specificArity = desc.required;
                    }
                }
                if (specificArity < min) {
                    min = specificArity;
                }
                if (specificArity > max) {
                    max = specificArity;
                }
                block |= desc.hasBlock;
            }
            if (c == null) {
                String superClass = null;
                switch (min) {
                    case 0: {
                        switch (max) {
                            case 1: {
                                if (block) {
                                    superClass = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneBlock.class);
                                    break;
                                }
                                superClass = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOne.class);
                                break;
                            }
                            case 2: {
                                if (block) {
                                    superClass = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwoBlock.class);
                                    break;
                                }
                                superClass = CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwo.class);
                                break;
                            }
                            case 3: {
                                superClass = block ? CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwoOrThreeBlock.class) : CodegenUtils.p(JavaMethod.JavaMethodZeroOrOneOrTwoOrThree.class);
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (max) {
                            case 2: {
                                if (block) {
                                    superClass = CodegenUtils.p(JavaMethod.JavaMethodOneOrTwoBlock.class);
                                    break;
                                }
                                superClass = CodegenUtils.p(JavaMethod.JavaMethodOneOrTwo.class);
                                break;
                            }
                            case 3: {
                                superClass = block ? CodegenUtils.p(JavaMethod.JavaMethodOneOrTwoOrThreeBlock.class) : CodegenUtils.p(JavaMethod.JavaMethodOneOrTwoOrThree.class);
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (max) {
                            case 3: {
                                superClass = CodegenUtils.p(JavaMethod.JavaMethodTwoOrThree.class);
                            }
                        }
                        break;
                    }
                    case -1: {
                        superClass = CodegenUtils.p(JavaMethod.JavaMethodNoBlock.class);
                    }
                }
                if (superClass == null) {
                    throw new RuntimeException("invalid multi combination");
                }
                ClassWriter cw = this.createJavaMethodCtor(generatedClassPath, superClass);
                for (JavaMethodDescriptor desc : descs) {
                    int specificArity = -1;
                    if (desc.optional == 0 && !desc.rest) {
                        if (desc.required == 0) {
                            specificArity = desc.actualRequired <= 3 ? desc.actualRequired : -1;
                        } else if (desc.required >= 0 && desc.required <= 3) {
                            specificArity = desc.required;
                        }
                    }
                    boolean hasBlock = desc.hasBlock;
                    SkinnyMethodAdapter mv = null;
                    mv = this.beginMethod(cw, "call", specificArity, hasBlock);
                    mv.visitCode();
                    Label line = new Label();
                    mv.visitLineNumber(0, line);
                    this.createAnnotatedMethodInvocation(desc, mv, superClass, specificArity, hasBlock);
                    this.endMethod(mv);
                }
                c = this.endClass(cw, generatedClassName);
            }
            return c;
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, JavaMethodDescriptor desc) {
        String javaMethodName = desc.name;
        String generatedClassName = CodegenUtils.getAnnotatedBindingClassName(javaMethodName, desc.declaringClassName, desc.isStatic, desc.actualRequired, desc.optional, false);
        String generatedClassPath = generatedClassName.replace('.', '/');
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            try {
                Class c = this.getAnnotatedMethodClass(desc);
                JavaMethod ic = (JavaMethod)c.getConstructor(RubyModule.class, Visibility.class).newInstance(new Object[]{implementationClass, desc.anno.visibility()});
                ic.setArity(Arity.fromAnnotation(desc.anno, desc.actualRequired));
                ic.setJavaName(javaMethodName);
                ic.setSingleton(desc.isStatic);
                ic.setCallConfig(CallConfiguration.getCallConfigByAnno(desc.anno));
                return ic;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw implementationClass.getRuntime().newLoadError(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getAnnotatedMethodClass(JavaMethodDescriptor desc) throws Exception {
        String javaMethodName = desc.name;
        String generatedClassName = CodegenUtils.getAnnotatedBindingClassName(javaMethodName, desc.declaringClassName, desc.isStatic, desc.actualRequired, desc.optional, false);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            generatedClassName = generatedClassName + "_DBG";
        }
        String generatedClassPath = generatedClassName.replace('.', '/');
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(generatedClassName);
            if (c == null) {
                int specificArity = -1;
                if (desc.optional == 0 && !desc.rest) {
                    if (desc.required == 0) {
                        specificArity = desc.actualRequired <= 3 ? desc.actualRequired : -1;
                    } else if (desc.required >= 0 && desc.required <= 3) {
                        specificArity = desc.required;
                    }
                }
                boolean block = desc.hasBlock;
                String superClass = CodegenUtils.p(this.selectSuperClass(specificArity, block));
                ClassWriter cw = this.createJavaMethodCtor(generatedClassPath, superClass);
                SkinnyMethodAdapter mv = null;
                mv = this.beginMethod(cw, "call", specificArity, block);
                mv.visitCode();
                Label line = new Label();
                mv.visitLineNumber(0, line);
                this.createAnnotatedMethodInvocation(desc, mv, superClass, specificArity, block);
                this.endMethod(mv);
                c = this.endClass(cw, generatedClassName);
            }
            return c;
        }
    }

    public void prepareAnnotatedMethod(RubyModule implementationClass, JavaMethod javaMethod, JavaMethodDescriptor desc) {
        String javaMethodName = desc.name;
        javaMethod.setArity(Arity.fromAnnotation(desc.anno, desc.actualRequired));
        javaMethod.setJavaName(javaMethodName);
        javaMethod.setSingleton(desc.isStatic);
        javaMethod.setCallConfig(CallConfiguration.getCallConfigByAnno(desc.anno));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineIndexedAnnotatedMethods(RubyModule implementationClass, Class type, MethodFactory.MethodDefiningCallback callback) {
        String typePath = CodegenUtils.p(type);
        String superClass = CodegenUtils.p(JavaMethod.class);
        String generatedClassName = type.getName() + "Invoker";
        String generatedClassPath = typePath + "Invoker";
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(generatedClassName);
            try {
                JRubyMethod jrubyMethod;
                Method[] methods;
                ArrayList<Method> annotatedMethods = new ArrayList<Method>();
                for (Method method : methods = type.getDeclaredMethods()) {
                    jrubyMethod = method.getAnnotation(JRubyMethod.class);
                    if (jrubyMethod == null) continue;
                    annotatedMethods.add(method);
                }
                ArrayList sortedMethods = new ArrayList(annotatedMethods);
                Collections.sort(sortedMethods, new Comparator<Method>(){

                    @Override
                    public int compare(Method a, Method b) {
                        return a.getName().compareTo(b.getName());
                    }
                });
                HashMap indexMap = new HashMap();
                for (int index = 0; index < sortedMethods.size(); ++index) {
                    indexMap.put(sortedMethods.get(index), index);
                }
                if (c == null) {
                    int i;
                    ClassWriter cw = this.createIndexedJavaMethodCtor(generatedClassPath, superClass);
                    SkinnyMethodAdapter mv = null;
                    mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", COMPILED_CALL_SIG_BLOCK, null, null));
                    mv.visitCode();
                    Label line = new Label();
                    mv.visitLineNumber(0, line);
                    Label defaultCase = new Label();
                    Label[] cases = new Label[sortedMethods.size()];
                    for (i = 0; i < cases.length; ++i) {
                        cases[i] = new Label();
                    }
                    mv.aload(0);
                    mv.getfield(generatedClassPath, "methodIndex", CodegenUtils.ci(Integer.TYPE));
                    mv.tableswitch(0, cases.length - 1, defaultCase, cases);
                    for (i = 0; i < sortedMethods.size(); ++i) {
                        mv.label(cases[i]);
                        String callName = this.getAnnotatedMethodForIndex(cw, (Method)sortedMethods.get(i), i, superClass);
                        mv.aload(0);
                        mv.aload(1);
                        mv.aload(2);
                        mv.aload(3);
                        mv.aload(4);
                        mv.aload(5);
                        mv.aload(6);
                        mv.invokevirtual(generatedClassPath, callName, COMPILED_CALL_SIG_BLOCK);
                        mv.areturn();
                    }
                    mv.label(defaultCase);
                    mv.aload(1);
                    mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                    mv.ldc("Error: fell off switched invoker for class: " + implementationClass.getBaseName());
                    mv.invokevirtual(CodegenUtils.p(Ruby.class), "newRuntimeError", CodegenUtils.sig(RaiseException.class, String.class));
                    mv.athrow();
                    c = this.endCall(cw, mv, generatedClassName);
                }
                for (int i = 0; i < annotatedMethods.size(); ++i) {
                    Method method;
                    method = (Method)annotatedMethods.get(i);
                    jrubyMethod = method.getAnnotation(JRubyMethod.class);
                    if (jrubyMethod.frame()) {
                        for (String name : jrubyMethod.name()) {
                            ASTInspector.FRAME_AWARE_METHODS.add(name);
                        }
                    }
                    int index = (Integer)indexMap.get(method);
                    JavaMethod ic = (JavaMethod)c.getConstructor(RubyModule.class, Visibility.class, Integer.TYPE).newInstance(new Object[]{implementationClass, jrubyMethod.visibility(), index});
                    ic.setArity(Arity.fromAnnotation(jrubyMethod));
                    ic.setJavaName(method.getName());
                    ic.setSingleton(Modifier.isStatic(method.getModifiers()));
                    ic.setCallConfig(CallConfiguration.getCallConfigByAnno(jrubyMethod));
                    callback.define(implementationClass, new JavaMethodDescriptor(method), ic);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw implementationClass.getRuntime().newLoadError(e.getMessage());
            }
        }
    }

    private void checkArity(SkinnyMethodAdapter method, StaticScope scope) {
        Label arityError = new Label();
        Label noArityError = new Label();
        if (scope.getRestArg() >= 0) {
            if (scope.getRequiredArgs() > 0) {
                method.aload(5);
                method.arraylength();
                method.ldc(scope.getRequiredArgs());
                method.if_icmplt(arityError);
            }
        } else if (scope.getOptionalArgs() > 0) {
            if (scope.getRequiredArgs() > 0) {
                method.aload(5);
                method.arraylength();
                method.ldc(scope.getRequiredArgs());
                method.if_icmplt(arityError);
            }
            method.aload(5);
            method.arraylength();
            method.ldc(scope.getRequiredArgs() + scope.getOptionalArgs());
            method.if_icmpgt(arityError);
        } else {
            method.aload(5);
            method.arraylength();
            method.ldc(scope.getRequiredArgs());
            method.if_icmpne(arityError);
        }
        method.go_to(noArityError);
        method.label(arityError);
        method.aload(1);
        method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        method.aload(5);
        method.ldc(scope.getRequiredArgs());
        method.ldc(scope.getRequiredArgs() + scope.getOptionalArgs());
        method.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
        method.pop();
        method.label(noArityError);
    }

    private void checkArity(JRubyMethod jrubyMethod, SkinnyMethodAdapter method, int specificArity) {
        Label arityError = new Label();
        Label noArityError = new Label();
        switch (specificArity) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        if (jrubyMethod.rest()) {
            if (jrubyMethod.required() > 0) {
                method.aload(5);
                method.arraylength();
                method.ldc(jrubyMethod.required());
                method.if_icmplt(arityError);
            }
        } else if (jrubyMethod.optional() > 0) {
            if (jrubyMethod.required() > 0) {
                method.aload(5);
                method.arraylength();
                method.ldc(jrubyMethod.required());
                method.if_icmplt(arityError);
            }
            method.aload(5);
            method.arraylength();
            method.ldc(jrubyMethod.required() + jrubyMethod.optional());
            method.if_icmpgt(arityError);
        } else {
            method.aload(5);
            method.arraylength();
            method.ldc(jrubyMethod.required());
            method.if_icmpne(arityError);
        }
        method.go_to(noArityError);
        method.label(arityError);
        method.aload(1);
        method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        method.aload(5);
        method.ldc(jrubyMethod.required());
        method.ldc(jrubyMethod.required() + jrubyMethod.optional());
        method.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
        method.pop();
        method.label(noArityError);
    }

    private ClassWriter createCompiledCtor(String namePath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, namePath, null, sup, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, sup, "<init>", "()V");
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createJavaMethodCtor(String namePath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, namePath, null, sup, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", JAVA_SUPER_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, sup, "<init>", JAVA_SUPER_SIG);
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createIndexedJavaMethodCtor(String namePath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, namePath, null, sup, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", JAVA_INDEXED_SUPER_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(21, 3);
        mv.visitMethodInsn(183, sup, "<init>", JAVA_INDEXED_SUPER_SIG);
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private void invokeCallConfigPost(SkinnyMethodAdapter mv, String superClass, CallConfiguration callConfig) {
        if (callConfig != CallConfiguration.NO_FRAME_NO_SCOPE) {
            mv.aload(0);
            mv.aload(1);
            if (callConfig == CallConfiguration.FRAME_AND_SCOPE) {
                mv.invokevirtual(superClass, "postFrameAndScope", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            } else if (callConfig == CallConfiguration.FRAME_ONLY) {
                mv.invokevirtual(superClass, "postFrameOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            } else if (callConfig == CallConfiguration.SCOPE_ONLY) {
                mv.invokevirtual(superClass, "postScopeOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            } else if (callConfig == CallConfiguration.BACKTRACE_ONLY) {
                mv.invokevirtual(superClass, "postBacktraceOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            } else if (callConfig == CallConfiguration.BACKTRACE_AND_SCOPE) {
                mv.invokevirtual(superClass, "postBacktraceAndScope", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            }
        }
    }

    private void invokeCallConfigPre(SkinnyMethodAdapter mv, String superClass, int specificArity, boolean block, CallConfiguration callConfig) {
        if (callConfig != CallConfiguration.NO_FRAME_NO_SCOPE) {
            mv.aload(0);
            mv.aload(1);
            if (callConfig == CallConfiguration.FRAME_AND_SCOPE) {
                mv.aload(2);
                mv.aload(4);
                this.loadBlockForPre(mv, specificArity, block);
                mv.invokevirtual(superClass, "preFrameAndScope", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, Block.class)));
            } else if (callConfig == CallConfiguration.FRAME_ONLY) {
                mv.aload(2);
                mv.aload(4);
                this.loadBlockForPre(mv, specificArity, block);
                mv.invokevirtual(superClass, "preFrameOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, Block.class)));
            } else if (callConfig == CallConfiguration.SCOPE_ONLY) {
                mv.invokevirtual(superClass, "preScopeOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
            } else if (callConfig == CallConfiguration.BACKTRACE_ONLY) {
                mv.aload(4);
                mv.invokevirtual(superClass, "preBacktraceOnly", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class)));
            } else if (callConfig == CallConfiguration.BACKTRACE_AND_SCOPE) {
                mv.aload(4);
                mv.invokevirtual(superClass, "preBacktraceAndScope", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class)));
            }
        }
    }

    private void loadArguments(SkinnyMethodAdapter mv, JRubyMethod jrubyMethod, int specificArity) {
        switch (specificArity) {
            default: {
                mv.aload(5);
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                mv.aload(5);
                break;
            }
            case 2: {
                mv.aload(5);
                mv.aload(6);
                break;
            }
            case 3: {
                mv.aload(5);
                mv.aload(6);
                mv.aload(7);
            }
        }
    }

    private void loadBlockForPre(SkinnyMethodAdapter mv, int specificArity, boolean getsBlock) {
        switch (specificArity) {
            default: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 6);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 0: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 5);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 1: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 6);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 2: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 7);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 3: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 8);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            }
        }
    }

    private void loadBlock(SkinnyMethodAdapter mv, int specificArity, boolean getsBlock) {
        switch (specificArity) {
            default: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 6);
                break;
            }
            case 0: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 5);
                break;
            }
            case 1: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 6);
                break;
            }
            case 2: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 7);
                break;
            }
            case 3: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 8);
            }
        }
    }

    private void loadReceiver(String typePath, JavaMethodDescriptor desc, SkinnyMethodAdapter mv) {
        if (Modifier.isStatic(desc.modifiers)) {
            if (desc.hasContext) {
                mv.aload(1);
            }
            mv.aload(2);
        } else {
            mv.aload(2);
            mv.checkcast(typePath);
            if (desc.hasContext) {
                mv.aload(1);
            }
        }
    }

    private Class tryClass(String name) {
        try {
            Class<?> c = null;
            c = this.classLoader == null ? Class.forName(name, true, this.classLoader) : this.classLoader.loadClass(name);
            if (c != null && this.seenUndefinedClasses) {
                System.err.println("WARNING: while creating new bindings, found an existing binding; likely a collision: " + name);
                Thread.dumpStack();
            }
            return c;
        }
        catch (Exception e) {
            this.seenUndefinedClasses = true;
            return null;
        }
    }

    protected Class endCall(ClassWriter cw, MethodVisitor mv, String name) {
        this.endMethod(mv);
        return this.endClass(cw, name);
    }

    protected void endMethod(MethodVisitor mv) {
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected Class endClass(ClassWriter cw, String name) {
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        return this.classLoader.defineClass(name, code);
    }

    private void loadArgument(MethodVisitor mv, int argsIndex, int argIndex) {
        mv.visitVarInsn(25, argsIndex);
        mv.visitLdcInsn(new Integer(argIndex));
        mv.visitInsn(50);
    }

    private SkinnyMethodAdapter beginMethod(ClassWriter cw, String methodName, int specificArity, boolean block) {
        switch (specificArity) {
            default: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG, null, null));
            }
            case 0: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ZERO_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ZERO, null, null));
            }
            case 1: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ONE_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ONE, null, null));
            }
            case 2: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_TWO_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_TWO, null, null));
            }
            case 3: 
        }
        if (block) {
            return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_THREE_BLOCK, null, null));
        }
        return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_THREE, null, null));
    }

    private Class selectSuperClass(int specificArity, boolean block) {
        switch (specificArity) {
            default: {
                if (block) {
                    return JavaMethod.class;
                }
                return JavaMethod.JavaMethodNoBlock.class;
            }
            case 0: {
                if (block) {
                    return JavaMethod.JavaMethodZeroBlock.class;
                }
                return JavaMethod.JavaMethodZero.class;
            }
            case 1: {
                if (block) {
                    return JavaMethod.JavaMethodOneBlock.class;
                }
                return JavaMethod.JavaMethodOne.class;
            }
            case 2: {
                if (block) {
                    return JavaMethod.JavaMethodTwoBlock.class;
                }
                return JavaMethod.JavaMethodTwo.class;
            }
            case 3: 
        }
        if (block) {
            return JavaMethod.JavaMethodThreeBlock.class;
        }
        return JavaMethod.JavaMethodThree.class;
    }

    private String getAnnotatedMethodForIndex(ClassWriter cw, Method method, int index, String superClass) {
        String methodName = "call" + index + "_" + method.getName();
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_BLOCK, null, null));
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        this.createAnnotatedMethodInvocation(new JavaMethodDescriptor(method), mv, superClass, -1, true);
        this.endMethod(mv);
        return methodName;
    }

    private void createAnnotatedMethodInvocation(JavaMethodDescriptor desc, SkinnyMethodAdapter method, String superClass, int specificArity, boolean block) {
        String typePath = desc.declaringClassPath;
        String javaMethodName = desc.name;
        this.checkArity(desc.anno, method, specificArity);
        CallConfiguration callConfig = CallConfiguration.getCallConfigByAnno(desc.anno);
        if (!callConfig.isNoop()) {
            this.invokeCallConfigPre(method, superClass, specificArity, block, callConfig);
        }
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.invokeCCallTrace(method);
        }
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label doFinally = new Label();
        Label doRedoFinally = new Label();
        Label catchRedoJump = new Label();
        if (!callConfig.isNoop()) {
            method.trycatch(tryBegin, tryEnd, doFinally, null);
        }
        method.label(tryBegin);
        this.loadReceiver(typePath, desc, method);
        this.loadArguments(method, desc.anno, specificArity);
        this.loadBlock(method, specificArity, block);
        if (Modifier.isStatic(desc.modifiers)) {
            method.invokestatic(typePath, javaMethodName, desc.signature);
        } else {
            method.invokevirtual(typePath, javaMethodName, desc.signature);
        }
        method.label(tryEnd);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.invokeCReturnTrace(method);
        }
        if (!callConfig.isNoop()) {
            this.invokeCallConfigPost(method, superClass, callConfig);
        }
        method.visitInsn(176);
        if (!callConfig.isNoop()) {
            method.label(doFinally);
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                this.invokeCReturnTrace(method);
            }
            if (!callConfig.isNoop()) {
                this.invokeCallConfigPost(method, superClass, callConfig);
            }
            method.athrow();
        }
    }

    private void invokeCCallTrace(SkinnyMethodAdapter method) {
        method.aload(0);
        method.aload(1);
        method.aload(4);
        method.invokevirtual(CodegenUtils.p(JavaMethod.class), "callTrace", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String.class));
    }

    private void invokeCReturnTrace(SkinnyMethodAdapter method) {
        method.aload(0);
        method.aload(1);
        method.aload(4);
        method.invokevirtual(CodegenUtils.p(JavaMethod.class), "returnTrace", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String.class));
    }
}

