/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.libraries.FiberLibrary;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public final class ThreadContext {
    private static final int INITIAL_SIZE = 50;
    private final Ruby runtime;
    private boolean isWithinTrace;
    private boolean isWithinDefined;
    private RubyThread thread;
    private FiberLibrary.Fiber fiber;
    private IRubyObject errorInfo;
    private RubyModule[] parentStack = new RubyModule[50];
    private int parentIndex = -1;
    private Frame[] frameStack = new Frame[50];
    private int frameIndex = -1;
    private DynamicScope[] scopeStack = new DynamicScope[50];
    private int scopeIndex = -1;
    private RubyKernel.CatchTarget[] catchStack = new RubyKernel.CatchTarget[50];
    private int catchIndex = -1;
    private String file = "";
    private int line = 0;
    private int rubyFrameDelta = 0;
    CallType lastCallType;
    Visibility lastVisibility;
    IRubyObject lastExitStatus;
    int calls = 0;

    public static synchronized ThreadContext newContext(Ruby runtime) {
        ThreadContext context = new ThreadContext(runtime);
        return context;
    }

    private ThreadContext(Ruby runtime) {
        this.runtime = runtime;
        this.errorInfo = runtime.getNil();
        LocalStaticScope topStaticScope = new LocalStaticScope(null);
        this.pushScope(new ManyVarsDynamicScope(topStaticScope, null));
        for (int i = 0; i < this.frameStack.length; ++i) {
            this.frameStack[i] = new Frame();
        }
    }

    protected void finalize() throws Throwable {
        this.thread.dispose();
    }

    public final Ruby getRuntime() {
        return this.runtime;
    }

    public IRubyObject getErrorInfo() {
        return this.errorInfo;
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.errorInfo = errorInfo;
        return errorInfo;
    }

    public JumpException.ReturnJump returnJump(IRubyObject value) {
        return new JumpException.ReturnJump(this.getFrameJumpTarget(), value);
    }

    public void setLastCallStatus(CallType callType) {
        this.lastCallType = callType;
    }

    public CallType getLastCallType() {
        return this.lastCallType;
    }

    public void setLastVisibility(Visibility visibility) {
        this.lastVisibility = visibility;
    }

    public Visibility getLastVisibility() {
        return this.lastVisibility;
    }

    public IRubyObject getLastExitStatus() {
        return this.lastExitStatus;
    }

    public void setLastExitStatus(IRubyObject lastExitStatus) {
        this.lastExitStatus = lastExitStatus;
    }

    public void printScope() {
        System.out.println("SCOPE STACK:");
        for (int i = 0; i <= this.scopeIndex; ++i) {
            System.out.println(this.scopeStack[i]);
        }
    }

    public DynamicScope getCurrentScope() {
        return this.scopeStack[this.scopeIndex];
    }

    public DynamicScope getPreviousScope() {
        return this.scopeStack[this.scopeIndex - 1];
    }

    private void expandFramesIfNecessary() {
        int newSize = this.frameStack.length * 2;
        this.frameStack = this.fillNewFrameStack(new Frame[newSize], newSize);
    }

    private Frame[] fillNewFrameStack(Frame[] newFrameStack, int newSize) {
        System.arraycopy(this.frameStack, 0, newFrameStack, 0, this.frameStack.length);
        for (int i = this.frameStack.length; i < newSize; ++i) {
            newFrameStack[i] = new Frame();
        }
        return newFrameStack;
    }

    private void expandParentsIfNecessary() {
        int newSize = this.parentStack.length * 2;
        RubyModule[] newParentStack = new RubyModule[newSize];
        System.arraycopy(this.parentStack, 0, newParentStack, 0, this.parentStack.length);
        this.parentStack = newParentStack;
    }

    public void pushScope(DynamicScope scope) {
        this.scopeStack[++this.scopeIndex] = scope;
        if (this.scopeIndex + 1 == this.scopeStack.length) {
            this.expandScopesIfNecessary();
        }
    }

    public void popScope() {
        this.scopeStack[this.scopeIndex--] = null;
    }

    private void expandScopesIfNecessary() {
        int newSize = this.scopeStack.length * 2;
        DynamicScope[] newScopeStack = new DynamicScope[newSize];
        System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
        this.scopeStack = newScopeStack;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public void setThread(RubyThread thread) {
        this.thread = thread;
    }

    public FiberLibrary.Fiber getFiber() {
        return this.fiber;
    }

    public void setFiber(FiberLibrary.Fiber fiber) {
        this.fiber = fiber;
    }

    private void expandCatchIfNecessary() {
        int newSize = this.catchStack.length * 2;
        RubyKernel.CatchTarget[] newCatchStack = new RubyKernel.CatchTarget[newSize];
        System.arraycopy(this.catchStack, 0, newCatchStack, 0, this.catchStack.length);
        this.catchStack = newCatchStack;
    }

    public void pushCatch(RubyKernel.CatchTarget catchTarget) {
        this.catchStack[++this.catchIndex] = catchTarget;
        if (this.catchIndex + 1 == this.catchStack.length) {
            this.expandCatchIfNecessary();
        }
    }

    public void popCatch() {
        --this.catchIndex;
    }

    public RubyKernel.CatchTarget[] getActiveCatches() {
        if (this.catchIndex < 0) {
            return new RubyKernel.CatchTarget[0];
        }
        RubyKernel.CatchTarget[] activeCatches = new RubyKernel.CatchTarget[this.catchIndex + 1];
        System.arraycopy(this.catchStack, 0, activeCatches, 0, this.catchIndex + 1);
        return activeCatches;
    }

    private void pushFrameCopy() {
        Frame currentFrame = this.getCurrentFrame();
        this.frameStack[++this.frameIndex].updateFrame(currentFrame);
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private Frame pushFrameCopy(Frame frame) {
        this.frameStack[++this.frameIndex].updateFrame(frame);
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
        return this.frameStack[this.frameIndex];
    }

    private Frame pushFrame(Frame frame) {
        this.frameStack[++this.frameIndex] = frame;
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
        return frame;
    }

    private void pushCallFrame(RubyModule clazz, String name, IRubyObject self, Block block, JumpTarget jumpTarget) {
        this.frameStack[++this.frameIndex].updateFrame(clazz, self, name, block, this.file, this.line, jumpTarget);
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushBacktraceFrame(String name) {
        this.pushFrame(name);
    }

    private void pushFrame(String name) {
        this.frameStack[++this.frameIndex].updateFrame(name, this.file, this.line);
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushFrame() {
        this.frameStack[++this.frameIndex].updateFrame(this.file, this.line);
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void popFrame() {
        Frame frame = this.frameStack[this.frameIndex];
        --this.frameIndex;
        this.setFile(frame.getFile());
        this.setLine(frame.getLine());
        frame.clear();
    }

    private void popFrameReal(Frame oldFrame) {
        Frame frame = this.frameStack[this.frameIndex];
        this.frameStack[this.frameIndex] = oldFrame;
        --this.frameIndex;
        this.setFile(frame.getFile());
        this.setLine(frame.getLine());
    }

    public Frame getCurrentFrame() {
        return this.frameStack[this.frameIndex];
    }

    public int getRubyFrameDelta() {
        return this.rubyFrameDelta;
    }

    public void setRubyFrameDelta(int newDelta) {
        this.rubyFrameDelta = newDelta;
    }

    public Frame getCurrentRubyFrame() {
        return this.frameStack[this.frameIndex - this.rubyFrameDelta];
    }

    public Frame getNextFrame() {
        if (this.frameIndex + 1 == this.frameStack.length) {
            this.expandFramesIfNecessary();
        }
        return this.frameStack[this.frameIndex + 1];
    }

    public Frame getPreviousFrame() {
        return this.frameIndex < 1 ? null : this.frameStack[this.frameIndex - 1];
    }

    public int getFrameCount() {
        return this.frameIndex + 1;
    }

    public String getFrameName() {
        return this.getCurrentFrame().getName();
    }

    public IRubyObject getFrameSelf() {
        return this.getCurrentFrame().getSelf();
    }

    public JumpTarget getFrameJumpTarget() {
        return this.getCurrentFrame().getJumpTarget();
    }

    @Deprecated
    public void setFrameJumpTarget(JumpTarget target) {
    }

    public RubyModule getFrameKlazz() {
        return this.getCurrentFrame().getKlazz();
    }

    public Block getFrameBlock() {
        return this.getCurrentFrame().getBlock();
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setFileAndLine(String file, int line) {
        this.file = file;
        this.line = line;
    }

    public Visibility getCurrentVisibility() {
        return this.getCurrentFrame().getVisibility();
    }

    public Visibility getPreviousVisibility() {
        return this.getPreviousFrame().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.getCurrentFrame().setVisibility(visibility);
    }

    public void pollThreadEvents() {
        this.getThread().pollThreadEvents(this);
    }

    public void callThreadPoll() {
        if ((this.calls++ & 0xFF) == 0) {
            this.pollThreadEvents();
        }
    }

    public void trace(int event, String name, RubyModule implClass) {
        this.runtime.callEventHooks(this, event, this.file, this.line, name, implClass);
    }

    public void pushRubyClass(RubyModule currentModule) {
        this.parentStack[++this.parentIndex] = currentModule;
        if (this.parentIndex + 1 == this.parentStack.length) {
            this.expandParentsIfNecessary();
        }
    }

    public RubyModule popRubyClass() {
        RubyModule ret = this.parentStack[this.parentIndex];
        this.parentStack[this.parentIndex--] = null;
        return ret;
    }

    public RubyModule getRubyClass() {
        assert (this.parentIndex != -1) : "Trying to get RubyClass from empty stack";
        RubyModule parentModule = this.parentStack[this.parentIndex];
        return parentModule.getNonIncludedClass();
    }

    public RubyModule getBindingRubyClass() {
        RubyModule parentModule = null;
        parentModule = this.parentIndex == 0 ? this.parentStack[this.parentIndex] : this.parentStack[this.parentIndex - 1];
        return parentModule.getNonIncludedClass();
    }

    public boolean getConstantDefined(String internedName) {
        for (StaticScope scope = this.getCurrentScope().getStaticScope(); scope != null; scope = scope.getPreviousCRefScope()) {
            RubyModule module = scope.getModule();
            IRubyObject result = module.fastFetchConstant(internedName);
            if (result == null) continue;
            if (result != RubyObject.UNDEF) {
                return true;
            }
            return this.runtime.getLoadService().autoloadFor(module.getName() + "::" + internedName) != null;
        }
        return this.getCurrentScope().getStaticScope().getModule().fastIsConstantDefined(internedName);
    }

    public IRubyObject getConstant(String internedName) {
        return this.getCurrentScope().getStaticScope().getConstant(this.runtime, internedName, this.runtime.getObject());
    }

    public IRubyObject setConstantInCurrent(String internedName, IRubyObject result) {
        RubyModule module = this.getCurrentScope().getStaticScope().getModule();
        if (module != null) {
            module.fastSetConstant(internedName, result);
            return result;
        }
        throw this.runtime.newTypeError("no class/module to define constant");
    }

    public IRubyObject setConstantInModule(String internedName, IRubyObject target, IRubyObject result) {
        if (!(target instanceof RubyModule)) {
            throw this.runtime.newTypeError(target.toString() + " is not a class/module");
        }
        RubyModule module = (RubyModule)target;
        module.fastSetConstant(internedName, result);
        return result;
    }

    public IRubyObject setConstantInObject(String internedName, IRubyObject result) {
        this.runtime.getObject().fastSetConstant(internedName, result);
        return result;
    }

    private static void addBackTraceElement(RubyArray backtrace, Frame frame, Frame previousFrame) {
        if (frame != previousFrame && frame.getName() != null && frame.getName().equals(previousFrame.getName()) && frame.getFile().equals(previousFrame.getFile()) && frame.getLine() == previousFrame.getLine()) {
            return;
        }
        StringBuilder buf = new StringBuilder(60);
        buf.append(frame.getFile()).append(':').append(frame.getLine() + 1);
        if (previousFrame.getName() != null) {
            buf.append(":in `").append(previousFrame.getName()).append('\'');
        }
        backtrace.append(backtrace.getRuntime().newString(buf.toString()));
    }

    public static IRubyObject createBacktraceFromFrames(Ruby runtime, Frame[] backtraceFrames) {
        return ThreadContext.createBacktraceFromFrames(runtime, backtraceFrames, true);
    }

    public static IRubyObject createBacktraceFromFrames(Ruby runtime, Frame[] backtraceFrames, boolean cropAtEval) {
        RubyArray backtrace = runtime.newArray();
        if (backtraceFrames == null || backtraceFrames.length <= 0) {
            return backtrace;
        }
        int traceSize = backtraceFrames.length;
        for (int i = traceSize - 1; i > 0; --i) {
            Frame frame = backtraceFrames[i];
            if (cropAtEval && frame.isBindingFrame()) break;
            ThreadContext.addBackTraceElement(backtrace, frame, backtraceFrames[i - 1]);
        }
        return backtrace;
    }

    public Frame[] createBacktrace(int level, boolean nativeException) {
        Frame[] traceFrames;
        int traceSize = this.frameIndex - level + 1;
        if (traceSize <= 0) {
            return null;
        }
        if (nativeException) {
            traceFrames = new Frame[traceSize + 1];
            traceFrames[traceSize] = this.frameStack[this.frameIndex];
        } else {
            traceFrames = new Frame[traceSize];
        }
        System.arraycopy(this.frameStack, 0, traceFrames, 0, traceSize);
        return traceFrames;
    }

    public void preAdoptThread() {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.getCurrentFrame().setSelf(this.runtime.getTopSelf());
    }

    public void preCompiledClass(RubyModule type, String[] scopeNames) {
        this.pushRubyClass(type);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        LocalStaticScope staticScope = new LocalStaticScope(this.getCurrentScope().getStaticScope(), scopeNames);
        staticScope.setModule(type);
        this.pushScope(new ManyVarsDynamicScope(staticScope, null));
    }

    public void postCompiledClass() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preScopeNode(StaticScope staticScope) {
        this.pushScope(DynamicScope.newDynamicScope(staticScope, this.getCurrentScope()));
    }

    public void postScopeNode() {
        this.popScope();
    }

    public void preClassEval(StaticScope staticScope, RubyModule type) {
        this.pushRubyClass(type);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        this.pushScope(DynamicScope.newDynamicScope(staticScope, null));
    }

    public void postClassEval() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preBsfApply(String[] names) {
        LocalStaticScope staticScope = new LocalStaticScope(null);
        staticScope.setVariables(names);
        this.pushFrame();
    }

    public void postBsfApply() {
        this.popFrame();
    }

    public void preMethodFrameAndScope(RubyModule clazz, String name, IRubyObject self, Block block, StaticScope staticScope, JumpTarget jumpTarget) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushCallFrame(clazz, name, self, block, jumpTarget);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void postMethodFrameAndScope() {
        this.popRubyClass();
        this.popScope();
        this.popFrame();
    }

    public void preMethodFrameOnly(RubyModule clazz, String name, IRubyObject self, Block block, JumpTarget jumpTarget) {
        this.pushRubyClass(clazz);
        this.pushCallFrame(clazz, name, self, block, jumpTarget);
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postMethodFrameOnly() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preMethodScopeOnly(RubyModule clazz, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void postMethodScopeOnly() {
        this.popRubyClass();
        this.popScope();
    }

    public void preMethodBacktraceAndScope(String name, RubyModule clazz, StaticScope staticScope) {
        this.preMethodScopeOnly(clazz, staticScope);
        this.pushBacktraceFrame(name);
    }

    public void postMethodBacktraceAndScope() {
        this.postMethodScopeOnly();
        this.popFrame();
    }

    public void preMethodBacktraceOnly(String name) {
        this.pushBacktraceFrame(name);
    }

    public void postMethodBacktraceOnly() {
        this.popFrame();
    }

    public void prepareTopLevel(RubyClass objectClass, IRubyObject topSelf) {
        this.pushFrame();
        this.setCurrentVisibility(Visibility.PRIVATE);
        this.pushRubyClass(objectClass);
        Frame frame = this.getCurrentFrame();
        frame.setSelf(topSelf);
        this.getCurrentScope().getStaticScope().setModule(objectClass);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self, String name) {
        this.pushRubyClass(rubyClass);
        this.pushCallFrame(null, null, self, Block.NULL_BLOCK, null);
        this.setCurrentVisibility(Visibility.PRIVATE);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self) {
        this.pushRubyClass(rubyClass);
        this.pushCallFrame(null, null, self, Block.NULL_BLOCK, null);
        this.setCurrentVisibility(Visibility.PRIVATE);
    }

    public void postNodeEval() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preExecuteUnder(RubyModule executeUnderClass, Block block) {
        Frame frame = this.getCurrentFrame();
        this.pushRubyClass(executeUnderClass);
        DynamicScope scope = this.getCurrentScope();
        BlockStaticScope sScope = new BlockStaticScope(scope.getStaticScope());
        sScope.setModule(executeUnderClass);
        this.pushScope(DynamicScope.newDynamicScope(sScope, scope));
        this.pushCallFrame(frame.getKlazz(), frame.getName(), frame.getSelf(), block, frame.getJumpTarget());
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postExecuteUnder() {
        this.popFrame();
        this.popScope();
        this.popRubyClass();
    }

    public void preMproc() {
        this.pushFrame();
    }

    public void postMproc() {
        this.popFrame();
    }

    public void preRunThread(Frame currentFrame) {
        this.pushFrame(currentFrame);
    }

    public void preTrace() {
        this.setWithinTrace(true);
        this.pushFrame();
    }

    public void postTrace() {
        this.popFrame();
        this.setWithinTrace(false);
    }

    public Frame preForBlock(Binding binding, RubyModule klass) {
        Frame lastFrame = this.getNextFrame();
        Frame f = binding.getFrame();
        f.setFile(this.file);
        f.setLine(this.line);
        this.pushFrame(f);
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushScope(binding.getDynamicScope());
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
        return lastFrame;
    }

    public Frame preYieldSpecificBlock(Binding binding, StaticScope scope, RubyModule klass) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding.getFrame());
        f.setFile(this.file);
        f.setLine(this.line);
        f.setVisibility(binding.getVisibility());
        this.pushScope(DynamicScope.newDynamicScope(scope, binding.getDynamicScope()));
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
        return lastFrame;
    }

    public Frame preYieldLightBlock(Binding binding, DynamicScope emptyScope, RubyModule klass) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding.getFrame());
        f.setFile(this.file);
        f.setLine(this.line);
        f.setVisibility(binding.getVisibility());
        this.pushScope(emptyScope);
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
        return lastFrame;
    }

    public Frame preYieldNoScope(Binding binding, RubyModule klass) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding.getFrame());
        f.setFile(this.file);
        f.setLine(this.line);
        f.setVisibility(binding.getVisibility());
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
        return lastFrame;
    }

    public Frame preEvalWithBinding(Binding binding) {
        Frame lastFrame = this.getNextFrame();
        Frame frame = binding.getFrame();
        frame.setIsBindingFrame(true);
        this.pushFrame(frame);
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushRubyClass(binding.getKlass());
        return lastFrame;
    }

    public void postEvalWithBinding(Binding binding, Frame lastFrame) {
        binding.getFrame().setIsBindingFrame(false);
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYield(Binding binding, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldLight(Binding binding, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldNoScope(Frame lastFrame) {
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void preScopedBody(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postScopedBody() {
        this.popScope();
    }

    public boolean isWithinTrace() {
        return this.isWithinTrace;
    }

    public void setWithinTrace(boolean isWithinTrace) {
        this.isWithinTrace = isWithinTrace;
    }

    public boolean isWithinDefined() {
        return this.isWithinDefined;
    }

    public void setWithinDefined(boolean isWithinDefined) {
        this.isWithinDefined = isWithinDefined;
    }
}

