/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import org.jruby.Ruby;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.InvocationCallback;

public abstract class FastInvocationCallback
extends InvocationCallback {
    public IRubyObject execute(IRubyObject recv, IRubyObject[] oargs, Block block) {
        if (this.arityValue >= 0) {
            if (oargs.length != this.arityValue) {
                throw recv.getRuntime().newArgumentError("wrong number of arguments(" + oargs.length + " for " + this.arityValue + ")");
            }
        } else if (oargs.length < -(1 + this.arityValue)) {
            throw recv.getRuntime().newArgumentError("wrong number of arguments(" + oargs.length + " for " + -(1 + this.arityValue) + ")");
        }
        try {
            return this.call(recv, oargs);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (JumpException e) {
            throw e;
        }
        catch (ThreadKill e) {
            throw e;
        }
        catch (MainExitException e) {
            throw e;
        }
        catch (Exception e) {
            Ruby runtime = recv.getRuntime();
            runtime.getJavaSupport().handleNativeException(e);
            return runtime.getNil();
        }
    }

    public abstract IRubyObject call(Object var1, Object[] var2);
}

