/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JEditorPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.PrintContainer;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.Utilities;
import org.openide.text.Annotation;
import org.openide.text.AttributedCharacters;
import org.openide.text.NbDocument;

public class NbEditorDocument
extends GuardedDocument
implements NbDocument.PositionBiasable,
NbDocument.WriteLockable,
NbDocument.Printable,
NbDocument.CustomEditor,
NbDocument.CustomToolbar,
NbDocument.Annotatable {
    public static final String FORMATTER = "formatter";
    public static final String MIME_TYPE_PROP = "mimeType";
    public static final String INDENT_ENGINE = "indentEngine";
    private Formatter formatter;
    private HashMap annoMap;
    private WeakHashMap annoBlackList;

    public NbEditorDocument(Class kitClass) {
        super(kitClass);
        this.addStyleToLayerMapping("NbBreakpointStyle", "NbBreakpointStyleLayer:10");
        this.addStyleToLayerMapping("NbErrorStyle", "NbErrorStyleLayer:20");
        this.addStyleToLayerMapping("NbCurrentStyle", "NbCurrentStyleLayer:30");
        this.setNormalStyleName("NbNormalStyle");
        this.annoMap = new HashMap(20);
        this.annoBlackList = new WeakHashMap();
    }

    public void settingsChange(SettingsChangeEvent evt) {
        super.settingsChange(evt);
        Object o = this.getProperty(MIME_TYPE_PROP);
        if (!(o instanceof String)) {
            BaseKit kit = BaseKit.getKit((Class)this.getKitClass());
            this.putProperty(MIME_TYPE_PROP, kit.getContentType());
        }
        this.putProperty(INDENT_ENGINE, new BaseDocument.PropertyEvaluator(){
            private Object cached;

            public Object getValue() {
                if (this.cached == null) {
                    this.cached = Settings.getValue((Class)NbEditorDocument.this.getKitClass(), (String)NbEditorDocument.INDENT_ENGINE);
                }
                return this.cached;
            }
        });
        this.formatter = null;
    }

    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        if (s != null) {
            Object val = s.getAttribute(NbDocument.GUARDED);
            if (val != null && val instanceof Boolean) {
                if (((Boolean)val).booleanValue()) {
                    super.setCharacterAttributes(offset, length, (AttributeSet)guardedSet, replace);
                } else {
                    super.setCharacterAttributes(offset, length, (AttributeSet)unguardedSet, replace);
                }
            } else {
                super.setCharacterAttributes(offset, length, s, replace);
            }
        }
    }

    public AttributedCharacterIterator[] createPrintIterators() {
        NbPrintContainer npc = new NbPrintContainer();
        this.print(npc);
        return npc.getIterators();
    }

    public Component createEditor(JEditorPane j) {
        return Utilities.getEditorUI((JTextComponent)j).getExtComponent();
    }

    public JToolBar createToolbar(JEditorPane j) {
        return Utilities.getEditorUI((JTextComponent)j).getToolBarComponent();
    }

    public Formatter getFormatter() {
        Formatter f = this.formatter;
        if (f == null) {
            f = this.formatter = (Formatter)Settings.getValue((Class)this.getKitClass(), (String)FORMATTER);
        }
        return f != null ? f : super.getFormatter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(Position startPos, int length, Annotation annotation) {
        Integer count = (Integer)this.annoBlackList.get(annotation);
        if (count != null) {
            if (count == -1) {
                this.annoBlackList.remove(annotation);
                return;
            }
            if (count < -1) {
                this.annoBlackList.put(annotation, new Integer(count + 1));
                return;
            }
        }
        this.readLock();
        try {
            int docLen = this.getLength();
            int offset = startPos.getOffset();
            offset = Math.min(offset, docLen);
            try {
                startPos = this.createPosition(offset);
            }
            catch (BadLocationException e) {
                startPos = null;
            }
            AnnotationDescDelegate a = (AnnotationDescDelegate)((Object)this.annoMap.get(annotation));
            if (a != null) {
                a.detachListeners();
                this.getAnnotations().removeAnnotation((AnnotationDesc)a);
                this.annoMap.remove(annotation);
                this.annoBlackList.put(annotation, new Integer(count != null ? count + 1 : 1));
            }
            if (annotation.getAnnotationType() != null) {
                a = new AnnotationDescDelegate((BaseDocument)this, startPos, length, annotation);
                this.annoMap.put(annotation, a);
                this.getAnnotations().addAnnotation((AnnotationDesc)a);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotation(Annotation annotation) {
        if (annotation == null) {
            return;
        }
        Integer count = (Integer)this.annoBlackList.get(annotation);
        if (count != null) {
            if (count == 1) {
                this.annoBlackList.remove(annotation);
                return;
            }
            if (count > 1) {
                this.annoBlackList.put(annotation, new Integer(count - 1));
                return;
            }
        }
        this.readLock();
        try {
            if (annotation.getAnnotationType() != null) {
                AnnotationDescDelegate a = (AnnotationDescDelegate)((Object)this.annoMap.get(annotation));
                if (a == null) {
                    this.annoBlackList.put(annotation, new Integer(count != null ? count - 1 : -1));
                    return;
                }
                a.detachListeners();
                this.getAnnotations().removeAnnotation((AnnotationDesc)a);
                this.annoMap.remove(annotation);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    Map getAnnoMap() {
        return this.annoMap;
    }

    void addStreamDescriptionChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    void removeStreamDescriptionChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    private void fireStreamDescriptionChange() {
        ChangeEvent evt = new ChangeEvent((Object)this);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? NbEditorDocument.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(evt);
        }
    }

    protected Dictionary createDocumentProperties(Dictionary origDocumentProperties) {
        return new BaseDocument.LazyPropertyMap(origDocumentProperties){

            public Object put(Object key, Object value) {
                Object origValue = super.put(key, value);
                if ("stream".equals(key) && (origValue == null || !origValue.equals(value))) {
                    NbEditorDocument.this.fireStreamDescriptionChange();
                }
                return origValue;
            }
        };
    }

    class NbPrintContainer
    extends AttributedCharacters
    implements PrintContainer {
        ArrayList acl = new ArrayList();
        AttributedCharacters a = new AttributedCharacters();

        NbPrintContainer() {
        }

        public void add(char[] chars, Font font, Color foreColor, Color backColor) {
            this.a.append(chars, font, foreColor);
        }

        public void eol() {
            this.acl.add(this.a);
            this.a = new AttributedCharacters();
        }

        public boolean initEmptyLines() {
            return true;
        }

        public AttributedCharacterIterator[] getIterators() {
            int cnt = this.acl.size();
            AttributedCharacterIterator[] acis = new AttributedCharacterIterator[cnt];
            for (int i = 0; i < cnt; ++i) {
                AttributedCharacters ac = (AttributedCharacters)this.acl.get(i);
                acis[i] = ac.iterator();
            }
            return acis;
        }
    }

    static class AnnotationDescDelegate
    extends AnnotationDesc {
        private Annotation delegate;
        private PropertyChangeListener l;
        private Position pos;
        private BaseDocument doc;

        AnnotationDescDelegate(BaseDocument doc, Position pos, int length, Annotation anno) {
            super(pos.getOffset(), length);
            this.pos = pos;
            this.delegate = anno;
            this.doc = doc;
            this.updateAnnotationType();
            this.l = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "shortDescription") {
                        AnnotationDescDelegate.this.firePropertyChange("shortDescription", null, null);
                    }
                    if (evt.getPropertyName() == "moveToFront") {
                        AnnotationDescDelegate.this.firePropertyChange("moveToFront", null, null);
                    }
                    if (evt.getPropertyName() == "annotationType") {
                        AnnotationDescDelegate.this.updateAnnotationType();
                        AnnotationDescDelegate.this.firePropertyChange("annotationType", null, null);
                    }
                }
            };
            this.delegate.addPropertyChangeListener(this.l);
        }

        public String getAnnotationType() {
            return this.delegate.getAnnotationType();
        }

        public String getShortDescription() {
            return this.delegate.getShortDescription();
        }

        void detachListeners() {
            this.delegate.removePropertyChangeListener(this.l);
        }

        public int getOffset() {
            return this.pos.getOffset();
        }

        public int getLine() {
            try {
                return Utilities.getLineOffset((BaseDocument)this.doc, (int)this.pos.getOffset());
            }
            catch (BadLocationException e) {
                return 0;
            }
        }
    }
}

