/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Handler;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChain;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChains;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChainsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.core.webservices.ui.panels.MessageHandlerPanel;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class HandlerButtonListener
implements ActionListener {
    MessageHandlerPanel panel;
    HandlerChains handlerChains;
    HandlerChain chain;
    FileObject handlerFO;
    JavaClass implBeanClass;
    Service service;
    boolean isNew;

    public HandlerButtonListener(MessageHandlerPanel panel, HandlerChains handlerChains, FileObject handlerFO, JavaClass implBeanClass, Service service, boolean isNew) {
        this.panel = panel;
        this.handlerChains = handlerChains;
        this.handlerFO = handlerFO;
        this.implBeanClass = implBeanClass;
        this.service = service;
        this.isNew = isNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == NotifyDescriptor.OK_OPTION) {
            if (this.isNew) {
                JMIUtils.beginJmiTransaction((boolean)true);
                String servicehandlerFileName = this.service.getName() + "_handler";
                FileObject parent = JavaModel.getFileObject((Resource)this.implBeanClass.getResource()).getParent();
                String handlerFileName = FileUtil.findFreeFileName((FileObject)parent, (String)servicehandlerFileName, (String)"xml");
                ArrayList<AttributeValue> attrList = new ArrayList<AttributeValue>();
                AttributeValue attrValue = JMIGenerationUtil.createAttributeValue((Element)this.implBeanClass, (String)"name", (String)(this.service.getName() + "_handlerChain"));
                attrList.add(attrValue);
                attrValue = JMIGenerationUtil.createAttributeValue((Element)this.implBeanClass, (String)"file", (String)(handlerFileName + ".xml"));
                attrList.add(attrValue);
                this.implBeanClass.getAnnotations().add(JMIGenerationUtil.createAnnotation((Element)this.implBeanClass, (String)"javax.jws.HandlerChain", attrList));
                JMIUtils.endJmiTransaction();
                this.handlerFO = parent.getFileObject(handlerFileName, "xml");
                if (this.handlerFO == null) {
                    try {
                        WSUtils.retrieveHandlerConfigFromResource((FileObject)parent, (String)(handlerFileName + ".xml"));
                        this.handlerFO = parent.getFileObject(handlerFileName, "xml");
                    }
                    catch (Exception exp) {
                        ErrorManager.getDefault().notify((Throwable)exp);
                    }
                }
                try {
                    this.handlerChains = HandlerChainsProvider.getDefault().getHandlerChains(this.handlerFO);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return;
                }
            }
            DefaultListModel listModel = this.panel.getListModel();
            this.chain = this.handlerChains.getHandlerChains()[0];
            for (int i = 0; i < listModel.getSize(); ++i) {
                String className = (String)listModel.getElementAt(i);
                if (!this.isNewHandler(className, this.chain)) continue;
                this.chain.addHandler(className, className);
            }
            Handler[] handlers = this.chain.getHandlers();
            for (int j = 0; j < handlers.length; ++j) {
                Handler handler = handlers[j];
                String clsName = handler.getHandlerClass();
                if (this.isInModel(clsName, listModel)) continue;
                this.chain.removeHandler(clsName);
            }
            FileLock lock = null;
            OutputStream out = null;
            if (this.chain.getHandlers().length == 0) {
                Annotation handlerAnnotation = JaxWsNode.getAnnotation((AnnotableElement)this.implBeanClass, "HandlerChain");
                if (handlerAnnotation != null) {
                    JMIUtils.beginJmiTransaction((boolean)true);
                    this.implBeanClass.getAnnotations().remove(handlerAnnotation);
                    JMIUtils.endJmiTransaction();
                }
                try {
                    lock = this.handlerFO.lock();
                    this.handlerFO.delete(lock);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            } else {
                try {
                    lock = this.handlerFO.lock();
                    out = this.handlerFO.getOutputStream(lock);
                    this.handlerChains.write(out);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().notify((Throwable)ioe);
                        }
                    }
                }
            }
        }
    }

    private boolean isInModel(String className, ListModel model) {
        for (int i = 0; i < model.getSize(); ++i) {
            String cls = (String)model.getElementAt(i);
            if (!className.equals(cls)) continue;
            return true;
        }
        return false;
    }

    private boolean isNewHandler(String className, HandlerChain handlerChain) {
        if (handlerChain != null) {
            Handler[] handlers = handlerChain.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                if (!handlers[i].getHandlerClass().equals(className)) continue;
                return false;
            }
        }
        return true;
    }

    private static String readResource(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append(lineSep);
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }
}

