/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class RefreshWsDialog
extends JPanel {
    static final int CLOSE = 0;
    static final int DO_NOTHING = 1;
    static final int DOWNLOAD_WSDL = 2;
    static final int REGENERATE_IMPL_CLASS = 3;
    static final int DO_ALL = 4;
    private String implClass;
    private String url;
    private boolean downloadWsdl;
    private JCheckBox downloadWsdlCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JCheckBox regenerateCheckBox;

    private RefreshWsDialog(boolean downloadWsdl, String implClass, String url) {
        this.downloadWsdl = downloadWsdl;
        this.implClass = implClass;
        this.url = url;
        this.initComponents();
        if (!downloadWsdl) {
            this.downloadWsdlCheckBox.setVisible(false);
            this.jLabel1.setVisible(false);
        }
    }

    public static int open(boolean downloadWsdl, String implClass, String url) {
        String title = NbBundle.getMessage(RefreshWsDialog.class, (String)"MSG_ConfirmServiceRefresh");
        RefreshWsDialog delDialog = new RefreshWsDialog(downloadWsdl, implClass, url);
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)delDialog, title, 0);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (result.equals(NotifyDescriptor.CLOSED_OPTION)) {
            return 0;
        }
        if (result.equals(NotifyDescriptor.NO_OPTION)) {
            return 0;
        }
        if (delDialog.downloadWsdl() && delDialog.regenerate()) {
            return 4;
        }
        if (delDialog.downloadWsdl()) {
            return 2;
        }
        if (delDialog.regenerate()) {
            return 3;
        }
        return 1;
    }

    public static int openWithOKButtonOnly(boolean downloadWsdl, String implClass, String url) {
        String title = NbBundle.getMessage(RefreshWsDialog.class, (String)"MSG_ConfirmServiceRefresh");
        RefreshWsDialog delDialog = new RefreshWsDialog(downloadWsdl, implClass, url);
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)delDialog, 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (delDialog.regenerate()) {
            return 3;
        }
        return 1;
    }

    private boolean downloadWsdl() {
        if (!this.downloadWsdl) {
            return false;
        }
        return this.downloadWsdlCheckBox.isSelected();
    }

    private boolean regenerate() {
        return this.regenerateCheckBox.isSelected();
    }

    private void initComponents() {
        this.downloadWsdlCheckBox = new JCheckBox();
        this.regenerateCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.downloadWsdlCheckBox.setMnemonic(NbBundle.getMessage(RefreshWsDialog.class, (String)"MSG_DownloadWsdl_mnem").charAt(0));
        this.downloadWsdlCheckBox.setText(NbBundle.getMessage(RefreshWsDialog.class, (String)"MSG_DownloadWsdl", (Object[])new Object[]{this.url}));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.downloadWsdlCheckBox, gridBagConstraints);
        this.regenerateCheckBox.setMnemonic(NbBundle.getMessage(RefreshWsDialog.class, (String)"MSG_RegenerateImplClass_mnem").charAt(0));
        this.regenerateCheckBox.setSelected(true);
        this.regenerateCheckBox.setText(NbBundle.getMessage(RefreshWsDialog.class, (String)"MSG_RegenerateImplClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.regenerateCheckBox, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getMessage(RefreshWsDialog.class, (String)"HINT_DownloadWsdl"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(NbBundle.getMessage(RefreshWsDialog.class, (String)"HINT_RegenerateImplClass", (Object[])new Object[]{this.implClass + ".java.old"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(NbBundle.getMessage(RefreshWsDialog.class, (String)"HINT_RefreshService"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
    }
}

