/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JavaCompletionQuery;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JCFinderFactory;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.websvc.editor.completion.FileAttributeSupport;
import org.netbeans.modules.websvc.editor.completion.JMIUtils;
import org.netbeans.modules.websvc.editor.completion.NNParser;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class WSCompletionQuery
extends JavaCompletionQuery {
    private static final String WEBSERVICE_NN = "WebService";
    private static final String HANDLER_CHAIN_NN = "HandlerChain";
    private List resolvers;

    public WSCompletionQuery(boolean isJava15) {
        this.setJava15(isJava15);
    }

    protected JCFinder getFinder() {
        FileObject fo = this.getFileObject();
        return JCFinderFactory.getDefault().getFinder(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletionQuery.Result getResult(JTextComponent component, JavaSyntaxSupport sup, boolean openingSource, int offset, JCExpression exp) {
        Completion completion = ((ExtEditorUI)Utilities.getEditorUI((JTextComponent)component)).getCompletion();
        boolean autoPopup = completion != null ? completion.provokedByAutoPopup : false;
        JMIUtils utils = JMIUtils.get(this.getBaseDocument());
        utils.beginTrans(false);
        try {
            ((JMManager)JMManager.getManager()).setSafeTrans(true);
            Context ctx = new Context(component, (NbJavaJMISyntaxSupport)sup.get(NbJavaJMISyntaxSupport.class), openingSource, offset, utils, autoPopup);
            boolean ok = ctx.resolveExp(exp);
            CompletionQuery.DefaultResult defaultResult = ok ? ctx.result : null;
            return defaultResult;
        }
        finally {
            utils.endTrans(false);
        }
    }

    private FileObject getFileObject() {
        BaseDocument bDoc = this.getBaseDocument();
        DataObject dobj = NbEditorUtilities.getDataObject((Document)bDoc);
        return dobj.getPrimaryFile();
    }

    private final class Context {
        private JTextComponent component;
        private NbJavaJMISyntaxSupport sup;
        private boolean openingSource;
        private int endOffset;
        private boolean findType;
        private boolean staticOnly = true;
        private JavaPackage lastPkg;
        private Type lastType;
        private CompletionQuery.DefaultResult result;
        private boolean isConstructor;
        private boolean isImport;
        private boolean isStaticImport;
        private boolean isGeneric;
        private Collection typeBounds;
        private boolean isAnnotation;
        private boolean isAnnotationOpen;
        private JavaClass curCls;
        private boolean autoPopup;
        private JMIUtils jmiUtils = null;

        public Context(JTextComponent component, NbJavaJMISyntaxSupport sup, boolean openingSource, int endOffset, JMIUtils utils, boolean autoPopup) {
            this.component = component;
            this.sup = sup;
            this.openingSource = openingSource;
            this.endOffset = endOffset;
            this.jmiUtils = utils;
            this.curCls = sup.getJavaClass(endOffset);
            if (this.curCls == null) {
                this.curCls = sup.getTopJavaClass();
            }
            this.autoPopup = autoPopup;
        }

        boolean resolveExp(JCExpression exp) {
            switch (exp.getExpID()) {
                case 21: {
                    String annotationName = this.getAnnotationTypeName(exp);
                    this.resolveCompletionContext(annotationName, this.getCompletedMemberName(exp), "");
                    break;
                }
                case 0: {
                    this.resolveConstantExpression(exp);
                }
            }
            return true;
        }

        private void resolveConstantExpression(JCExpression exp) {
            NNParser parser = new NNParser(WSCompletionQuery.this.getBaseDocument());
            NNParser.NN nn = parser.parseAnnotation(this.endOffset);
            if (nn != null) {
                try {
                    TokenItem ti = this.sup.getTokenChain(this.endOffset - 1, this.endOffset);
                    if (ti.getTokenID() == JavaTokenContext.STRING_LITERAL) {
                        if ((ti = ti.getPrevious()).getTokenID() == JavaTokenContext.WHITESPACE) {
                            ti = ti.getPrevious();
                        }
                        if (ti.getTokenID() == JavaTokenContext.EQ) {
                            if ((ti = ti.getPrevious()).getTokenID() == JavaTokenContext.WHITESPACE) {
                                ti = ti.getPrevious();
                            }
                            if (ti.getTokenID() == JavaTokenContext.IDENTIFIER) {
                                String attrName = ti.getImage();
                                String value = exp.getTokenText(0);
                                this.resolveCompletionContext(nn.getName(), attrName, value);
                            }
                        }
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }

        private void resolveCompletionContext(String annotationName, String attrName, String attrValue) {
            if (WSCompletionQuery.WEBSERVICE_NN.equals(annotationName)) {
                this.completeWebService(attrName, attrValue);
            } else if (WSCompletionQuery.HANDLER_CHAIN_NN.equals(annotationName)) {
                this.completeHandlerChain(attrName, attrValue);
            }
        }

        private String getCompletedMemberName(JCExpression exp) {
            int parCnt = exp.getParameterCount();
            if (parCnt <= 0) {
                return null;
            }
            JCExpression lastMember = exp.getParameter(parCnt - 1);
            if (lastMember.getParameterCount() < 2) {
                return null;
            }
            JCExpression lastMemberParm1 = lastMember.getParameter(1);
            if (lastMemberParm1.getExpID() != 1 || lastMemberParm1.getTokenText(0).length() > 0) {
                return null;
            }
            String completedMember = lastMember.getParameter(0).getTokenText(0);
            return completedMember;
        }

        private void completeWebService(String attributeName, String completedAttributeValue) {
            if ("wsdlLocation".equals(attributeName)) {
                ArrayList results = new ArrayList();
                results.addAll(FileAttributeSupport.completionResults(this.endOffset, this.sup, WSCompletionQuery.this.getBaseDocument(), completedAttributeValue, true));
                this.result = new CompletionQuery.DefaultResult(this.component, "*", results, 0, 0);
            }
        }

        private void completeHandlerChain(String attributeName, String completedAttributeValue) {
            if ("file".equals(attributeName)) {
                ArrayList results = new ArrayList();
                results.addAll(FileAttributeSupport.completionResults(this.endOffset, this.sup, WSCompletionQuery.this.getBaseDocument(), completedAttributeValue, false));
                this.result = new CompletionQuery.DefaultResult(this.component, "*", results, 0, 0);
            }
        }

        private String getAnnotationTypeName(JCExpression exp) {
            assert (exp != null);
            String result = null;
            if (exp.getParameterCount() < 1) {
                return result;
            }
            JCExpression variable = exp.getParameter(0);
            if (variable.getExpID() != 1) {
                return result;
            }
            result = variable.getTokenText(0);
            return result;
        }
    }
}

