/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.wsdl.wizard.Utilities;
import org.netbeans.modules.websvc.wsdl.wizard.WsdlPanel;
import org.netbeans.modules.websvc.wsdl.wizard.WsdlUIPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class WsdlIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 3020391475943498962L;
    public static final Dimension PREF_SIZE = new Dimension(560, 350);
    private WizardDescriptor.Panel folderPanel;
    private transient SourceGroup[] sourceGroups;
    private static final String DEFAULT_TARGET_NAMESPACE = "urn:WS/wsdl";
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;

    protected WizardDescriptor.Panel[] createPanels(Project project) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        this.sourceGroups = sources.getSourceGroups("generic");
        this.folderPanel = new WsdlPanel(project, this.sourceGroups);
        WizardDescriptor.Panel firstPanel = Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])this.sourceGroups, (WizardDescriptor.Panel)this.folderPanel);
        JComponent c = (JComponent)firstPanel.getComponent();
        String fileNameLabel = NbBundle.getMessage(WsdlIterator.class, (String)"LBL_SimpleTargetChooserPanel_FileName_Label");
        ((WsdlPanel)this.folderPanel).setNameTF((JTextField)Utilities.findTextFieldForLabel(c, fileNameLabel));
        return new WizardDescriptor.Panel[]{firstPanel};
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        EditCookie edit;
        DataObject dTemplate;
        DataObject dobj;
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wiz);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        WsdlPanel panel = (WsdlPanel)this.folderPanel;
        boolean importSchemas = false;
        if (panel.isImport() && panel.getSchemas().length > 0) {
            importSchemas = true;
            FileObject templateParent = template.getParent();
            template = templateParent.getFileObject("WSDL_import", "wsdl");
        }
        if ((dobj = (dTemplate = DataObject.find((FileObject)template)).createFromTemplate(df, Templates.getTargetName((WizardDescriptor)wiz))) != null && (edit = (EditCookie)dobj.getCookie(EditCookie.class)) != null) {
            SaveCookie save;
            EditorCookie editorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
            editorCookie.openDocument();
            StyledDocument doc = editorCookie.getDocument();
            Utilities.replaceInDocument(doc, "#SERVICE_NAME", panel.getWsName());
            String targetNamespace = panel.getNS();
            if (targetNamespace.length() == 0) {
                targetNamespace = DEFAULT_TARGET_NAMESPACE;
            }
            Utilities.replaceInDocument(doc, "#TARGET_NAMESPACE", targetNamespace);
            if (importSchemas) {
                int i;
                WsdlUIPanel.SchemaInfo[] infos = panel.getSchemas();
                StringBuffer typeNamespaces = new StringBuffer();
                StringBuffer imports = new StringBuffer();
                for (i = 0; i < infos.length; ++i) {
                    String ns;
                    if (i > 0) {
                        typeNamespaces.append("    ");
                        imports.append("      ");
                    }
                    if ((ns = infos[i].getNamespace()).length() == 0) {
                        ns = "urn:WS/types" + String.valueOf(i + 1);
                    }
                    typeNamespaces.append("xmlns:ns" + String.valueOf(i + 1) + "=\"" + ns + "\"\n");
                    imports.append("<xsd:import ");
                    imports.append("namespace=\"" + ns + "\" ");
                    String relativePath = null;
                    try {
                        relativePath = this.getRelativePathOfSchema(dobj, infos[i].getSchemaName());
                    }
                    catch (URISyntaxException e) {
                        relativePath = infos[i].getSchemaName();
                    }
                    imports.append("schemaLocation=\"" + relativePath + "\"/>\n");
                }
                Utilities.replaceInDocument(doc, "#TYPE_NAMESPACES", typeNamespaces.toString());
                Utilities.replaceInDocument(doc, "#SCHEMA_IMPORTS", imports.toString());
                for (i = 0; i < infos.length; ++i) {
                    if (i > 0) {
                        typeNamespaces.append("    ");
                    }
                    typeNamespaces.append("xmlns:ns" + String.valueOf(i + 1) + "=\"" + infos[i].getNamespace() + "\"\n");
                }
                Utilities.replaceInDocument(doc, "#TYPE_NAMESPACES", typeNamespaces.toString());
            }
            if ((save = (SaveCookie)dobj.getCookie(SaveCookie.class)) != null) {
                save.save();
            }
        }
        return Collections.singleton(dobj);
    }

    private String getRelativePathOfSchema(DataObject wsdlDO, String schemaURL) throws URISyntaxException {
        FileObject fo = wsdlDO.getPrimaryFile();
        File f = FileUtil.toFile((FileObject)fo);
        String relativePath = org.netbeans.modules.xml.retriever.catalog.Utilities.relativize((URI)f.toURI(), (URI)new URI(schemaURL));
        return relativePath;
    }

    public void initialize(TemplateWizard wiz) {
        this.wiz = wiz;
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels(project);
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = Utilities.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(WsdlIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

