/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class FixedWatchesManager
implements TreeModelFilter,
NodeActionsProviderFilter,
NodeModelFilter {
    public static final String FIXED_WATCH = "org/netbeans/modules/debugger/resources/watchesView/FixedWatch";
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle((Class)FixedWatchesManager.class).getString("CTL_DeleteFixedWatch_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                FixedWatchesManager.this.fixedWatches.remove(nodes[i]);
            }
            FixedWatchesManager.this.fireModelChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action CREATE_FIXED_WATCH_ACTION;
    private Map fixedWatches;
    private HashSet listeners;
    private ContextProvider contextProvider;

    public FixedWatchesManager(ContextProvider contextProvider) {
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this.CREATE_FIXED_WATCH_ACTION = Models.createAction((String)NbBundle.getBundle((Class)FixedWatchesManager.class).getString("CTL_CreateFixedWatch_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return true;
            }

            public void perform(Object[] nodes) {
                int k = nodes.length;
                for (int i = 0; i < k; ++i) {
                    FixedWatchesManager.this.createFixedWatch(nodes[i]);
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
        this.fixedWatches = new HashMap();
        this.contextProvider = contextProvider;
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            if (this.fixedWatches.size() == 0) {
                return original.getChildren(parent, from, to);
            }
            int fixedSize = this.fixedWatches.size();
            int originalFrom = from - fixedSize;
            int originalTo = to - fixedSize;
            if (originalFrom < 0) {
                originalFrom = 0;
            }
            Object[] children = originalTo > originalFrom ? original.getChildren(parent, originalFrom, originalTo) : new Object[]{};
            Object[] allChildren = new Object[children.length + fixedSize];
            this.fixedWatches.keySet().toArray(allChildren);
            System.arraycopy(children, 0, allChildren, fixedSize, children.length);
            Object[] fallChildren = new Object[to - from];
            System.arraycopy(allChildren, from, fallChildren, 0, to - from);
            return fallChildren;
        }
        return original.getChildren(parent, from, to);
    }

    public int getChildrenCount(TreeModel original, Object parent) throws UnknownTypeException {
        if (parent == "Root") {
            int chc = original.getChildrenCount(parent);
            return chc + this.fixedWatches.size();
        }
        return original.getChildrenCount(parent);
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        return original.isLeaf(node);
    }

    public void addModelListener(ModelListener l) {
        HashSet newListeners = this.listeners == null ? new HashSet() : (HashSet)this.listeners.clone();
        newListeners.add(l);
        this.listeners = newListeners;
    }

    public void removeModelListener(ModelListener l) {
        if (this.listeners == null) {
            return;
        }
        HashSet newListeners = (HashSet)this.listeners.clone();
        newListeners.remove(l);
        this.listeners = newListeners;
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] actions = original.getActions(node);
        ArrayList<Action> myActions = new ArrayList<Action>();
        if (this.fixedWatches.containsKey(node)) {
            return new Action[]{this.DELETE_ACTION};
        }
        if (node instanceof Variable) {
            myActions.add(this.CREATE_FIXED_WATCH_ACTION);
        } else if (node instanceof JPDAWatch) {
            myActions.add(this.CREATE_FIXED_WATCH_ACTION);
        } else {
            return actions;
        }
        myActions.addAll(Arrays.asList(actions));
        return myActions.toArray(new Action[myActions.size()]);
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(node)) {
            return (String)this.fixedWatches.get(node);
        }
        return original.getDisplayName(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(node)) {
            Variable v = (Variable)node;
            return (String)this.fixedWatches.get(node) + " = (" + v.getType() + ") " + v.getValue();
        }
        return original.getShortDescription(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        if (this.fixedWatches.containsKey(node)) {
            return FIXED_WATCH;
        }
        return original.getIconBase(node);
    }

    private void createFixedWatch(Object node) {
        if (node instanceof JPDAWatch) {
            JPDAWatch jw = (JPDAWatch)node;
            this.addFixedWatch(jw.getExpression(), (Variable)jw);
        } else {
            Variable variable = (Variable)node;
            String name = null;
            name = variable instanceof LocalVariable ? ((LocalVariable)variable).getName() : (variable instanceof Field ? ((Field)variable).getName() : (variable instanceof This ? "this" : (variable instanceof ObjectVariable ? "object" : "unnamed")));
            this.addFixedWatch(name, variable);
        }
    }

    private void addFixedWatch(String name, Variable variable) {
        this.fixedWatches.put(variable, name);
        this.fireModelChanged();
    }

    private void fireModelChanged() {
        if (this.listeners == null) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ModelListener listener = (ModelListener)i.next();
            listener.modelChanged(null);
        }
    }
}

