/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class VariablesTableModel
implements TableModel,
Constants {
    private JPDADebugger debugger;

    public VariablesTableModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Object getValueAt(Object row, String columnID) throws UnknownTypeException {
        if (columnID.equals("LocalsToString") || columnID.equals("WatchToString")) {
            if (row instanceof Super) {
                return "";
            }
            if (row instanceof ObjectVariable) {
                try {
                    return ((ObjectVariable)row).getToStringValue();
                }
                catch (InvalidExpressionException ex) {
                    return VariablesTableModel.getMessage(ex);
                }
            }
            if (row instanceof Variable) {
                return ((Variable)row).getValue();
            }
        } else if (columnID.equals("LocalsType") || columnID.equals("WatchType")) {
            if (row instanceof Variable) {
                return VariablesTableModel.getShort(((Variable)row).getType());
            }
        } else if (columnID.equals("LocalsValue") || columnID.equals("WatchValue")) {
            if (row instanceof JPDAWatch) {
                JPDAWatch w = (JPDAWatch)row;
                String e = w.getExceptionDescription();
                if (e != null) {
                    return ">" + e + "<";
                }
                return w.getValue();
            }
            if (row instanceof Variable) {
                return ((Variable)row).getValue();
            }
        }
        if (row.toString().startsWith("SubArray")) {
            return "";
        }
        throw new UnknownTypeException(row);
    }

    public boolean isReadOnly(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Variable) {
            if (columnID.equals("LocalsToString") || columnID.equals("WatchToString") || columnID.equals("LocalsType") || columnID.equals("WatchType")) {
                return true;
            }
            if (columnID.equals("LocalsValue") || columnID.equals("WatchValue")) {
                if (row instanceof This) {
                    return true;
                }
                if (row instanceof LocalVariable || row instanceof Field || row instanceof JPDAWatch) {
                    return !this.debugger.canBeModified();
                }
                return true;
            }
        }
        if (row.toString().startsWith("SubArray")) {
            return true;
        }
        throw new UnknownTypeException(row);
    }

    public void setValueAt(Object row, String columnID, Object value) throws UnknownTypeException {
        if (row instanceof LocalVariable && columnID.equals("LocalsValue")) {
            try {
                ((LocalVariable)row).setValue((String)value);
            }
            catch (InvalidExpressionException e) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
            return;
        }
        if (row instanceof Field && (columnID.equals("LocalsValue") || columnID.equals("WatchValue"))) {
            try {
                ((Field)row).setValue((String)value);
            }
            catch (InvalidExpressionException e) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
            return;
        }
        if (row instanceof JPDAWatch && (columnID.equals("LocalsValue") || columnID.equals("WatchValue"))) {
            try {
                ((JPDAWatch)row).setValue((String)value);
            }
            catch (InvalidExpressionException e) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
            return;
        }
        throw new UnknownTypeException(row);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    static String getShort(String c) {
        int i = c.lastIndexOf(46);
        if (i < 0) {
            return c;
        }
        return c.substring(i + 1);
    }

    private static String getMessage(InvalidExpressionException e) {
        String m = e.getLocalizedMessage();
        if (m == null) {
            m = e.getMessage();
        }
        return ">" + m + "<";
    }
}

