/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WatchesActionsProvider
implements NodeActionsProvider {
    private static final Action NEW_WATCH_ACTION = new AbstractAction(NbBundle.getBundle((Class)WatchesActionsProvider.class).getString("CTL_WatchAction_AddNew")){

        public void actionPerformed(ActionEvent e) {
            WatchesActionsProvider.newWatch();
        }
    };
    private static final Action DELETE_ALL_ACTION = new AbstractAction(NbBundle.getBundle((Class)WatchesActionsProvider.class).getString("CTL_WatchAction_DeleteAll")){

        public void actionPerformed(ActionEvent e) {
            DebuggerManager.getDebuggerManager().removeAllWatches();
        }
    };
    private static final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle((Class)WatchesActionsProvider.class).getString("CTL_WatchAction_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                ((JPDAWatch)nodes[i]).remove();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action CUSTOMIZE_ACTION;

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return new Action[]{NEW_WATCH_ACTION, null, DELETE_ALL_ACTION};
        }
        if (node instanceof JPDAWatch) {
            return new Action[]{NEW_WATCH_ACTION, null, DELETE_ACTION, DELETE_ALL_ACTION, null, CUSTOMIZE_ACTION};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof JPDAWatch) {
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private static void customize(JPDAWatch w) {
        WatchPanel wp = new WatchPanel(w.getExpression());
        JComponent panel = wp.getPanel();
        ResourceBundle bundle = NbBundle.getBundle((Class)WatchesActionsProvider.class);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, MessageFormat.format(bundle.getString("CTL_Edit_Watch_Dialog_Title"), w.getExpression()));
        dd.setHelpCtx(new HelpCtx("debug.customize.watch"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        dialog.dispose();
        if (dd.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        if (panel.getClientProperty("WatchCanceled") != null) {
            return;
        }
        w.setExpression(wp.getExpression());
    }

    private static void newWatch() {
        WatchPanel wp = new WatchPanel("");
        JComponent panel = wp.getPanel();
        ResourceBundle bundle = NbBundle.getBundle((Class)WatchesActionsProvider.class);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, bundle.getString("CTL_New_Watch_Dialog_Title"));
        dd.setHelpCtx(new HelpCtx("debug.new.watch"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        dialog.dispose();
        if (dd.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        if (panel.getClientProperty("WatchCanceled") != null) {
            return;
        }
        DebuggerManager.getDebuggerManager().createWatch(wp.getExpression());
    }

    static {
        DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        CUSTOMIZE_ACTION = Models.createAction((String)NbBundle.getBundle((Class)WatchesActionsProvider.class).getString("CTL_WatchAction_Customize"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return true;
            }

            public void perform(Object[] nodes) {
                WatchesActionsProvider.customize((JPDAWatch)nodes[0]);
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }
}

