/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLDrawLayerFactory;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.java.JavaDrawLayerFactory;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.web.core.syntax.ELDrawLayerFactory;
import org.netbeans.modules.web.core.syntax.Jsp11Syntax;
import org.netbeans.modules.web.core.syntax.JspFormatter;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspTagTokenContext;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.folding.JspFoldTypes;
import org.netbeans.modules.web.core.syntax.spi.JSPColoringData;
import org.netbeans.modules.web.core.syntax.spi.JspContextInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class JSPKit
extends NbEditorKit
implements HelpCtx.Provider {
    public static final String JSP_MIME_TYPE = "text/x-jsp";
    public static final String TAG_MIME_TYPE = "text/x-tag";
    public static final String collapseAllCommentsAction = "collapse-all-comment-folds";
    public static final String expandAllCommentsAction = "expand-all-comment-folds";
    public static final String collapseAllScriptingAction = "collapse-all-scripting-folds";
    public static final String expandAllScriptingAction = "expand-all-scripting-folds";
    private static final long serialVersionUID = 8933974837050367142L;
    public static final boolean debug = false;

    public String getContentType() {
        return JSP_MIME_TYPE;
    }

    public Syntax createSyntax(Document doc) {
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        FileObject fobj = dobj != null ? dobj.getPrimaryFile() : null;
        Syntax contentSyntax = JSPKit.getSyntaxForLanguage(doc, JspUtils.getContentLanguage());
        Syntax scriptingSyntax = JSPKit.getSyntaxForLanguage(doc, JspUtils.getScriptingLanguage());
        Jsp11Syntax newSyntax = new Jsp11Syntax(contentSyntax, scriptingSyntax);
        JSPColoringData data = JspUtils.getJSPColoringData(doc, fobj);
        ColoringListener pList = new ColoringListener(doc, data, newSyntax);
        if (data != null) {
            data.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)pList, (Object)data));
        }
        return newSyntax;
    }

    protected Action[] createActions() {
        Action[] javaActions = new Action[]{new JspJavaGenerateGotoPopupAction(), new JavaKit.JavaJMIGotoSourceAction(), new JavaKit.JavaJMIGotoDeclarationAction(), new JavaKit.JavaGotoSuperImplementation(), new MatchBraceAction("match-brace", false), new MatchBraceAction("selection-match-brace", true), new JspGenerateFoldPopupAction(), new CollapseAllCommentsFolds(), new ExpandAllCommentsFolds(), new CollapseAllScriptingFolds(), new ExpandAllScriptingFolds(), new JspInsertBreakAction(), new JspDefaultKeyTypedAction(), new JspDeleteCharAction("delete-previous", false)};
        return TextAction.augmentList(super.createActions(), javaActions);
    }

    public static Syntax getSyntaxForLanguage(Document doc, String language) {
        EditorKit kit = JEditorPane.createEditorKitForContentType(language);
        if (kit instanceof JavaKit) {
            JavaKit jkit = (JavaKit)kit;
            String sourceLevel = jkit.getSourceLevel((BaseDocument)doc);
            return new JavaSyntax(sourceLevel, true);
        }
        return new HTMLSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        if (dobj != null) {
            return new JspSyntaxSupport(doc, JspContextInfo.getContextInfo().getCachedOpenInfo((Document)doc, dobj.getPrimaryFile(), false).isXmlSyntax());
        }
        return new JspSyntaxSupport(doc, false);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return null;
    }

    public CompletionJavaDoc createCompletionJavaDoc(ExtEditorUI extEditorUI) {
        return null;
    }

    protected void initDocument(BaseDocument doc) {
        doc.addLayer((DrawLayer)new JavaDrawLayerFactory.JavaLayer(), 1010);
        doc.addDocumentListener((DocumentListener)new JavaDrawLayerFactory.LParenWatcher());
        doc.addLayer((DrawLayer)new ELDrawLayerFactory.ELLayer(), 1010);
        doc.addDocumentListener((DocumentListener)new ELDrawLayerFactory.LParenWatcher());
        doc.addDocumentListener((DocumentListener)new HTMLDrawLayerFactory.TagParenWatcher());
    }

    public Formatter createFormatter() {
        return new JspFormatter(((Object)((Object)this)).getClass());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JSPKit.class);
    }

    private static TokenContextPath getTokenContextPath(Caret caret, Document doc) {
        if (doc instanceof BaseDocument) {
            int dotPos = caret.getDot();
            ExtSyntaxSupport sup = (ExtSyntaxSupport)((BaseDocument)doc).getSyntaxSupport();
            if (dotPos > 0) {
                try {
                    TokenItem token = sup.getTokenChain(dotPos - 1, dotPos);
                    if (token != null) {
                        return token.getTokenContextPath();
                    }
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify(16, (Throwable)ble);
                }
            }
        }
        return null;
    }

    public static class JspJavaGenerateGotoPopupAction
    extends JavaKit.JavaGenerateGoToPopupAction {
        protected void addAction(JTextComponent target, JMenu menu, String actionName) {
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            if (kit == null) {
                return;
            }
            Action a = kit.getActionByName(actionName);
            if (a != null) {
                if ("goto-source".equals(actionName) || "goto-declaration".equals(actionName) || "goto-super-implementation".equals(actionName)) {
                    a.setEnabled(this.isJavaContext(target));
                }
                this.addAction(target, menu, a);
            } else {
                menu.addSeparator();
            }
        }

        private boolean isJavaContext(JTextComponent target) {
            JspSyntaxSupport sup = (JspSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)target);
            int carretOffset = target.getCaret().getDot();
            try {
                TokenItem tok = sup.getTokenChain(carretOffset, carretOffset + 1);
                return tok.getTokenContextPath().contains(JavaTokenContext.contextPath);
            }
            catch (BadLocationException e) {
                return true;
            }
        }
    }

    public static class JspDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public JspDeleteCharAction(String nm, boolean nextChar) {
            super(nm, nextChar);
        }

        public void actionPerformed(ActionEvent e, JTextComponent target) {
            Action action;
            JavaKit jkit;
            TokenContextPath path;
            if (target != null && (path = JSPKit.getTokenContextPath(target.getCaret(), target.getDocument())) != null && path.contains(JavaTokenContext.contextPath) && (jkit = (JavaKit)BaseKit.getKit(JavaKit.class)) != null && (action = jkit.getActionByName("delete-previous")) != null && action instanceof JavaKit.JavaDeleteCharAction) {
                ((JavaKit.JavaDeleteCharAction)action).actionPerformed(e, target);
                return;
            }
            super.actionPerformed(e, target);
        }
    }

    public static class JspDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        public void actionPerformed(ActionEvent e, JTextComponent target) {
            Action action;
            JavaKit jkit;
            TokenContextPath path;
            if (target != null && (path = JSPKit.getTokenContextPath(target.getCaret(), target.getDocument())) != null && path.contains(JavaTokenContext.contextPath) && (jkit = (JavaKit)BaseKit.getKit(JavaKit.class)) != null && (action = jkit.getActionByName("default-typed")) != null && action instanceof JavaKit.JavaDefaultKeyTypedAction) {
                ((JavaKit.JavaDefaultKeyTypedAction)action).actionPerformed(e, target);
                return;
            }
            super.actionPerformed(e, target);
        }
    }

    public static class JspInsertBreakAction
    extends BaseKit.InsertBreakAction {
        public void actionPerformed(ActionEvent e, JTextComponent target) {
            Action action;
            JavaKit jkit;
            TokenContextPath path;
            if (target != null && (path = JSPKit.getTokenContextPath(target.getCaret(), target.getDocument())) != null && path.contains(JavaTokenContext.contextPath) && (jkit = (JavaKit)BaseKit.getKit(JavaKit.class)) != null && (action = jkit.getActionByName("insert-break")) != null && action instanceof JavaKit.JavaInsertBreakAction) {
                ((JavaKit.JavaInsertBreakAction)action).actionPerformed(e, target);
                return;
            }
            super.actionPerformed(e, target);
        }
    }

    public static class CollapseAllScriptingFolds
    extends BaseAction {
        public CollapseAllScriptingFolds() {
            super(JSPKit.collapseAllScriptingAction);
            this.putValue("ShortDescription", NbBundle.getBundle(JSPKit.class).getString(JSPKit.collapseAllScriptingAction));
            this.putValue("PopupMenuText", NbBundle.getBundle(JSPKit.class).getString("popup-collapse-all-scripting-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, (FoldType)JspFoldTypes.SCRIPTLET);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, (FoldType)JspFoldTypes.DECLARATION);
        }
    }

    public static class ExpandAllScriptingFolds
    extends BaseAction {
        public ExpandAllScriptingFolds() {
            super(JSPKit.expandAllScriptingAction);
            this.putValue("ShortDescription", NbBundle.getBundle(JSPKit.class).getString(JSPKit.expandAllScriptingAction));
            this.putValue("PopupMenuText", NbBundle.getBundle(JSPKit.class).getString("popup-expand-all-scripting-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.expand((FoldHierarchy)hierarchy, (FoldType)JspFoldTypes.SCRIPTLET);
            FoldUtilities.expand((FoldHierarchy)hierarchy, (FoldType)JspFoldTypes.DECLARATION);
        }
    }

    public static class CollapseAllCommentsFolds
    extends BaseAction {
        public CollapseAllCommentsFolds() {
            super(JSPKit.collapseAllCommentsAction);
            this.putValue("ShortDescription", NbBundle.getBundle(JSPKit.class).getString(JSPKit.collapseAllCommentsAction));
            this.putValue("PopupMenuText", NbBundle.getBundle(JSPKit.class).getString("popup-collapse-all-comment-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, (FoldType)JspFoldTypes.COMMENT);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, (FoldType)JspFoldTypes.HTML_COMMENT);
        }
    }

    public static class ExpandAllCommentsFolds
    extends BaseAction {
        public ExpandAllCommentsFolds() {
            super(JSPKit.expandAllCommentsAction);
            this.putValue("ShortDescription", NbBundle.getBundle(JSPKit.class).getString(JSPKit.expandAllCommentsAction));
            this.putValue("PopupMenuText", NbBundle.getBundle(JSPKit.class).getString("popup-expand-all-comment-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.expand((FoldHierarchy)hierarchy, (FoldType)JspFoldTypes.COMMENT);
            FoldUtilities.expand((FoldHierarchy)hierarchy, (FoldType)JspFoldTypes.HTML_COMMENT);
        }
    }

    public static class JspGenerateFoldPopupAction
    extends NbEditorKit.GenerateFoldPopupAction {
        protected void addAdditionalItems(JTextComponent target, JMenu menu) {
            this.addAction(target, menu, JSPKit.collapseAllCommentsAction);
            this.addAction(target, menu, JSPKit.expandAllCommentsAction);
            this.setAddSeparatorBeforeNextAction(true);
            this.addAction(target, menu, JSPKit.collapseAllScriptingAction);
            this.addAction(target, menu, JSPKit.expandAllScriptingAction);
        }
    }

    public static class MatchBraceAction
    extends ExtKit.MatchBraceAction {
        private boolean select;

        public MatchBraceAction(String name, boolean select) {
            super(name, select);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block13: {
                if (target != null) {
                    try {
                        Action action;
                        Caret caret = target.getCaret();
                        BaseDocument doc = Utilities.getDocument((JTextComponent)target);
                        int dotPos = caret.getDot();
                        ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
                        TokenItem token = sup.getTokenChain(dotPos - 1, dotPos);
                        if (token != null && token.getTokenContextPath().contains(JspTagTokenContext.contextPath)) {
                            int[] matchBlk;
                            if (dotPos > 0 && (matchBlk = sup.findMatchingBlock(dotPos - 1, false)) != null) {
                                if (this.select) {
                                    caret.moveDot(matchBlk[1]);
                                } else {
                                    caret.setDot(matchBlk[1]);
                                }
                            }
                            break block13;
                        }
                        BaseKit kit = null;
                        try {
                            if (token != null && token.getTokenContextPath().contains(HTMLTokenContext.contextPath)) {
                                ((Object)((Object)this)).getClass();
                                kit = BaseKit.getKit(Class.forName("org.netbeans.modules.editor.html.HTMLKit"));
                            } else if (token != null && token.getTokenContextPath().contains(JavaTokenContext.contextPath)) {
                                ((Object)((Object)this)).getClass();
                                kit = BaseKit.getKit(Class.forName("org.netbeans.modules.editor.java.JavaKit"));
                            }
                        }
                        catch (ClassNotFoundException e) {
                            kit = null;
                            ErrorManager.getDefault().notify(16, (Throwable)e);
                        }
                        if (kit != null && (action = kit.getActionByName(this.select ? "selection-match-brace" : "match-brace")) != null && action instanceof ExtKit.MatchBraceAction) {
                            ((ExtKit.MatchBraceAction)action).actionPerformed(evt, target);
                            return;
                        }
                        super.actionPerformed(evt, target);
                    }
                    catch (BadLocationException e) {
                        target.getToolkit().beep();
                    }
                }
            }
        }
    }

    private static class ColoringListener
    implements PropertyChangeListener {
        private Document doc;
        private Object parsedDataRef;
        private Jsp11Syntax syntax;

        public ColoringListener(Document doc, JSPColoringData data, Jsp11Syntax syntax) {
            this.doc = doc;
            this.parsedDataRef = data;
            this.syntax = syntax;
            syntax.listenerReference = this;
            syntax.data = data;
        }

        private void recolor() {
            if (this.doc instanceof BaseDocument) {
                ((BaseDocument)this.doc).invalidateSyntaxMarks();
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.syntax == null) {
                return;
            }
            if (this.syntax.listenerReference != this) {
                this.syntax = null;
                return;
            }
            if ("coloringChange".equals(evt.getPropertyName())) {
                this.recolor();
            }
        }
    }
}

