/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.awt.Color;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.web.core.syntax.JspJavaSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.AttributeValueSupport;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionQuery;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class AttrSupports {

    public static class EncodingSupport
    extends AttributeValueSupport.Default {
        public EncodingSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator<String> iter = Charset.availableCharsets().keySet().iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            return list;
        }
    }

    public static class PageLanguage
    extends AttributeValueSupport.Default {
        public PageLanguage() {
            super(false, "page", "language");
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("java");
            return list;
        }
    }

    public static class TrueFalseSupport
    extends AttributeValueSupport.Default {
        public TrueFalseSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("false");
            list.add("true");
            return list;
        }
    }

    public static class FilenameSupport
    extends AttributeValueSupport.Default {
        static final ImageIcon PACKAGE_ICON = new ImageIcon(Utilities.loadImage((String)"org/openide/loaders/defaultFolder.gif"));
        private int itemOffset;
        private int itemLength;

        public FilenameSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            return new ArrayList();
        }

        public CompletionQuery.Result getResult(JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement.TagDirective item, String valuePart) {
            List res = this.completionResults(offset, sup, item, valuePart);
            return new JspCompletionQuery.JspCompletionResult(component, this.completionTitle(), res, this.itemOffset, this.itemLength, -1);
        }

        private List completionResults(int offset, JspSyntaxSupport sup, SyntaxElement.TagDirective item, String valuePart) {
            List<JspCompletionItem.FileAttributeValue> res = new ArrayList();
            String path = "";
            String fileNamePart = valuePart;
            int lastSlash = valuePart.lastIndexOf(47);
            if (lastSlash == 0) {
                path = "/";
                fileNamePart = valuePart.substring(1);
            } else if (lastSlash > 0) {
                path = valuePart.substring(0, lastSlash);
                fileNamePart = lastSlash == valuePart.length() ? "" : valuePart.substring(lastSlash + 1);
            }
            try {
                FileObject orig = sup.getFileObject();
                FileObject fileObject = JspUtils.guessWebModuleRoot((Document)sup.getDocument(), orig);
                String ctxPath = JspUtils.resolveRelativeURL("/" + orig.getPath(), path);
                ctxPath = path.startsWith("/") ? fileObject.getPath() + path : ctxPath.substring(1);
                FileSystem fs = orig.getFileSystem();
                FileObject folder = fs.findResource(ctxPath);
                if (folder != null) {
                    res = this.files(folder, fileNamePart, sup);
                    if (!(folder.equals(fileObject) || path.startsWith("/") || path.length() != 0 && path.lastIndexOf("../") + 3 != path.length())) {
                        res.add(0, new JspCompletionItem.FileAttributeValue("../", Color.BLUE, PACKAGE_ICON));
                    }
                }
            }
            catch (FileStateInvalidException ex) {
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            this.itemOffset = offset - valuePart.length() + lastSlash + 1;
            this.itemLength = fileNamePart.length();
            for (JspCompletionItem.JspResultItem jspResultItem : res) {
                jspResultItem.setSubstituteOffset(this.itemOffset);
            }
            return res;
        }

        private List files(FileObject folder, String prefix, JspSyntaxSupport sup) {
            ArrayList res = new ArrayList();
            TreeMap<String, JspCompletionItem.FileAttributeValue> resFolders = new TreeMap<String, JspCompletionItem.FileAttributeValue>();
            TreeMap<String, JspCompletionItem.FileAttributeValue> resFiles = new TreeMap<String, JspCompletionItem.FileAttributeValue>();
            Enumeration files = folder.getChildren(false);
            while (files.hasMoreElements()) {
                FileObject file = (FileObject)files.nextElement();
                String fname = file.getNameExt();
                if (!fname.startsWith(prefix) || "cvs".equalsIgnoreCase(fname)) continue;
                if (file.isFolder()) {
                    resFolders.put(file.getNameExt(), new JspCompletionItem.FileAttributeValue(file.getNameExt() + "/", Color.BLUE, PACKAGE_ICON));
                    continue;
                }
                Image icon = JspUtils.getIcon((Document)sup.getDocument(), file);
                if (icon != null) {
                    resFiles.put(file.getNameExt(), new JspCompletionItem.FileAttributeValue(file.getNameExt(), Color.BLACK, new ImageIcon(icon)));
                    continue;
                }
                resFiles.put(file.getNameExt(), new JspCompletionItem.FileAttributeValue(file.getNameExt(), Color.BLACK));
            }
            res.addAll(resFolders.values());
            res.addAll(resFiles.values());
            return res;
        }
    }

    public static class TaglibTagdir
    extends AttributeValueSupport.Default {
        public TaglibTagdir() {
            super(false, "taglib", "tagdir");
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            FileObject webInfTags;
            ArrayList<String> l = new ArrayList<String>();
            FileObject orig = sup.getFileObject();
            FileObject documentBase = JspUtils.guessWebModuleRoot((Document)sup.getDocument(), orig);
            if (documentBase != null && (webInfTags = JspUtils.findRelativeFileObject(documentBase, "WEB-INF/tags")) != null) {
                if (this.isValidTagDir(webInfTags)) {
                    l.add(JspUtils.findRelativeContextPath(documentBase, webInfTags));
                }
                Enumeration en = webInfTags.getFolders(true);
                while (en.hasMoreElements()) {
                    FileObject subF = (FileObject)en.nextElement();
                    if (!this.isValidTagDir(subF)) continue;
                    l.add(JspUtils.findRelativeContextPath(documentBase, subF));
                }
            }
            Collections.sort(l);
            return l;
        }

        private boolean isValidTagDir(FileObject subF) {
            return subF.getChildren(false).hasMoreElements();
        }
    }

    public static class TaglibURI
    extends AttributeValueSupport.Default {
        public TaglibURI() {
            super(false, "taglib", "uri");
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> l = new ArrayList<String>();
            Map m = sup.getTagLibraryMappings();
            if (m != null) {
                for (String s : m.keySet()) {
                    l.add(s);
                }
            }
            Collections.sort(l);
            return l;
        }
    }

    public static class SetPropertyProperty
    extends GetSetPropertyProperty {
        public SetPropertyProperty() {
            super(true, "jsp:setProperty", "property");
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            List l = this.possibleValues(sup, item, true);
            l.add(0, "*");
            return l;
        }
    }

    public static class GetPropertyProperty
    extends GetSetPropertyProperty {
        public GetPropertyProperty() {
            super(true, "jsp:getProperty", "property");
        }

        public List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            return this.possibleValues(sup, item, false);
        }
    }

    public static abstract class GetSetPropertyProperty
    extends AttributeValueSupport.Default {
        public GetSetPropertyProperty(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item, boolean setter) {
            ArrayList<String> list = new ArrayList<String>();
            String namePropertyValue = (String)item.getAttributes().get("name");
            if (namePropertyValue != null) {
                String className = null;
                PageInfo.BeanData[] beanData = sup.getBeanData();
                for (int i = 0; i < beanData.length; ++i) {
                    if (beanData[i] == null || beanData[i].getId() == null || !beanData[i].getId().equals(namePropertyValue)) continue;
                    className = beanData[i].getClassName();
                    break;
                }
                if (className != null) {
                    try {
                        FileObject fo = NbEditorUtilities.getDataObject((Document)sup.getDocument()).getPrimaryFile();
                        URLClassLoader cld = JspUtils.getModuleClassLoader((Document)sup.getDocument(), fo);
                        Class<?> beanClass = Class.forName(className, false, cld);
                        Introspector.flushFromCaches(beanClass);
                        BeanInfo benInfo = Introspector.getBeanInfo(beanClass);
                        PropertyDescriptor[] properties = benInfo.getPropertyDescriptors();
                        for (int j = 0; j < properties.length; ++j) {
                            if (setter && properties[j].getWriteMethod() != null) {
                                list.add(properties[j].getName());
                            }
                            if (setter || properties[j].getReadMethod() == null || properties[j].getName().equals("class")) continue;
                            list.add(properties[j].getName());
                        }
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (IntrospectionException e) {
                        // empty catch block
                    }
                }
            }
            return list;
        }
    }

    public static class GetSetPropertyName
    extends AttributeValueSupport.Default {
        public GetSetPropertyName(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            PageInfo.BeanData[] beanData = sup.getBeanData();
            if (beanData != null) {
                for (int i = 0; i < beanData.length; ++i) {
                    list.add(beanData[i].getId());
                }
            }
            return list;
        }
    }

    public static class PackageClassSupport
    extends AttributeValueSupport.Default {
        private int itemOffset;
        private int itemLength;

        public PackageClassSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            return new ArrayList();
        }

        public CompletionQuery.Result getResult(JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement.TagDirective item, String valuePart) {
            if (valuePart.lastIndexOf(44) > 0) {
                valuePart = valuePart.substring(valuePart.lastIndexOf(44) + 1).trim();
            }
            List res = this.completionResults(offset, sup, item, valuePart);
            return new JspCompletionQuery.JspJavaCompletionResult(component, res, this.completionTitle(), null, this.itemOffset, this.itemLength, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List completionResults(int offset, JspSyntaxSupport sup, SyntaxElement.TagDirective item, String valuePart) {
            JMIUtils jmiutils = JMIUtils.get((BaseDocument)sup.getDocument());
            JspJavaSyntaxSupport jspJavaSup = new JspJavaSyntaxSupport(sup.getDocument(), sup);
            JavaClass context = jspJavaSup.getJavaClass(0);
            jmiutils.beginTrans(false);
            try {
                String pkgName = "";
                JavaPackage pkg = null;
                String clsNamePart = valuePart;
                int lastDot = valuePart.lastIndexOf(46);
                if (lastDot >= 0) {
                    pkgName = valuePart.substring(0, lastDot);
                    pkg = jmiutils.getExactPackage(pkgName);
                    clsNamePart = lastDot == valuePart.length() ? "" : valuePart.substring(lastDot + 1);
                }
                this.itemOffset = offset - valuePart.length() + lastDot + 1;
                this.itemLength = clsNamePart.length();
                ArrayList res = new ArrayList();
                res.addAll(jmiutils.findPackages(valuePart, false, false, true));
                if (pkg != null) {
                    res.addAll(jmiutils.findClasses(pkg, clsNamePart, false, true, true, context, true, false));
                }
                for (NbJMIResultItem jmiResultItem : res) {
                    jmiResultItem.setSubstituteOffset(this.itemOffset);
                }
                ArrayList arrayList = res;
                return arrayList;
            }
            finally {
                jmiutils.endTrans(false);
            }
        }
    }

    public static class YesNoTrueFalseSupport
    extends AttributeValueSupport.Default {
        public YesNoTrueFalseSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("false");
            list.add("no");
            list.add("true");
            list.add("yes");
            return list;
        }
    }

    public static class VariableScopeSupport
    extends AttributeValueSupport.Default {
        public VariableScopeSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("AT_BEGIN");
            list.add("AT_END");
            list.add("NESTED");
            return list;
        }
    }

    public static class PluginTypeSupport
    extends AttributeValueSupport.Default {
        public PluginTypeSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("bean");
            list.add("applet");
            return list;
        }
    }

    public static class RootVersionSupport
    extends AttributeValueSupport.Default {
        public RootVersionSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("1.2");
            list.add("2.0");
            return list;
        }
    }

    public static class ScopeSupport
    extends AttributeValueSupport.Default {
        public ScopeSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("application");
            list.add("page");
            list.add("request");
            list.add("session");
            return list;
        }
    }
}

