/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.fileupload;

import com.sun.javaee.blueprints.components.ui.util.Util;
import java.io.IOException;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.XhtmlHelper;

public class FileUploadRenderer
extends Renderer {
    private boolean bDebug = false;
    private static final String RENDERED_SCRIPT_KEY = "bpcatalog-ajax-script-fileupload";
    private static final String DOJO_SCRIPT_RESOURCE = "/META-INF/dojo/v0_3/dojo.js";
    private static final String FILEUPLOAD_SCRIPT_RESOURCE = "/META-INF/fileupload/fileupload.js";
    private static final String FILEUPLOAD_CSS_RESOURCE = "/META-INF/fileupload/fileupload.css";
    private static final String COMMON_SCRIPT_RESOURCE = "/META-INF/common/script.js";
    private static XhtmlHelper helper = new XhtmlHelper();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HtmlForm outComp = (HtmlForm)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderScriptOnce(writer, component, context);
        String id = (String)outComp.getAttributes().get("id");
        String serverLocationDir = (String)Util.getAttributeValue(context, component, "serverLocationDir");
        String retFunction = (String)Util.getAttributeValue(context, component, "retFunction");
        String retMimeType = (String)Util.getAttributeValue(context, component, "retMimeType");
        String progressBarDivId = (String)Util.getAttributeValue(context, component, "progressBarDivId");
        String progressBarSubmitId = (String)Util.getAttributeValue(context, component, "progressBarSubmitId");
        String progressBarSize = (String)Util.getAttributeValue(context, component, "progressBarSize");
        outComp.setEnctype("multipart/form-data");
        if (retFunction == null) {
            retFunction = "bpui.fileupload.defaultRetFunction";
        }
        if (retMimeType == null) {
            retMimeType = "text/xml";
        }
        if (progressBarDivId != null) {
            if (progressBarSize == null) {
                progressBarSize = "40";
            }
            if (progressBarSubmitId == null) {
                progressBarSubmitId = "";
            }
            String progressCallback = helper.mapResourceId(context, Mechanism.DYNAMIC_RESOURCE, "/bpui_fileupload_handler/handleFileStatus");
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write("\nbpui.fileupload.progressComplete[\"" + progressBarDivId + "\"]=new bpui.fileupload.progressComp('" + progressBarSubmitId + "', '" + progressBarDivId + "', " + progressBarSize + ", '" + progressCallback + "');");
            writer.write("\nbpui.fileupload.progressComplete[\"" + progressBarDivId + "\"].processProgressRequest=bpui.fileupload.progressReturnFunction('" + progressBarSubmitId + "', '" + progressBarDivId + "', " + progressBarSize + ");\n");
            writer.endElement("script");
        }
        if (progressBarDivId == null) {
            progressBarDivId = "";
        }
        String fileUploadCallback = helper.mapResourceId(context, Mechanism.DYNAMIC_RESOURCE, "/bpui_fileupload_handler/handleFileUpload");
        outComp.setOnsubmit("return bpui.fileupload.submitForm(this, '" + retMimeType + "', '" + retFunction + "','" + progressBarDivId + "', '" + fileUploadCallback + "')");
        if (this.bDebug) {
            System.out.println("Renderer Data - " + id + " - " + serverLocationDir + " - " + retFunction + " - " + retMimeType);
        }
        Renderer baseRenderer = context.getRenderKit().getRenderer("javax.faces.Form", "javax.faces.Form");
        baseRenderer.encodeBegin(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MethodExpression methodName;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HtmlForm outComp = (HtmlForm)component;
        ResponseWriter writer = context.getResponseWriter();
        String id = (String)outComp.getAttributes().get("id");
        String serverLocationDir = (String)Util.getAttributeValue(context, component, "serverLocationDir");
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)"componentName", null);
        writer.writeAttribute("value", (Object)id, null);
        writer.endElement("input");
        writer.write("\n");
        if (serverLocationDir != null) {
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", (Object)(id + "_" + "serverLocationDir"), null);
            writer.writeAttribute("value", (Object)serverLocationDir, null);
            writer.endElement("input");
            writer.write("\n");
        }
        if ((methodName = (MethodExpression)outComp.getAttributes().get("postProcessingMethod")) != null) {
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", (Object)(id + "_" + "postProcessingMethod"), null);
            writer.writeAttribute("value", (Object)methodName.getExpressionString(), null);
            writer.endElement("input");
            writer.write("\n");
        }
        Renderer baseRenderer = context.getRenderKit().getRenderer("javax.faces.Form", "javax.faces.Form");
        baseRenderer.encodeEnd(context, component);
    }

    private void renderScriptOnce(ResponseWriter writer, UIComponent component, FacesContext context) throws IOException {
        Map requestMap = context.getExternalContext().getRequestMap();
        Boolean scriptRendered = (Boolean)requestMap.get(RENDERED_SCRIPT_KEY);
        if (scriptRendered != null && scriptRendered.equals(Boolean.TRUE)) {
            return;
        }
        requestMap.put(RENDERED_SCRIPT_KEY, Boolean.TRUE);
        writer.write("\n");
        helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, COMMON_SCRIPT_RESOURCE);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("\n");
        writer.write("if (typeof dojo == 'undefined') {\n");
        writer.write("    bpui.load(\"" + helper.mapResourceId(context, Mechanism.CLASS_RESOURCE, DOJO_SCRIPT_RESOURCE) + "\");\n");
        writer.write("}\n");
        writer.endElement("script");
        writer.write("\n");
        helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, FILEUPLOAD_SCRIPT_RESOURCE);
        helper.linkStylesheet(context, component, writer, Mechanism.CLASS_RESOURCE, FILEUPLOAD_CSS_RESOURCE);
    }
}

