/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.renderkit;

import java.io.IOException;
import java.io.Writer;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseRenderer
extends Renderer {
    public static final String BUNDLE_ATTR = "com.sun.faces.bundle";

    public String convertClientId(FacesContext context, String clientId) {
        return clientId;
    }

    public ResponseWriter setupResponseWriter(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (writer == null) {
            HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = renderFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
            writer = renderKit.createResponseWriter((Writer)response.getWriter(), "text/html", request.getCharacterEncoding());
            context.setResponseWriter(writer);
        }
        return writer;
    }

    protected String getKeyAndLookupInBundle(FacesContext context, UIComponent component, String keyAttr) throws MissingResourceException {
        String key = null;
        String bundleName = null;
        ResourceBundle bundle = null;
        key = (String)component.getAttributes().get(keyAttr);
        bundleName = (String)component.getAttributes().get(BUNDLE_ATTR);
        if (bundleName == null) {
            UIViewRoot root = context.getViewRoot();
            bundleName = (String)root.getAttributes().get(BUNDLE_ATTR);
        }
        if (null == key || null == bundleName) {
            throw new MissingResourceException("Can't load JSTL classes", bundleName, key);
        }
        if (null == Thread.currentThread().getContextClassLoader().getResource("javax.servlet.jsp.jstl.fmt.LocalizationContext")) {
            Object[] params = new Object[]{"javax.servlet.jsp.jstl.fmt.LocalizationContext"};
            throw new MissingResourceException("Can't load JSTL classes", bundleName, key);
        }
        return bundle.getString(key);
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            for (UIComponent kid : component.getChildren()) {
                this.encodeRecursive(context, kid);
            }
        }
        component.encodeEnd(context);
    }
}

