/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.javadoc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.editor.ext.html.javadoc.SAXHelpHandler;
import org.netbeans.editor.ext.html.javadoc.TagHelpItem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.xml.sax.helpers.DefaultHandler;

public class HelpManager {
    private static HelpManager manager = null;
    private Hashtable helpMap = null;
    private long lastChange = 0L;
    private String helpZipURL = null;
    private URL lastURL = null;

    private HelpManager() {
    }

    public static HelpManager getDefault() {
        if (manager == null) {
            manager = new HelpManager();
        }
        return manager;
    }

    private void init() {
        block7: {
            if (this.helpMap != null) {
                return;
            }
            String help = "";
            try {
                if (this.helpMap != null) break block7;
                InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/editor/ext/html/javadoc/resources/HtmlHelp.xml");
                if (in == null) {
                    this.helpMap = new Hashtable();
                    return;
                }
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                SAXHelpHandler handler = new SAXHelpHandler();
                Date start = new Date();
                parser.parse(in, (DefaultHandler)handler);
                in.close();
                help = handler.getHelpFile();
                if (help == null || help.equals("")) {
                    help = null;
                    this.helpMap = new Hashtable();
                    return;
                }
                this.helpMap = handler.getMap();
                String url = "";
                File f = InstalledFileLocator.getDefault().locate(help, null, false);
                if (f == null) break block7;
                try {
                    URL urll = f.toURL();
                    urll = FileUtil.getArchiveRoot((URL)urll);
                    this.helpZipURL = urll.toString();
                }
                catch (MalformedURLException e) {
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                    this.helpMap = new Hashtable();
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorManager.getDefault().log(e.toString());
            }
        }
    }

    public URL getRelativeHelpToLast(String link) {
        return this.getRelativeURL(this.lastURL, link);
    }

    public URL getRelativeURL(URL baseurl, String link) {
        String url = baseurl.toString();
        if (link.trim().charAt(0) == '#') {
            int index = url.indexOf(35);
            if (index > -1) {
                url = url.substring(0, url.indexOf(35));
            }
            url = url + link;
        } else {
            int index = 0;
            url = url.substring(0, url.lastIndexOf(47));
            while ((index = link.indexOf("../", index)) > -1) {
                url = url.substring(0, url.lastIndexOf(47));
                link = link.substring(index + 3);
            }
            url = url + "/" + link;
        }
        URL newURL = null;
        try {
            newURL = new URL(url);
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().log(e.toString());
            return null;
        }
        return newURL;
    }

    public String getHelp(String key) {
        if (key == null) {
            return null;
        }
        return this.getHelp(this.findHelpItem(key));
    }

    public String getHelp(TagHelpItem helpItem) {
        URL url = this.getHelpURL(helpItem);
        if (url == null) {
            return null;
        }
        this.lastURL = url;
        String help = this.getHelpText(url);
        int offset = 0;
        if (help != null) {
            if (helpItem.getStartText() != null && (offset = help.indexOf(helpItem.getStartText())) > 0) {
                help = help.substring(offset += helpItem.getStartTextOffset());
            }
            if (helpItem.getEndText() != null && (offset = help.indexOf(helpItem.getEndText())) > 0) {
                help = help.substring(0, offset += helpItem.getEndTextOffset());
            }
        } else {
            help = "";
        }
        if (helpItem.getTextBefore() != null) {
            help = helpItem.getTextBefore() + help;
        }
        if (helpItem.getTextAfter() != null) {
            help = help + helpItem.getTextAfter();
        }
        return help;
    }

    public String getHelpText(URL url) {
        if (url == null) {
            return null;
        }
        try {
            InputStream is = url.openStream();
            byte[] buffer = new byte[1000];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int count = 0;
            do {
                if ((count = is.read(buffer)) <= 0) continue;
                baos.write(buffer, 0, count);
            } while (count > 0);
            is.close();
            String text = baos.toString();
            baos.close();
            return text;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URL getHelpURL(String key) {
        return this.getHelpURL(this.findHelpItem(key));
    }

    public URL getHelpURLForLink(String link) {
        URL url = null;
        if (link != null) {
            String surl = this.helpZipURL + link;
            try {
                url = new URL(surl);
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().log(e.toString());
                return null;
            }
        }
        return url;
    }

    public URL getHelpURL(TagHelpItem helpItem) {
        URL url = null;
        if (helpItem != null) {
            String surl = this.helpZipURL + helpItem.getFile();
            try {
                url = new URL(surl);
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().log(e.toString());
                return null;
            }
        }
        return url;
    }

    public TagHelpItem findHelpItem(String key) {
        if (key == null) {
            return null;
        }
        this.init();
        Object o = this.helpMap.get(key.toUpperCase());
        if (o != null) {
            TagHelpItem helpItem = (TagHelpItem)o;
            if (helpItem != null) {
                while (helpItem != null && helpItem.getIdentical() != null) {
                    helpItem = (TagHelpItem)this.helpMap.get(helpItem.getIdentical().toUpperCase());
                }
            }
            return helpItem;
        }
        return null;
    }

    public String getHelpText(URL url, String anchor) {
        String pattern = "<a name=\"" + anchor + "\"";
        String text = this.getHelpText(url);
        BufferedReader br = new BufferedReader(new StringReader(text));
        String line = null;
        StringBuffer textAfterAnchor = null;
        int prestack = 0;
        try {
            while ((line = br.readLine()) != null) {
                if (line.indexOf(pattern) != -1) {
                    textAfterAnchor = new StringBuffer();
                    textAfterAnchor.append(line.substring(line.indexOf(pattern)));
                    continue;
                }
                if (textAfterAnchor == null) continue;
                if (line.indexOf("<pre") != -1) {
                    ++prestack;
                }
                if (line.indexOf("</pre") != -1) {
                    --prestack;
                }
                textAfterAnchor.append(line + "\n");
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        return textAfterAnchor == null ? null : "<html><body>" + (prestack < 0 ? "<pre>" : "") + textAfterAnchor.toString();
    }

    public String getAnchorText(URL url) {
        String link = url.toExternalForm();
        if (link.indexOf(35) != -1) {
            return link.substring(link.indexOf(35) + 1);
        }
        return null;
    }
}

