/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.ErrorManager;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

abstract class BasicCustomizer
implements CustomizerProvider,
PropertyChangeListener {
    static final String LAST_SELECTED_PANEL = "lastSelectedPanel";
    private final Project project;
    private Dialog dialog;
    private ProjectCustomizer.CategoryComponentProvider panelProvider;
    private ProjectCustomizer.Category[] categories;
    private Component lastSelectedPanel;
    private final Map panels = new HashMap();

    protected BasicCustomizer(Project project) {
        this.project = project;
    }

    abstract void storeProperties() throws IOException;

    abstract void prepareData();

    protected void setCategories(ProjectCustomizer.Category[] categories) {
        this.categories = categories;
    }

    protected Project getProject() {
        return this.project;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String preselectedCategory) {
        this.showCustomizer(preselectedCategory, null);
    }

    public void showCustomizer(String preselectedCategory, String preselectedSubCategory) {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
            return;
        }
        this.prepareData();
        OptionListener listener = new OptionListener();
        if (preselectedCategory == null) {
            preselectedCategory = this.findLastSelectedCategory();
        }
        if (this.categories == null) {
            return;
        }
        this.dialog = ProjectCustomizer.createCustomizerDialog((ProjectCustomizer.Category[])this.categories, (ProjectCustomizer.CategoryComponentProvider)this.getPanelProvider(), (String)preselectedCategory, (ActionListener)listener, null);
        this.dialog.addWindowListener(listener);
        this.dialog.setTitle(NbBundle.getMessage(this.getClass(), (String)"LBL_CustomizerTitle", (Object)ProjectUtils.getInformation((Project)this.getProject()).getDisplayName()));
        this.dialog.setVisible(true);
        if (preselectedCategory != null && preselectedSubCategory != null) {
            for (int i = 0; i < this.categories.length; ++i) {
                if (!preselectedCategory.equals(this.categories[i].getName())) continue;
                JComponent component = this.panelProvider.create(this.categories[i]);
                if (!(component instanceof SubCategoryProvider)) break;
                ((SubCategoryProvider)((Object)component)).showSubCategory(preselectedSubCategory);
                break;
            }
        }
        Iterator it = this.panels.values().iterator();
        while (it.hasNext()) {
            NbPropertyPanel panel = (NbPropertyPanel)it.next();
            panel.checkForm();
        }
    }

    protected void createCategoryPanel(String progName, String displayNameKey, NbPropertyPanel panel) {
        ProjectCustomizer.Category category = ProjectCustomizer.Category.create((String)progName, (String)NbBundle.getMessage(this.getClass(), (String)displayNameKey), null, null);
        this.createPanel(category, panel);
    }

    protected ProjectCustomizer.Category createCategory(String progName, String displayNameKey) {
        return ProjectCustomizer.Category.create((String)progName, (String)NbBundle.getMessage(this.getClass(), (String)displayNameKey), null, null);
    }

    protected void createPanel(ProjectCustomizer.Category category, NbPropertyPanel panel) {
        this.panels.put(category, panel);
    }

    protected void listenToPanels() {
        Iterator it = this.panels.values().iterator();
        while (it.hasNext()) {
            ((Component)it.next()).addPropertyChangeListener(this);
        }
    }

    private ProjectCustomizer.Category findCategory(Object panel) {
        Iterator it = this.panels.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!panel.equals(entry.getValue())) continue;
            return (ProjectCustomizer.Category)entry.getKey();
        }
        throw new IllegalArgumentException(panel + " panel is not known in this customizer");
    }

    public void save() {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    BasicCustomizer.this.storeProperties();
                    return null;
                }
            });
            ProjectManager.getDefault().saveProject(this.project);
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((Throwable)((IOException)e.getException()));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName == "isPanelValid") {
            this.findCategory(evt.getSource()).setValid(((Boolean)evt.getNewValue()).booleanValue());
        } else if (propertyName == "errorMessage") {
            this.findCategory(evt.getSource()).setErrorMessage((String)evt.getNewValue());
        } else if (propertyName == LAST_SELECTED_PANEL) {
            this.lastSelectedPanel = (Component)evt.getSource();
        }
    }

    private ProjectCustomizer.CategoryComponentProvider getPanelProvider() {
        if (this.panelProvider == null) {
            this.panelProvider = new ProjectCustomizer.CategoryComponentProvider(){

                public JComponent create(ProjectCustomizer.Category category) {
                    JComponent panel = (JComponent)BasicCustomizer.this.panels.get(category);
                    return panel == null ? new JPanel() : panel;
                }
            };
        }
        return this.panelProvider;
    }

    private String findLastSelectedCategory() {
        String preselectedCategory = null;
        Iterator it = this.panels.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Component panel = (Component)entry.getValue();
            if (panel != this.lastSelectedPanel) continue;
            preselectedCategory = ((ProjectCustomizer.Category)entry.getKey()).getName();
            break;
        }
        return preselectedCategory;
    }

    static interface SubCategoryProvider {
        public void showSubCategory(String var1);
    }

    static interface LazyStorage {
        public void store();
    }

    protected class OptionListener
    extends WindowAdapter
    implements ActionListener {
        protected OptionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Iterator it = BasicCustomizer.this.panels.values().iterator();
            while (it.hasNext()) {
                Object panel = it.next();
                if (!(panel instanceof LazyStorage)) continue;
                ((LazyStorage)panel).store();
            }
            BasicCustomizer.this.save();
            if (BasicCustomizer.this.dialog != null) {
                BasicCustomizer.this.dialog.setVisible(false);
                BasicCustomizer.this.dialog.dispose();
            }
        }

        public void windowClosed(WindowEvent e) {
            BasicCustomizer.this.dialog = null;
        }

        public void windowClosing(WindowEvent e) {
            if (BasicCustomizer.this.dialog != null) {
                BasicCustomizer.this.dialog.setVisible(false);
                BasicCustomizer.this.dialog.dispose();
            }
        }
    }
}

