/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.spi.ejbjar.support;

import java.io.IOException;
import javax.sql.DataSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public final class EjbEnterpriseReferenceContainerSupport {
    private EjbEnterpriseReferenceContainerSupport() {
    }

    public static EnterpriseReferenceContainer createEnterpriseReferenceContainer(Project project, AntProjectHelper helper) {
        return new ERC(project, helper);
    }

    private static boolean isDescriptorMandatory(String j2eeVersion) {
        return "1.3".equals(j2eeVersion) || "1.4".equals(j2eeVersion);
    }

    private static class ERC
    extends EnterpriseReferenceContainer {
        private Project ejbProject;
        private AntProjectHelper antHelper;
        private static final String SERVICE_LOCATOR_PROPERTY = "project.serviceLocator.class";

        private ERC(Project p, AntProjectHelper helper) {
            this.ejbProject = p;
            this.antHelper = helper;
        }

        public String addEjbLocalReference(EjbLocalRef localRef, String referencedClassName, AntArtifact target) throws IOException {
            return this.addReference(localRef, referencedClassName, target);
        }

        public String addEjbReferernce(EjbRef ref, String referencedClassName, AntArtifact target) throws IOException {
            return this.addReference(ref, referencedClassName, target);
        }

        private String addReference(Object ref, String referencedClassName, AntArtifact target) throws IOException {
            String refName = null;
            Ejb model = this.findEjbForClass(referencedClassName);
            boolean fromSameProject = target == null || this.ejbProject.equals(target.getProject());
            EjbJar[] ejbJars = EjbJar.getEjbJars(this.ejbProject);
            assert (ejbJars.length > 0);
            if (ejbJars[0].getDeploymentDescriptor() != null) {
                EjbRef ejbRef;
                if (model == null) {
                    if (ref instanceof EjbRef) {
                        return ((EjbRef)ref).getEjbRefName();
                    }
                    return ((EjbLocalRef)ref).getEjbRefName();
                }
                if (ref instanceof EjbRef) {
                    ejbRef = (EjbRef)ref;
                    refName = this.getUniqueName(model, "EjbRef", "EjbRefName", ejbRef.getEjbRefName());
                    ejbRef.setEjbRefName(refName);
                    if (fromSameProject) {
                        ejbRef.setEjbLink(this.stripModuleName(ejbRef.getEjbLink()));
                    }
                    model.addEjbRef(ejbRef);
                } else {
                    ejbRef = (EjbLocalRef)ref;
                    refName = this.getUniqueName(model, "EjbLocalRef", "EjbRefName", ejbRef.getEjbRefName());
                    ejbRef.setEjbRefName(refName);
                    if (fromSameProject) {
                        ejbRef.setEjbLink(this.stripModuleName(ejbRef.getEjbLink()));
                    }
                    model.addEjbLocalRef((EjbLocalRef)ejbRef);
                }
                this.writeDD();
            }
            if (!fromSameProject) {
                try {
                    ProjectClassPathExtender pcpe = (ProjectClassPathExtender)this.ejbProject.getLookup().lookup(ProjectClassPathExtender.class);
                    assert (pcpe != null);
                    pcpe.addAntArtifact(target, target.getArtifactLocations()[0]);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
            ProjectManager.getDefault().saveProject(this.ejbProject);
            return refName;
        }

        public String getServiceLocatorName() {
            EditableProperties ep = this.antHelper.getProperties("nbproject/project.properties");
            return ep.getProperty(SERVICE_LOCATOR_PROPERTY);
        }

        public void setServiceLocatorName(String serviceLocator) throws IOException {
            EditableProperties ep = this.antHelper.getProperties("nbproject/project.properties");
            ep.setProperty(SERVICE_LOCATOR_PROPERTY, serviceLocator);
            this.antHelper.putProperties("nbproject/project.properties", ep);
            ProjectManager.getDefault().saveProject(this.ejbProject);
        }

        private String stripModuleName(String ejbLink) {
            int index = ejbLink.indexOf(35);
            return ejbLink.substring(index + 1);
        }

        private Ejb findEjbForClass(String className) throws IOException {
            org.netbeans.modules.j2ee.dd.api.ejb.EjbJar dd = this.findDD();
            EnterpriseBeans beans = dd.getEnterpriseBeans();
            Ejb ejb = null;
            if (beans != null) {
                ejb = (Ejb)beans.findBeanByName("Session", "EjbClass", className);
                if (ejb == null) {
                    ejb = (Ejb)beans.findBeanByName("Entity", "EjbClass", className);
                }
                if (ejb == null) {
                    ejb = (Ejb)beans.findBeanByName("MessageDriven", "EjbClass", className);
                }
            }
            return ejb;
        }

        private org.netbeans.modules.j2ee.dd.api.ejb.EjbJar findDD() throws IOException {
            EjbJar[] ejbJars = EjbJar.getEjbJars(this.ejbProject);
            assert (ejbJars.length > 0);
            return DDProvider.getDefault().getMergedDDRoot(ejbJars[0].getMetadataUnit());
        }

        private void writeDD() throws IOException {
            FileObject fo;
            EjbJar[] ejbJars = EjbJar.getEjbJars(this.ejbProject);
            assert (ejbJars.length > 0);
            if (EjbEnterpriseReferenceContainerSupport.isDescriptorMandatory(ejbJars[0].getJ2eePlatformVersion()) && (fo = ejbJars[0].getDeploymentDescriptor()) != null) {
                DDProvider.getDefault().getMergedDDRoot(ejbJars[0].getMetadataUnit()).write(fo);
            }
        }

        public String addResourceRef(ResourceRef ref, String referencingClass) throws IOException {
            Ejb ejb = this.findEjbForClass(referencingClass);
            if (ejb == null) {
                return ref.getResRefName();
            }
            String resourceRefName = ref.getResRefName();
            if (DataSource.class.getName().equals(ref.getResType())) {
                if (!this.isJdbcConnectionAlreadyUsed(ejb, ref)) {
                    resourceRefName = this.getUniqueName(ejb, "ResourceRef", "ResRefName", ref.getResRefName());
                    ref.setResRefName(resourceRefName);
                    ejb.addResourceRef(ref);
                    this.writeDD();
                }
            } else if (!ERC.isResourceRefUsed(ejb, ref)) {
                resourceRefName = this.getUniqueName(ejb, "ResourceRef", "ResRefName", ref.getResRefName());
                ref.setResRefName(resourceRefName);
                ejb.addResourceRef(ref);
                this.writeDD();
            }
            return resourceRefName;
        }

        private boolean isJdbcConnectionAlreadyUsed(Ejb ejb, ResourceRef ref) throws IOException {
            if (DataSource.class.getName().equals(ref.getResType())) {
                for (ResourceRef existingRef : ejb.getResourceRef()) {
                    boolean canCompareDefDesc;
                    String newDefaultDescription = ref.getDefaultDescription();
                    String existingDefaultDescription = existingRef.getDefaultDescription();
                    boolean bl = canCompareDefDesc = newDefaultDescription != null && existingDefaultDescription != null;
                    if (!DataSource.class.getName().equals(existingRef.getResType()) || canCompareDefDesc && !newDefaultDescription.equals(existingDefaultDescription) || !ref.getResRefName().equals(existingRef.getResRefName())) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isResourceRefUsed(Ejb ejb, ResourceRef resRef) {
            String resRefName = resRef.getResRefName();
            String resRefType = resRef.getResType();
            for (ResourceRef existingRef : ejb.getResourceRef()) {
                if (!resRefName.equals(existingRef.getResRefName()) || !resRefType.equals(existingRef.getResType())) continue;
                return true;
            }
            return false;
        }

        private String getUniqueName(Ejb bean, String beanName, String property, String originalValue) {
            String proposedValue = originalValue;
            int index = 1;
            while (bean.findBeanByName(beanName, property, proposedValue) != null) {
                proposedValue = originalValue + Integer.toString(index++);
            }
            return proposedValue;
        }

        public ResourceRef createResourceRef(String className) throws IOException {
            ResourceRef ref = null;
            Ejb ejb = this.findEjbForClass(className);
            if (ejb != null) {
                ref = ejb.newResourceRef();
            } else {
                try {
                    ref = (ResourceRef)this.findDD().createBean("ResourceRef");
                }
                catch (ClassNotFoundException cnfe) {
                    IOException ioe = new IOException();
                    ioe.initCause(cnfe);
                    throw ioe;
                }
            }
            return ref;
        }

        public String addDestinationRef(MessageDestinationRef ref, String referencingClass) throws IOException {
            Ejb ejb = this.findEjbForClass(referencingClass);
            if (ejb == null) {
                return ref.getMessageDestinationRefName();
            }
            try {
                for (MessageDestinationRef mdRef : ejb.getMessageDestinationRef()) {
                    if (!mdRef.getMessageDestinationRefName().equals(ref.getMessageDestinationRefName())) continue;
                    return mdRef.getMessageDestinationRefName();
                }
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            String destinationRefName = this.getUniqueName(ejb, "MessageDestinationRef", "MessageDestinationRefName", ref.getMessageDestinationRefName());
            ref.setMessageDestinationRefName(destinationRefName);
            try {
                ejb.addMessageDestinationRef(ref);
            }
            catch (VersionNotSupportedException vnse) {
                // empty catch block
            }
            this.writeDD();
            return destinationRefName;
        }

        public MessageDestinationRef createDestinationRef(String className) throws IOException {
            Ejb ejb = this.findEjbForClass(className);
            MessageDestinationRef ref = null;
            if (ejb != null) {
                try {
                    ref = ejb.newMessageDestinationRef();
                }
                catch (VersionNotSupportedException vnse) {
                    IOException ioe = new IOException();
                    ioe.initCause(vnse);
                    throw ioe;
                }
            }
            try {
                ref = (MessageDestinationRef)this.findDD().createBean("MessageDestinationRef");
            }
            catch (ClassNotFoundException cnfe) {
                IOException ioe = new IOException();
                ioe.initCause(cnfe);
                throw ioe;
            }
            return ref;
        }
    }
}

