/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.CompletionJList;
import org.netbeans.modules.editor.completion.CompletionSettings;
import org.netbeans.spi.editor.completion.CompletionItem;

public class CompletionScrollPane
extends JScrollPane {
    private static final String ESCAPE = "escape";
    private static final String COMPLETION_UP = "completion-up";
    private static final String COMPLETION_DOWN = "completion-down";
    private static final String COMPLETION_PGUP = "completion-pgup";
    private static final String COMPLETION_PGDN = "completion-pgdn";
    private static final String COMPLETION_BEGIN = "completion-begin";
    private static final String COMPLETION_END = "completion-end";
    private static final int ACTION_ESCAPE = 0;
    private static final int ACTION_COMPLETION_UP = 1;
    private static final int ACTION_COMPLETION_DOWN = 2;
    private static final int ACTION_COMPLETION_PGUP = 3;
    private static final int ACTION_COMPLETION_PGDN = 4;
    private static final int ACTION_COMPLETION_BEGIN = 5;
    private static final int ACTION_COMPLETION_END = 6;
    private JTextComponent editorComponent;
    private CompletionJList view;
    private JLabel topLabel;

    public CompletionScrollPane(JTextComponent editorComponent, ListSelectionListener listSelectionListener, MouseListener mouseListener) {
        this.editorComponent = editorComponent;
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(20);
        this.setMaximumSize(CompletionSettings.INSTANCE.completionPopupMaximumSize());
        int maxVisibleRowCount = Math.max(2, this.getMaximumSize().height / 16 - 1);
        this.view = new CompletionJList(maxVisibleRowCount, mouseListener);
        if (listSelectionListener != null) {
            this.view.addListSelectionListener(listSelectionListener);
        }
        this.setViewportView(this.view);
        this.installKeybindings();
    }

    public void setData(List data, String title) {
        this.view.setData(data);
        this.setTitle(title);
        this.setViewportView(this.getViewport().getView());
    }

    public CompletionItem getSelectedCompletionItem() {
        Object ret = this.view.getSelectedValue();
        return ret instanceof CompletionItem ? (CompletionItem)ret : null;
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        Dimension maxSize = this.getMaximumSize();
        if (prefSize.width > maxSize.width) {
            prefSize.width = maxSize.width;
        }
        return prefSize;
    }

    private void setTitle(String title) {
        if (title == null) {
            if (this.topLabel != null) {
                this.setColumnHeader(null);
                this.topLabel = null;
            }
        } else if (this.topLabel != null) {
            this.topLabel.setText(title);
        } else {
            this.topLabel = new JLabel(title);
            this.topLabel.setForeground(Color.blue);
            this.topLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.setColumnHeaderView(this.topLabel);
        }
    }

    private KeyStroke[] findEditorKeys(String editorActionName, KeyStroke defaultKey) {
        KeyStroke[] ret = new KeyStroke[]{defaultKey};
        if (this.editorComponent != null) {
            KeyStroke[] keys;
            Action a;
            EditorKit kit;
            TextUI ui = this.editorComponent.getUI();
            Keymap km = this.editorComponent.getKeymap();
            if (ui != null && km != null && (kit = ui.getEditorKit(this.editorComponent)) instanceof BaseKit && (a = ((BaseKit)kit).getActionByName(editorActionName)) != null && (keys = km.getKeyStrokesForAction(a)) != null && keys.length > 0) {
                ret = keys;
            }
        }
        return ret;
    }

    private void registerKeybinding(int action, String actionName, KeyStroke stroke, String editorActionName) {
        KeyStroke[] keys = this.findEditorKeys(editorActionName, stroke);
        for (int i = 0; i < keys.length; ++i) {
            this.getInputMap().put(keys[i], actionName);
        }
        this.getActionMap().put(actionName, new CompletionPaneAction(action));
    }

    private void installKeybindings() {
        this.registerKeybinding(0, ESCAPE, KeyStroke.getKeyStroke(27, 0), ESCAPE);
        this.registerKeybinding(1, COMPLETION_UP, KeyStroke.getKeyStroke(38, 0), "caret-up");
        this.registerKeybinding(2, COMPLETION_DOWN, KeyStroke.getKeyStroke(40, 0), "caret-down");
        this.registerKeybinding(4, COMPLETION_PGDN, KeyStroke.getKeyStroke(34, 0), "page-down");
        this.registerKeybinding(3, COMPLETION_PGUP, KeyStroke.getKeyStroke(33, 0), "page-up");
        this.registerKeybinding(5, COMPLETION_BEGIN, KeyStroke.getKeyStroke(36, 0), "caret-begin-line");
        this.registerKeybinding(6, COMPLETION_END, KeyStroke.getKeyStroke(35, 0), "caret-end-line");
    }

    private class CompletionPaneAction
    extends AbstractAction {
        private int action;

        private CompletionPaneAction(int action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 0: {
                    CompletionImpl.get().hideCompletion();
                    break;
                }
                case 1: {
                    CompletionScrollPane.this.view.up();
                    break;
                }
                case 2: {
                    CompletionScrollPane.this.view.down();
                    break;
                }
                case 3: {
                    CompletionScrollPane.this.view.pageUp();
                    break;
                }
                case 4: {
                    CompletionScrollPane.this.view.pageDown();
                    break;
                }
                case 5: {
                    CompletionScrollPane.this.view.begin();
                    break;
                }
                case 6: {
                    CompletionScrollPane.this.view.end();
                }
            }
        }
    }
}

