/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.lib;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.core.lib.Util;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Mutex;

public final class GuiUtil {
    private GuiUtil() {
    }

    public static void performDefaultAction(FileObject fo) {
        DataObject obj;
        if (fo == null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("FileObject can not be null.", new IllegalArgumentException());
            }
            return;
        }
        try {
            obj = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("DataObject not found", e);
            }
            return;
        }
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                Node node = obj.getNodeDelegate();
                Action a = node.getPreferredAction();
                if (a != null) {
                    a.actionPerformed(new ActionEvent(node, 1001, ""));
                }
            }
        });
    }

    public static boolean confirmAction(String message) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, 0);
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        return option == NotifyDescriptor.YES_OPTION;
    }

    public static void setStatusText(String text) {
        StatusDisplayer.getDefault().setStatusText(text);
    }

    public static void notifyException(Throwable exc) {
        GuiUtil.notifyException(null, exc);
    }

    public static void notifyException(String desc, Throwable ex) {
        ErrorManager err = ErrorManager.getDefault();
        if (desc != null) {
            err.annotate(ex, desc);
        }
        err.notify(4096, ex);
    }

    public static void notifyWarning(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        });
    }

    public static void notifyError(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
        });
    }
}

