/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.Action;
import org.netbeans.modules.tasklist.core.ObservableList;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskListener;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class TaskListNode
extends AbstractNode {
    static /* synthetic */ Class class$org$netbeans$modules$tasklist$core$TaskListNode;

    public TaskListNode(ObservableList tasklist) {
        super((Children)new TaskListChildren(tasklist));
    }

    public TaskListNode(ObservableList tasklist, NodeFactory nodeFactory) {
        super((Children)new TaskListChildren(tasklist));
        TaskListChildren list = (TaskListChildren)this.getChildren();
        list.setNodeFactory(nodeFactory);
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }

    public void destroy() throws IOException {
        Enumeration en = this.getChildren().nodes();
        while (en.hasMoreElements()) {
            Node next = (Node)en.nextElement();
            next.destroy();
        }
        super.destroy();
    }

    static class TaskListChildren
    extends Children.Keys
    implements TaskListener,
    Runnable {
        private ObservableList list;
        private NodeFactory nodeFactory;
        private static int BATCH_INTERVAL_MS;
        private volatile RequestProcessor.Task batchSetKeys;
        private volatile boolean active = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        TaskListChildren(ObservableList list) {
            if (!$assertionsDisabled && list == null) {
                throw new AssertionError();
            }
            this.list = list;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.list.getTasks());
            this.list.addTaskListener(this);
            this.active = true;
        }

        protected void removeNotify() {
            this.active = false;
            this.list.removeTaskListener(this);
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            Task task = (Task)key;
            Node[] nodes = this.nodeFactory == null ? task.createNode() : new Node[]{this.nodeFactory.createNode(task)};
            return nodes;
        }

        public void setNodeFactory(NodeFactory nodeFactory) {
            this.nodeFactory = nodeFactory;
        }

        private void batchSetKeys() {
            if (this.batchSetKeys == null) {
                this.batchSetKeys = RequestProcessor.getDefault().post((Runnable)this, BATCH_INTERVAL_MS);
            }
        }

        public void selectedTask(Task t) {
        }

        public void warpedTask(Task t) {
        }

        public void addedTask(Task t) {
            this.batchSetKeys();
        }

        public void removedTask(Task pt, Task t, int index) {
            this.batchSetKeys();
        }

        public void structureChanged(Task t) {
            this.batchSetKeys();
        }

        public void run() {
            this.batchSetKeys = null;
            if (this.active) {
                this.setKeys(this.list.getTasks());
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$tasklist$core$TaskListNode == null ? (class$org$netbeans$modules$tasklist$core$TaskListNode = TaskListNode.class$("org.netbeans.modules.tasklist.core.TaskListNode")) : class$org$netbeans$modules$tasklist$core$TaskListNode).desiredAssertionStatus();
            BATCH_INTERVAL_MS = 59;
        }
    }

    public static interface NodeFactory {
        public Node createNode(Object var1);
    }
}

