/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.checklist;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.KeyStroke;
import org.netbeans.modules.tasklist.core.checklist.AbstractCheckListModel;
import org.netbeans.modules.tasklist.core.checklist.CheckListModel;
import org.netbeans.modules.tasklist.core.checklist.DefaultCheckListCellRenderer;
import org.netbeans.modules.tasklist.core.checklist.DefaultCheckListModel;

public class CheckList
extends JList {
    private static final long serialVersionUID = 1L;

    public CheckList(CheckListModel dataModel) {
        super(dataModel);
        this.setCellRenderer(new DefaultCheckListCellRenderer());
        CheckAction action = new CheckAction();
        this.getActionMap().put("check", action);
        this.registerKeyboardAction(action, KeyStroke.getKeyStroke(' '), 0);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                CheckListModel model;
                JList list = (JList)e.getComponent();
                int index = list.locationToIndex(e.getPoint());
                if (index < 0) {
                    return;
                }
                if (e.getX() > 15) {
                    return;
                }
                model.setChecked(index, !(model = (CheckListModel)CheckList.this.getModel()).isChecked(index));
                e.consume();
                CheckList.this.repaint();
            }
        });
    }

    public CheckList(boolean[] state, Object[] listData) {
        this(new DefaultCheckListModel(state, listData));
    }

    public CheckList() {
        this(new AbstractCheckListModel(){

            public boolean isChecked(int index) {
                return false;
            }

            public void setChecked(int index, boolean c) {
            }

            public int getSize() {
                return 0;
            }

            public Object getElementAt(int index) {
                return null;
            }
        });
    }

    public void setModel(CheckListModel m) {
        super.setModel(m);
    }

    public static class CheckAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent e) {
            CheckListModel model;
            JList list = (JList)e.getSource();
            int index = list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            model.setChecked(index, !(model = (CheckListModel)list.getModel()).isChecked(index));
        }
    }
}

