/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.util;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;

public class TextPositionsMapper {
    private String text;
    private int[] offsets;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TextPositionsMapper(String text) {
        int i;
        this.text = text;
        BufferedReader br = new BufferedReader(new StringReader(text));
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        offsets.add(new Integer(0));
        for (i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\r') {
                if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                    offsets.add(new Integer(++i + 1));
                    continue;
                }
                offsets.add(new Integer(i + 1));
                continue;
            }
            if (c != '\n') continue;
            offsets.add(new Integer(i + 1));
        }
        this.offsets = new int[offsets.size()];
        for (i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = (Integer)offsets.get(i);
        }
    }

    public void findPosition(int offset, int[] position) {
        if (!$assertionsDisabled && offset < 0) {
            throw new AssertionError((Object)"offset couldn't be negative");
        }
        int index = Arrays.binarySearch(this.offsets, offset);
        if (index >= 0) {
            position[0] = index;
            position[1] = 0;
        } else {
            index = -(index + 1);
            if (!$assertionsDisabled && index == 0) {
                throw new AssertionError((Object)"offset couldn't be negative");
            }
            position[0] = index - 1;
            position[1] = offset - this.offsets[index - 1];
        }
    }

    public String getText() {
        return this.text;
    }

    public String getLine(int line) {
        int offset = this.offsets[line];
        int offset2 = this.offsets.length > line + 1 ? this.offsets[line + 1] : this.text.length();
        return this.text.substring(offset, offset2);
    }

    static {
        $assertionsDisabled = !TextPositionsMapper.class.desiredAssertionStatus();
    }
}

